/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.impl.calc;

public class Numbers {
    public static final byte NULL = -1;
    public static final byte INTEGER = 0;
    public static final byte LONG = 1;
    public static final byte DOUBLE = 2;

    public static byte getTypeBound(Number n) {
        return (byte)(n == null ? -1 : (n instanceof Byte || n instanceof Short || n instanceof Integer ? 0 : (n instanceof Long ? 1 : 2)));
    }

    public static Number divide(Number n, int divisor) {
        if (n == null) {
            return null;
        }
        if (divisor == 0) {
            throw new ArithmeticException("Division by zero");
        }
        switch (Numbers.getTypeBound(n)) {
            case 0: {
                int in = n.intValue();
                if (in % divisor != 0) break;
                return in / divisor;
            }
            case 1: {
                long ln = n.longValue();
                if (ln % (long)divisor != 0L) break;
                return ln / (long)divisor;
            }
        }
        return n.doubleValue() / (double)divisor;
    }

    public static abstract class MixedTypedNumber {
        public byte _type = (byte)-1;
        public int _int = 0;
        public long _long = 0L;
        public double _double = 0.0;

        public MixedTypedNumber() {
            this(0);
        }

        public MixedTypedNumber(int initValue) {
            this(-1, initValue, initValue, initValue);
            this.init();
        }

        public MixedTypedNumber(byte initType, int initInt, long initLong, double initDouble) {
            this._type = initType;
            this._int = initInt;
            this._long = initLong;
            this._double = initDouble;
            this.init();
        }

        protected void init() {
        }

        public void upType(byte newType) {
            if (newType > this._type) {
                if (this._type > -1) {
                    if (newType == 1) {
                        this._long = this._int;
                    } else if (newType == 2) {
                        this._double = this._type == 0 ? (double)this._int : (double)this._long;
                    }
                }
                this._type = newType;
            }
        }

        public void upTypeFor(Number n) {
            this.upType(Numbers.getTypeBound(n));
        }

        public byte getType() {
            return this._type;
        }

        public Number getValue() {
            switch (this._type) {
                case -1: {
                    return null;
                }
                case 0: {
                    return this._int;
                }
                case 1: {
                    return this._long;
                }
            }
            return this._double;
        }

        public void operate(MixedTypedNumber mtn) {
            this.operate(mtn, true);
        }

        public void operate(MixedTypedNumber mtn, boolean autoUpType) {
            if (autoUpType) {
                this.upType(mtn.getType());
            }
            this.operate(mtn.getValue(), false);
        }

        public void operate(Number n) {
            this.operate(n, true);
        }

        public void operate(Number n, boolean autoUpType) {
            if (autoUpType) {
                this.upTypeFor(n);
            }
            switch (this._type) {
                case -1: {
                    break;
                }
                case 0: {
                    this._int = n == null ? this.operateNullInt(this._int) : this.operateInt(this._int, n.intValue());
                    break;
                }
                case 1: {
                    this._long = n == null ? this.operateNullLong(this._long) : this.operateLong(this._long, n.longValue());
                    break;
                }
                default: {
                    this._double = n == null ? this.operateNullDouble(this._double) : this.operateDouble(this._double, n.doubleValue());
                }
            }
        }

        protected abstract int operateInt(int var1, int var2);

        protected abstract long operateLong(long var1, long var3);

        protected abstract double operateDouble(double var1, double var3);

        protected int operateNullInt(int operand1) {
            return operand1;
        }

        protected long operateNullLong(long operand1) {
            return operand1;
        }

        protected double operateNullDouble(double operand1) {
            return operand1;
        }
    }
}

