/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.impl.calc;

import org.zkoss.pivot.impl.calc.Context;
import org.zkoss.pivot.impl.calc.ContextFactory;
import org.zkoss.pivot.impl.calc.Numbers;

public class MinMaxContext
implements Context<MinMaxContext> {
    protected Numbers.MixedTypedNumber _max = new Numbers.MixedTypedNumber(-1, Integer.MIN_VALUE, Long.MIN_VALUE, Double.NEGATIVE_INFINITY){

        @Override
        protected int operateInt(int operand1, int operand2) {
            return Math.max(operand1, operand2);
        }

        @Override
        protected long operateLong(long operand1, long operand2) {
            return Math.max(operand1, operand2);
        }

        @Override
        protected double operateDouble(double operand1, double operand2) {
            return Math.max(operand1, operand2);
        }
    };
    protected Numbers.MixedTypedNumber _min = new Numbers.MixedTypedNumber(-1, Integer.MAX_VALUE, Long.MAX_VALUE, Double.POSITIVE_INFINITY){

        @Override
        protected int operateInt(int operand1, int operand2) {
            return Math.min(operand1, operand2);
        }

        @Override
        protected long operateLong(long operand1, long operand2) {
            return Math.min(operand1, operand2);
        }

        @Override
        protected double operateDouble(double operand1, double operand2) {
            return Math.min(operand1, operand2);
        }
    };
    public static final ContextFactory<MinMaxContext> FACTORY = new ContextFactory<MinMaxContext>(){

        public MinMaxContext create() {
            return new MinMaxContext();
        }
    };

    @Override
    public void add(Object item) {
        if (item != null && item instanceof Number) {
            Number n = (Number)item;
            this._max.operate(n);
            this._min.operate(n);
        }
    }

    @Override
    public void merge(MinMaxContext ctx) {
        this._max.operate(ctx._max);
        this._min.operate(ctx._min);
    }

    public Number getMax() {
        return this._max.getValue();
    }

    public Number getMin() {
        return this._min.getValue();
    }
}

