/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.lang.Library;
import org.zkoss.pivot.Calculator;
import org.zkoss.pivot.PivotField;
import org.zkoss.pivot.PivotHeaderNode;
import org.zkoss.pivot.PivotHeaderTree;
import org.zkoss.pivot.PivotModelExt;
import org.zkoss.pivot.event.FieldDataEvent;
import org.zkoss.pivot.event.FieldDataListener;
import org.zkoss.pivot.impl.AbstractPivotModel;
import org.zkoss.pivot.impl.CalculatorContextSignature;
import org.zkoss.pivot.impl.SimplePivotHeaderNode;
import org.zkoss.pivot.impl.SimplePivotHeaderTree;
import org.zkoss.pivot.impl.StandardCalculator;
import org.zkoss.pivot.impl.StandardContextType;
import org.zkoss.pivot.impl.TabularPivotField;
import org.zkoss.pivot.impl.calc.Context;
import org.zkoss.pivot.impl.calc.ContextType;
import org.zkoss.pivot.impl.calc.ContextualCalculator;
import org.zkoss.pivot.util.Trees;

public class TabularPivotModel
extends AbstractPivotModel
implements PivotModelExt,
PivotModelExt.SortCtrl {
    private static final long serialVersionUID = 201002110924L;
    private final Iterable<? extends List<?>> _rawData;
    private final List<TabularPivotField> _fields = new ArrayList<TabularPivotField>();
    private final Map<PivotField.Type, List<TabularPivotField>> _fieldMap = new HashMap<PivotField.Type, List<TabularPivotField>>();
    private final Map<TabularPivotField, FieldDataListener> _fieldListeners = new HashMap<TabularPivotField, FieldDataListener>();
    protected final CalculatorContextSpace _space;
    private final boolean _openRowTreeOnInit;
    private final boolean _openColumnTreeOnInit;
    private SimplePivotHeaderTree _rowTree;
    private SimplePivotHeaderTree _colTree;
    private boolean _schemeDirty;
    private boolean _dataDirty;
    private TabularPivotField[] _dataFields;
    private final Set<ContextualCalculator<?>> _customCals = new HashSet();
    protected static final int _STD_CAL_TYPE_SIZE = StandardContextType.values().length;
    protected static final Comparator<PivotHeaderNode> NODE_COMPARATOR = new Comparator<PivotHeaderNode>(){

        @Override
        public int compare(PivotHeaderNode n1, PivotHeaderNode n2) {
            TabularPivotField pf = (TabularPivotField)n1.getField();
            Object k1 = n1.getKey();
            Object k2 = n2.getKey();
            return pf.getComparator().compare(k1, k2);
        }
    };

    public TabularPivotModel(Iterable<? extends List<?>> data, List<String> columns) {
        if (data == null || columns == null) {
            throw new IllegalArgumentException();
        }
        this._rawData = data;
        this._openColumnTreeOnInit = "true".equals(Library.getProperty((String)"org.zkoss.pivot.pivotModel.columnOpenOnInit"));
        this._openRowTreeOnInit = "true".equals(Library.getProperty((String)"org.zkoss.pivot.pivotModel.rowOpenOnInit"));
        this._space = new CalculatorContextSpace(this);
        this.initFields(columns);
    }

    private void initFields(List<String> columns) {
        for (PivotField.Type t : PivotField.Type.values()) {
            this._fieldMap.put(t, new ArrayList());
        }
        List<TabularPivotField> unused = this._fieldMap.get((Object)PivotField.Type.UNUSED);
        int i = 0;
        for (String name : columns) {
            TabularPivotField tpf = new TabularPivotField(name);
            tpf.setType(PivotField.Type.UNUSED);
            tpf.setSourceDataIndex(i++);
            this._fields.add(tpf);
            unused.add(tpf);
            FieldDataListener listener = new FieldDataListener(){

                @Override
                public void onChange(FieldDataEvent event) {
                    TabularPivotModel.this._schemeDirty = true;
                    TabularPivotModel.this._dataFields = null;
                    TabularPivotModel.this.fireEvent();
                }
            };
            this._fieldListeners.put(tpf, listener);
            tpf.addFieldDataListener(listener);
        }
        this._schemeDirty = true;
    }

    public Iterable<? extends List<?>> getRawData() {
        return this._rawData;
    }

    public void setFieldType(String fieldName, PivotField.Type type) {
        this.setFieldType(this.getField(fieldName), type);
    }

    @Override
    public void setFieldType(PivotField field, PivotField.Type type, int index) {
        this.setFieldType0(field, type, index);
        this.fireEvent();
    }

    @Override
    public void setFieldType(PivotField field, PivotField.Type type) {
        this.setFieldType0(field, type, -1);
        this.fireEvent();
    }

    private void setFieldType0(PivotField field, PivotField.Type type, int index) {
        PivotField.Type oldtype;
        TabularPivotField tpf = this.cast(field);
        if (type == null) {
            type = PivotField.Type.UNUSED;
        }
        if (!this._fieldMap.get((Object)(oldtype = tpf.getType())).remove(tpf)) {
            throw new IllegalStateException("Pivot field type out of sync.");
        }
        if (index < 0) {
            this._fieldMap.get((Object)type).add(tpf);
        } else {
            this._fieldMap.get((Object)type).add(index, tpf);
        }
        tpf.setType(type);
        this._schemeDirty = true;
        if (oldtype == PivotField.Type.DATA || type == PivotField.Type.DATA) {
            this._dataFields = null;
        }
        if (oldtype == PivotField.Type.DATA && type == PivotField.Type.UNUSED) {
            this._space.update(true);
        }
    }

    public int getSourceDataIndex(PivotField field) {
        return this.cast(field).getSourceDataIndex();
    }

    public final TabularPivotField[] getRowFields() {
        return this.getFields(PivotField.Type.ROW);
    }

    public final TabularPivotField[] getColumnFields() {
        return this.getFields(PivotField.Type.COLUMN);
    }

    public final TabularPivotField[] getDataFields() {
        return this.getFields(PivotField.Type.DATA);
    }

    public TabularPivotField[] getFields(PivotField.Type type) {
        if (type == PivotField.Type.DATA) {
            if (this._dataFields == null) {
                this._dataFields = this._fieldMap.get((Object)type).toArray(new TabularPivotField[0]);
            }
            return this._dataFields;
        }
        return this._fieldMap.get((Object)type).toArray(new TabularPivotField[0]);
    }

    public TabularPivotField[] getFields() {
        return this._fields.toArray(new TabularPivotField[0]);
    }

    public TabularPivotField getField(String fieldName) {
        for (TabularPivotField pf : this._fields) {
            if (!fieldName.equals(pf.getFieldName())) continue;
            return pf;
        }
        return null;
    }

    public void removeField(String fieldName) {
        this.removeField(this.getField(fieldName));
    }

    public void removeField(PivotField field) {
        this.setFieldType(field, PivotField.Type.UNUSED);
    }

    public void clearAllFields(boolean complete) {
        for (TabularPivotField tpf : this._fields) {
            this.setFieldType0(tpf, PivotField.Type.UNUSED, -1);
            if (!complete) continue;
            tpf.setSummary(null);
            tpf.setSubtotals(null);
            tpf.setGroupHandler(null);
            tpf.setKeyComparator(null);
        }
        this._schemeDirty = true;
        this.fireEvent();
    }

    public void setFieldKeyOrder(String fieldName, boolean ascending) {
        this.setFieldKeyOrder(this.getField(fieldName), ascending);
    }

    @Override
    public void setFieldKeyOrder(PivotField field, boolean ascending) {
        this.cast(field).setKeyOrder(ascending);
        this._schemeDirty = true;
        this.fireEvent();
    }

    public void setFieldKeyComparator(String fieldName, Comparator<Object> comparator) {
        this.setFieldKeyComparator(this.getField(fieldName), comparator);
    }

    @Override
    public void setFieldKeyComparator(PivotField field, Comparator<Object> comparator) {
        this.cast(field).setKeyComparator(comparator);
        this._schemeDirty = true;
        this.fireEvent();
    }

    public void updateRawData() {
        this._dataDirty = true;
    }

    @Override
    public Calculator[] getSupportedCalculators() {
        StandardCalculator[] stds = StandardCalculator.values();
        ArrayList res = new ArrayList(_STD_CAL_TYPE_SIZE + this._customCals.size());
        res.addAll(Arrays.asList(stds));
        res.addAll(this._customCals);
        return res.toArray(new Calculator[0]);
    }

    public void addSupportedCalculator(ContextualCalculator<?> cal) {
        this._customCals.add(cal);
    }

    public void removeSupportedCalculator(ContextualCalculator<?> cal) {
        this._customCals.remove(cal);
    }

    public void clearSupportedCalculators() {
        this._customCals.clear();
    }

    public void setFieldSummary(String fieldName, Calculator summary) {
        this.getField(fieldName).setSummary(summary);
    }

    @Override
    public void setFieldSummary(PivotField field, Calculator summary) {
        this.cast(field).setSummary(summary);
    }

    public void setFieldSubtotals(String fieldName, Calculator[] subtotals) {
        this.getField(fieldName).setSubtotals(subtotals);
    }

    @Override
    public void setFieldSubtotals(PivotField field, Calculator[] subtotals) {
        this.cast(field).setSubtotals(subtotals);
    }

    protected final void updateContextSpace() {
        if (!this._schemeDirty && !this._dataDirty) {
            return;
        }
        SimplePivotHeaderTree[] trees = this._space.update(this._dataDirty);
        this._rowTree = trees[0];
        this._colTree = trees[1];
        this.sortRowTree(this._rowTree);
        this.sortColumnTree(this._colTree);
        if (this._openColumnTreeOnInit) {
            Trees.openDown(this._colTree.getRoot(), true);
        }
        if (this._openRowTreeOnInit) {
            Trees.openDown(this._rowTree.getRoot(), true);
        }
        this._schemeDirty = false;
        this._dataDirty = false;
    }

    protected void sortRowTree(SimplePivotHeaderTree rowTree) {
        rowTree.sort(NODE_COMPARATOR);
    }

    protected void sortColumnTree(SimplePivotHeaderTree colTree) {
        colTree.sort(NODE_COMPARATOR);
    }

    @Deprecated
    protected void sortTrees() {
        this.sortRowTree(this._rowTree);
        this.sortColumnTree(this._colTree);
    }

    protected void iterateRawData(SimplePivotHeaderTree colTree, SimplePivotHeaderTree rowTree, RawDataRunner runner) {
        for (List<?> row : this._rawData) {
            runner.run(row, rowTree, colTree);
        }
    }

    @Override
    public Number getValue(PivotHeaderNode rowNode, int rowCalIndex, PivotHeaderNode colNode, int colCalIndex, int dataIndex) {
        ContextualCalculator<?> cal;
        boolean cRoot;
        SimplePivotHeaderNode srNode = this.cast(rowNode);
        SimplePivotHeaderNode scNode = this.cast(colNode);
        boolean rRoot = rowNode == null || Trees.isRoot(rowNode);
        boolean bl = cRoot = colNode == null || Trees.isRoot(colNode);
        if (rRoot && cRoot) {
            dataIndex = this._space.getOverallGrandtotalIdxMapping(dataIndex);
        }
        if ((cal = this.getCalculator(srNode, rowCalIndex, scNode, colCalIndex, dataIndex)) == null) {
            return null;
        }
        Context<?> ctx = this._space.getGroup(srNode, scNode, true).getContext(dataIndex, cal);
        return cal.getResult(ctx);
    }

    protected final ContextualCalculator<?> getCalculator(SimplePivotHeaderNode rowNode, int rowCalIndex, SimplePivotHeaderNode colNode, int colCalIndex, int dataIndex) {
        ContextualCalculator<?> calC;
        boolean csmry;
        boolean rsmry = rowCalIndex < 0 || Trees.isRoot(rowNode);
        boolean bl = csmry = colCalIndex < 0 || Trees.isRoot(colNode);
        if (rsmry) {
            if (csmry) {
                return this.cast(this.getDataFields()[dataIndex].getSummary());
            }
            return this.cast(colNode.getField().getSubtotal(colCalIndex));
        }
        if (csmry) {
            return this.cast(rowNode.getField().getSubtotal(rowCalIndex));
        }
        ContextualCalculator<?> calR = this.cast(rowNode.getField().getSubtotal(rowCalIndex));
        return calR == (calC = this.cast(colNode.getField().getSubtotal(colCalIndex))) ? calR : null;
    }

    @Override
    public PivotHeaderTree getColumnHeaderTree() {
        this.updateContextSpace();
        return this._colTree;
    }

    @Override
    public PivotHeaderTree getRowHeaderTree() {
        this.updateContextSpace();
        return this._rowTree;
    }

    protected CalculatorContextSignature getCalculatorContextSignature() {
        return new CalculatorContextSignature(this);
    }

    protected boolean shallReloadSourceSpace(CalculatorContextSignature current, CalculatorContextSignature required) {
        return false;
    }

    protected TabularPivotField cast(PivotField field) {
        if (!(field instanceof TabularPivotField) || !this._fields.contains(field)) {
            throw new IllegalArgumentException("The field does not belong to this PivotModel: " + field.getFieldName());
        }
        return (TabularPivotField)field;
    }

    protected SimplePivotHeaderNode cast(PivotHeaderNode node) {
        if (!(node instanceof SimplePivotHeaderNode)) {
            throw new IllegalArgumentException("The node does not belong to this PivotModel: " + node);
        }
        return (SimplePivotHeaderNode)node;
    }

    protected ContextualCalculator<?> cast(Calculator calc) {
        if (!(calc instanceof ContextualCalculator)) {
            throw new IllegalArgumentException("The calculator does not belong to this PivotModel: " + calc);
        }
        return (ContextualCalculator)calc;
    }

    protected static class CalculatorContextSpace
    implements RawDataRunner {
        protected final TabularPivotModel _model;
        protected final Map<String, CalculatorContextGroup> _source = new HashMap<String, CalculatorContextGroup>();
        protected final Map<String, CalculatorContextGroup> _base = new HashMap<String, CalculatorContextGroup>();
        protected final Map<String, CalculatorContextGroup> _derived = new HashMap<String, CalculatorContextGroup>();
        protected TabularPivotField[] _colPF;
        protected TabularPivotField[] _rowPF;
        protected TabularPivotField[] _dataPF;
        protected TabularPivotField[] _srcRCPF;
        protected TabularPivotField[] _srcDataPF;
        protected int _rfs;
        protected int _cfs;
        protected int _rcfs;
        protected int _dfs;
        protected boolean _rfs0;
        protected boolean _cfs0;
        protected CalculatorContextSignature _srcSig;
        protected CalculatorContextSignature _baseSig;
        protected boolean _delegateSrc;
        private int[] _overallGrandtotalIdxMapping;

        protected CalculatorContextSpace(TabularPivotModel model) {
            this._model = model;
        }

        protected SimplePivotHeaderTree[] update(boolean force) {
            boolean reloadSrc;
            this.refreshPivotScheme();
            this._derived.clear();
            this._base.clear();
            SimplePivotHeaderTree rowTree = new SimplePivotHeaderTree(this._rowPF);
            SimplePivotHeaderTree colTree = new SimplePivotHeaderTree(this._colPF);
            CalculatorContextSignature msign = this._model.getCalculatorContextSignature();
            this._delegateSrc = reloadSrc = force || this._srcSig == null || !this._srcSig.covers(msign) || this._model.shallReloadSourceSpace(this._srcSig, msign);
            if (!reloadSrc) {
                this._baseSig = msign;
                this.iterateSource(rowTree, colTree);
            } else {
                this.refreshSourceFieldInfo();
                this._baseSig = this._srcSig = msign;
                this._source.clear();
                this._model.iterateRawData(colTree, rowTree, this);
            }
            return new SimplePivotHeaderTree[]{rowTree, colTree};
        }

        @Override
        public void run(List<?> row, SimplePivotHeaderTree rowTree, SimplePivotHeaderTree colTree) {
            this._overallGrandtotalIdxMapping = null;
            Object[] keys = this.getKeys(row);
            SimplePivotHeaderNode rowNode = rowTree.appendKey(keys, 0);
            SimplePivotHeaderNode colNode = colTree.appendKey(keys, this._rfs);
            Context<?>[] ctxes = this.getSourceGroup((SimplePivotHeaderNode)rowNode, (SimplePivotHeaderNode)colNode, (boolean)true, (Object[])keys)._ctx;
            Context<?>[] ctxes00 = this.getSourceGroup(null, null, (boolean)true, null)._ctx;
            Context<?>[] ctxes0c = this.getBaseGroup(null, (SimplePivotHeaderNode)colNode, (boolean)true)._ctx;
            Context<?>[] ctxesr0 = this.getBaseGroup((SimplePivotHeaderNode)rowNode, null, (boolean)true)._ctx;
            boolean rowFLC = !this._model._openRowTreeOnInit && this._rfs > 1;
            boolean colFLC = !this._model._openColumnTreeOnInit && this._cfs > 1;
            Context<?>[] ctxesr1 = !rowFLC ? null : this.getDerivedGroup((SimplePivotHeaderNode)CalculatorContextSpace.getFirstLevel((SimplePivotHeaderNode)rowNode), null, (boolean)true, (boolean)false)._ctx;
            Context<?>[] ctxes1c = !colFLC ? null : this.getDerivedGroup(null, (SimplePivotHeaderNode)CalculatorContextSpace.getFirstLevel((SimplePivotHeaderNode)colNode), (boolean)true, (boolean)false)._ctx;
            int index = 0;
            for (int i = 0; i < this._dfs; ++i) {
                Object obj = CalculatorContextSpace.getData(row, this._dataPF[i]);
                int j = 0;
                while (j < this._srcSig.getTotalContextTypeCount()) {
                    if (j >= _STD_CAL_TYPE_SIZE || this._srcSig.getStandardContextTypeRequirement()[j]) {
                        ctxes[index].add(obj);
                        if (!this._rfs0 || !this._cfs0) {
                            ctxes00[index].add(obj);
                        }
                        if (!this._rfs0 && !this._cfs0) {
                            ctxesr0[index].add(obj);
                            ctxes0c[index].add(obj);
                        }
                        if (rowFLC) {
                            ctxesr1[index].add(obj);
                        }
                        if (colFLC) {
                            ctxes1c[index].add(obj);
                        }
                    }
                    ++j;
                    ++index;
                }
            }
        }

        protected void iterateSource(SimplePivotHeaderTree rowTree, SimplePivotHeaderTree colTree) {
            boolean colFLC;
            int i;
            int[] rowSrci = new int[this._rfs];
            for (int i2 = 0; i2 < this._rfs; ++i2) {
                rowSrci[i2] = this.searchSourceRCField(this._rowPF[i2]);
            }
            int[] colSrci = new int[this._cfs];
            for (int i3 = 0; i3 < this._cfs; ++i3) {
                colSrci[i3] = this.searchSourceRCField(this._colPF[i3]);
            }
            int[] dataSrci = new int[this._dfs];
            for (int i4 = 0; i4 < this._dfs; ++i4) {
                dataSrci[i4] = this.searchSourceDataField(this._dataPF[i4]);
            }
            this._overallGrandtotalIdxMapping = Arrays.copyOf(dataSrci, dataSrci.length);
            int[] calTypeSrci = new int[this._baseSig.getTotalContextTypeCount()];
            for (i = 0; i < _STD_CAL_TYPE_SIZE; ++i) {
                calTypeSrci[i] = i;
            }
            for (i = 0; i < this._baseSig.getCustomContextTypeCount(); ++i) {
                calTypeSrci[TabularPivotModel._STD_CAL_TYPE_SIZE + i] = _STD_CAL_TYPE_SIZE + this._srcSig.getIndexOf(this._baseSig.getCustomContextType(i));
            }
            Object[] rowKeys = new Object[this._rfs];
            Object[] colKeys = new Object[this._cfs];
            boolean rowFLC = !this._model._openRowTreeOnInit && this._rfs > 1;
            boolean bl = colFLC = !this._model._openColumnTreeOnInit && this._cfs > 1;
            if (this._rfs0 && this._cfs0) {
                return;
            }
            for (Map.Entry<String, CalculatorContextGroup> e : this._source.entrySet()) {
                int i5;
                CalculatorContextGroup srcgroup = e.getValue();
                Object[] keys = srcgroup._keys;
                if (keys == null) continue;
                for (i5 = 0; i5 < this._rfs; ++i5) {
                    rowKeys[i5] = keys[rowSrci[i5]];
                }
                for (i5 = 0; i5 < this._cfs; ++i5) {
                    colKeys[i5] = keys[colSrci[i5]];
                }
                SimplePivotHeaderNode rowNode = rowTree.appendKey(rowKeys, 0);
                SimplePivotHeaderNode colNode = colTree.appendKey(colKeys, 0);
                Context<?>[] sctxes = srcgroup._ctx;
                Context<?>[] bctxes = this.getBaseGroup((SimplePivotHeaderNode)rowNode, (SimplePivotHeaderNode)colNode, (boolean)true)._ctx;
                Context<?>[] bctxesr0 = this.getBaseGroup((SimplePivotHeaderNode)rowNode, null, (boolean)true)._ctx;
                Context<?>[] bctxes0c = this.getBaseGroup(null, (SimplePivotHeaderNode)colNode, (boolean)true)._ctx;
                Context<?>[] bctxesr1 = !rowFLC ? null : this.getDerivedGroup((SimplePivotHeaderNode)CalculatorContextSpace.getFirstLevel((SimplePivotHeaderNode)rowNode), null, (boolean)true, (boolean)false)._ctx;
                Context<?>[] bctxes1c = !colFLC ? null : this.getDerivedGroup(null, (SimplePivotHeaderNode)CalculatorContextSpace.getFirstLevel((SimplePivotHeaderNode)colNode), (boolean)true, (boolean)false)._ctx;
                boolean[] baseCalCtxs = this._baseSig.getStandardContextTypeRequirement();
                int baseTotalCtxCount = this._baseSig.getTotalContextTypeCount();
                int index = 0;
                for (int i6 = 0; i6 < this._dfs; ++i6) {
                    int srci = dataSrci[i6];
                    int off = srci * this._srcSig.getTotalContextTypeCount();
                    int j = 0;
                    while (j < baseTotalCtxCount) {
                        if (j >= _STD_CAL_TYPE_SIZE || baseCalCtxs[j]) {
                            Context<?> sctx = sctxes[off + calTypeSrci[j]];
                            bctxes[index].merge(sctx);
                            if (!this._rfs0 && !this._cfs0) {
                                bctxesr0[index].merge(sctx);
                                bctxes0c[index].merge(sctx);
                            }
                            if (rowFLC) {
                                bctxesr1[index].merge(sctx);
                            }
                            if (colFLC) {
                                bctxes1c[index].merge(sctx);
                            }
                        }
                        ++j;
                        ++index;
                    }
                }
            }
        }

        public int getOverallGrandtotalIdxMapping(int idx) {
            if (this._overallGrandtotalIdxMapping == null) {
                return idx;
            }
            return this._overallGrandtotalIdxMapping[idx];
        }

        protected final int searchSourceRCField(PivotField f) {
            for (int j = 0; j < this._srcRCPF.length; ++j) {
                if (f != this._srcRCPF[j]) continue;
                return j;
            }
            throw new IllegalStateException("Field not found in source context: " + f);
        }

        protected final int searchSourceDataField(PivotField f) {
            for (int j = 0; j < this._srcDataPF.length; ++j) {
                if (f != this._srcDataPF[j]) continue;
                return j;
            }
            throw new IllegalStateException("Field not found in source context: " + f);
        }

        protected static final SimplePivotHeaderNode getFirstLevel(SimplePivotHeaderNode node) {
            for (int i = node.getDepth(); i > 1; --i) {
                node = node.getParent();
            }
            return node;
        }

        protected final void refreshPivotScheme() {
            this._rowPF = this._model.getRowFields();
            this._colPF = this._model.getColumnFields();
            this._dataPF = this._model.getDataFields();
            this._rfs = this._rowPF.length;
            this._cfs = this._colPF.length;
            this._rcfs = this._rfs + this._cfs;
            this._dfs = this._dataPF.length;
            this._rfs0 = this._rfs == 0;
            this._cfs0 = this._cfs == 0;
        }

        protected final void refreshSourceFieldInfo() {
            int i;
            this._srcRCPF = new TabularPivotField[this._rcfs];
            for (i = 0; i < this._rfs; ++i) {
                this._srcRCPF[i] = this._rowPF[i];
            }
            for (i = 0; i < this._cfs; ++i) {
                this._srcRCPF[this._rfs + i] = this._colPF[i];
            }
            this._srcDataPF = new TabularPivotField[this._dfs];
            for (i = 0; i < this._dfs; ++i) {
                this._srcDataPF[i] = this._dataPF[i];
            }
        }

        protected final Object[] getKeys(List<?> row) {
            Object[] keys = new Object[this._rcfs];
            for (int i = 0; i < this._rcfs; ++i) {
                keys[i] = CalculatorContextSpace.getData(row, this._srcRCPF[i]);
            }
            return keys;
        }

        protected static final Object getData(List<?> row, TabularPivotField field) {
            return row.get(field.getSourceDataIndex());
        }

        protected CalculatorContextGroup getSourceGroup(SimplePivotHeaderNode rowNode, SimplePivotHeaderNode colNode, boolean autoCreate, Object[] keys) {
            String hash = CalculatorContextSpace.getHash(rowNode, colNode);
            CalculatorContextGroup g = this._source.get(hash);
            if (g == null && autoCreate) {
                g = new CalculatorContextGroup(this, keys);
                this._source.put(hash, g);
            }
            return g;
        }

        protected CalculatorContextGroup getBaseGroup(SimplePivotHeaderNode rowNode, SimplePivotHeaderNode colNode, boolean autoCreate) {
            boolean cRoot;
            boolean rRoot = rowNode == null || rowNode.isRoot();
            boolean bl = cRoot = colNode == null || colNode.isRoot();
            if (rRoot && cRoot || this._delegateSrc && (this._cfs0 || this._rfs0 || !rRoot && !cRoot)) {
                return this.getSourceGroup(rowNode, colNode, false, null);
            }
            String hash = CalculatorContextSpace.getHash(rowNode, colNode);
            CalculatorContextGroup g = this._base.get(hash);
            if (g == null && autoCreate) {
                g = new CalculatorContextGroup(this, null);
                this._base.put(hash, g);
            }
            return g;
        }

        protected CalculatorContextGroup getDerivedGroup(SimplePivotHeaderNode rowNode, SimplePivotHeaderNode colNode, boolean cache, boolean merge) {
            String hash = CalculatorContextSpace.getHash(rowNode, colNode);
            CalculatorContextGroup g = this._derived.get(hash);
            if (g == null) {
                g = new CalculatorContextGroup(this, null);
                if (merge) {
                    this.mergeGroup(g, rowNode, colNode);
                }
                if (cache) {
                    this._derived.put(hash, g);
                }
            }
            return g;
        }

        protected static final String getHash(SimplePivotHeaderNode rowNode, SimplePivotHeaderNode colNode) {
            return (rowNode == null ? "" : rowNode.getHash()) + "$" + (colNode == null ? "" : colNode.getHash());
        }

        protected void mergeGroup(CalculatorContextGroup m, SimplePivotHeaderNode rowNode, SimplePivotHeaderNode colNode) {
            if (rowNode.isLeaf() || rowNode.isRoot()) {
                if (colNode.isLeaf() || colNode.isRoot()) {
                    m.merge(this.getBaseGroup(rowNode, colNode, false));
                } else {
                    for (SimplePivotHeaderNode cn : colNode.getChildren()) {
                        this.mergeGroup(m, rowNode, cn);
                    }
                }
            } else if (colNode.isLeaf() || colNode.isRoot()) {
                for (SimplePivotHeaderNode rn : rowNode.getChildren()) {
                    this.mergeGroup(m, rn, colNode);
                }
            } else {
                for (SimplePivotHeaderNode cn : colNode.getChildren()) {
                    this.mergeGroup(m, rowNode, cn);
                }
            }
        }

        protected CalculatorContextGroup getGroup(SimplePivotHeaderNode rowNode, SimplePivotHeaderNode colNode, boolean cache) {
            if ((rowNode.isRoot() || rowNode.isLeaf()) && (colNode.isRoot() || colNode.isLeaf())) {
                CalculatorContextGroup g = this.getBaseGroup(rowNode, colNode, false);
                return g != null ? g : new CalculatorContextGroup(this, null);
            }
            return this.getDerivedGroup(rowNode, colNode, cache, true);
        }

        private static void merge(Context c1, Context c2) {
            c1.merge(c2);
        }

        private static class CalculatorContextGroup {
            private final Object[] _keys;
            private final Context<?>[] _ctx;
            private final CalculatorContextSignature _sig;

            private CalculatorContextGroup(CalculatorContextSpace space, Object[] keys) {
                this._keys = keys;
                this._sig = keys == null ? space._baseSig : space._srcSig;
                boolean[] _cals = this._sig.getStandardContextTypeRequirement();
                this._ctx = new Context[this._sig.getDataFieldCount() * this._sig.getTotalContextTypeCount()];
                int index = 0;
                for (int i = 0; i < this._sig.getDataFieldCount(); ++i) {
                    int j = 0;
                    while (j < _STD_CAL_TYPE_SIZE) {
                        if (_cals[j]) {
                            this._ctx[index] = StandardContextType.create(j);
                        }
                        ++j;
                        ++index;
                    }
                    j = 0;
                    while (j < this._sig.getCustomContextTypeCount()) {
                        this._ctx[index] = this._sig.getCustomContextType(j).create();
                        ++j;
                        ++index;
                    }
                }
            }

            public void merge(CalculatorContextGroup group) {
                if (group == null) {
                    return;
                }
                boolean[] _cals = this._sig.getStandardContextTypeRequirement();
                int totalCtxCount = this._sig.getTotalContextTypeCount();
                int index = 0;
                for (int i = 0; i < this._sig.getDataFieldCount(); ++i) {
                    int j = 0;
                    while (j < totalCtxCount) {
                        if (j >= _STD_CAL_TYPE_SIZE || _cals[j]) {
                            CalculatorContextSpace.merge(this._ctx[index], group._ctx[index]);
                        }
                        ++j;
                        ++index;
                    }
                }
            }

            public Context<?> getContext(int dataIndex, ContextualCalculator<?> calc) {
                ContextType<?> type = calc.getContextType();
                int ordinal = type instanceof StandardContextType ? ((StandardContextType)type).ordinal() : _STD_CAL_TYPE_SIZE + this._sig.getIndexOf(type);
                return this._ctx[dataIndex * this._sig.getTotalContextTypeCount() + ordinal];
            }
        }
    }

    protected static interface RawDataRunner {
        public void run(List<?> var1, SimplePivotHeaderTree var2, SimplePivotHeaderTree var3);
    }
}

