/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.impl;

import org.zkoss.pivot.impl.StandardContextType;
import org.zkoss.pivot.impl.calc.AverageSummarizer;
import org.zkoss.pivot.impl.calc.Context;
import org.zkoss.pivot.impl.calc.ContextualCalculator;
import org.zkoss.pivot.impl.calc.CountNumberSummarizer;
import org.zkoss.pivot.impl.calc.CountSummarizer;
import org.zkoss.pivot.impl.calc.MaxSummarizer;
import org.zkoss.pivot.impl.calc.MinSummarizer;
import org.zkoss.pivot.impl.calc.ProductSummarizer;
import org.zkoss.pivot.impl.calc.StandardDeviationPSummarizer;
import org.zkoss.pivot.impl.calc.StandardDeviationSummarizer;
import org.zkoss.pivot.impl.calc.SumOrCountSummarizer;
import org.zkoss.pivot.impl.calc.SumSummarizer;
import org.zkoss.pivot.impl.calc.Summarizer;
import org.zkoss.pivot.impl.calc.VariancePSummarizer;
import org.zkoss.pivot.impl.calc.VarianceSummarizer;
import org.zkoss.util.resource.Labels;

public enum StandardCalculator implements ContextualCalculator
{
    SUM(new SumSummarizer(), StandardContextType.SUM_COUNT, "Sum", "sum"),
    COUNT(new CountSummarizer(), StandardContextType.SUM_COUNT, "Count", "count"),
    AVERAGE(new AverageSummarizer(), StandardContextType.SUM_COUNT, "Average", "average"),
    MAX(new MaxSummarizer(), StandardContextType.MIN_MAX, "Max", "max"),
    MIN(new MinSummarizer(), StandardContextType.MIN_MAX, "Min", "min"),
    SUM_OR_COUNT(new SumOrCountSummarizer(), StandardContextType.SUM_COUNT, "Sum or Count", "sumOrCount"),
    COUNT_NUMBER(new CountNumberSummarizer(), StandardContextType.SUM_COUNT, "Count Number", "countNumber"),
    PRODUCT(new ProductSummarizer(), StandardContextType.PRODUCT, "Product", "product"),
    STD_DEV(new StandardDeviationSummarizer(), StandardContextType.VARIANCE, "Std Dev", "stdDev"),
    STD_DEV_P(new StandardDeviationPSummarizer(), StandardContextType.VARIANCE, "Std Dev P", "stdDevP"),
    VARIANCE(new VarianceSummarizer(), StandardContextType.VARIANCE, "Variance", "var"),
    VARIANCE_P(new VariancePSummarizer(), StandardContextType.VARIANCE, "Variance P", "varP");

    private final String _label;
    private final String _labelKey;
    private final Summarizer _engine;
    private final StandardContextType _ctxType;

    private StandardCalculator(Summarizer<?> engine, StandardContextType contextType, String label, String labelKey) {
        this._engine = engine;
        this._ctxType = contextType;
        this._label = label;
        this._labelKey = "pivot.calculator." + labelKey;
    }

    public Number getResult(Context context) {
        return this._engine.getResult(context);
    }

    public StandardContextType getContextType() {
        return this._ctxType;
    }

    @Override
    public String getLabel() {
        String value = Labels.getLabel((String)this._labelKey);
        return value != null ? value : this._label;
    }

    @Override
    public String getLabelKey() {
        return this._labelKey;
    }
}

