/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.zkoss.json.JSONArray;
import org.zkoss.json.JSONObject;
import org.zkoss.lang.Library;
import org.zkoss.pivot.PivotField;
import org.zkoss.pivot.PivotHeaderContext;
import org.zkoss.pivot.PivotHeaderNode;
import org.zkoss.pivot.PivotHeaderTree;
import org.zkoss.pivot.PivotModel;
import org.zkoss.pivot.PivotRenderer;
import org.zkoss.pivot.PivotRendererExt;
import org.zkoss.pivot.event.PivotColumnResizeEvent;
import org.zkoss.pivot.event.PivotDataEvent;
import org.zkoss.pivot.event.PivotDataListener;
import org.zkoss.pivot.event.PivotRowResizeEvent;
import org.zkoss.pivot.event.PivotUIEvent;
import org.zkoss.pivot.impl.SimplePivotRenderer;
import org.zkoss.pivot.impl.util.CellLabelFiller;
import org.zkoss.pivot.impl.util.CellStyleFiller;
import org.zkoss.pivot.impl.util.DataCellTraverser;
import org.zkoss.pivot.impl.util.HeaderKeyFiller;
import org.zkoss.pivot.impl.util.HeaderLabelFiller;
import org.zkoss.pivot.impl.util.HeaderMergeFiller;
import org.zkoss.pivot.impl.util.HeaderSizeFiller;
import org.zkoss.pivot.impl.util.HeaderSizeInfo;
import org.zkoss.pivot.impl.util.HeaderTraverser;
import org.zkoss.pivot.impl.util.PagingInfo;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.ext.Pageable;
import org.zkoss.zul.impl.XulElement;

public class Pivottable
extends XulElement
implements Pageable {
    private static final long serialVersionUID = 20110103L;
    private static final String PVT_LOCK = "org.zkoss.pivot.rt.lock.key";
    public static final String SCROLL_POS = "scrollPos";
    private static final String ATTR_ON_INIT_RENDER_POSTED = "org.zkoss.zpt.Pivottable.onInitLaterPosted";
    public static final String DATA_TITLE = "DATA_TITLE";
    public static final String COLUMN_TITLE = "COLUMN_TITLE";
    public static final String ROW_TITLE = "ROW_TITLE";
    private transient PivotModel _model;
    private transient PivotRenderer _renderer;
    private transient PivotDataListener _dataListener;
    private transient Component _dcell;
    private transient Component _ccell;
    private transient Component _rcell;
    private Map<Integer, Integer> _customWidths;
    private Map<Integer, Integer> _rowWidths;
    private Map<String, Object> _cacheRenderingMap;
    private boolean _grandTotalForColumns = true;
    private boolean _grandTotalForRows = true;
    private String _orient = "column";
    private boolean _autowrap;
    private boolean _frozenColumnHeaders = false;
    private int _pgsz = 20;
    private int _ttsz = 0;
    private int _npg = 1;
    private int _actpg = 0;
    private static final Random _RGEN;
    private static final PivotRenderer DEFAULT_RENDERER;

    public Pivottable() {
        this.init();
    }

    private void init() {
        this._customWidths = new HashMap<Integer, Integer>();
        this._rowWidths = new HashMap<Integer, Integer>();
        this._cacheRenderingMap = new HashMap<String, Object>();
    }

    public void setHeight(String height) {
        throw new UnsupportedOperationException("readonly, please use setPageSize instead!");
    }

    public int getPageSize() {
        return this._pgsz;
    }

    public void setPageSize(int size) throws WrongValueException {
        if (size <= 0) {
            throw new WrongValueException("positive only");
        }
        if (this._pgsz != size) {
            this._pgsz = size;
            this.smartUpdate("pageSize", this._pgsz);
            this.updatePageNum();
            this.postOnInitRender();
        }
    }

    public int getTotalSize() {
        return this._ttsz;
    }

    public int getPageCount() {
        return this._npg;
    }

    public int getActivePage() {
        return this._actpg;
    }

    public void setActivePage(int pg) throws WrongValueException {
        if (this._actpg != pg) {
            this._actpg = pg;
            this.postOnInitRender();
        }
    }

    private void updatePageNum() {
        int v = (this._ttsz - 1) / this._pgsz + 1;
        if (v == 0) {
            v = 1;
        }
        if (v != this._npg) {
            this._npg = v;
            this.smartUpdate("pageCount", this._npg);
            if (this._actpg >= this._npg) {
                this._actpg = this._npg - 1;
                this.smartUpdate("activePage", this._actpg);
            }
        }
    }

    private void setTotalSize(int size) throws WrongValueException {
        if (size < 0) {
            throw new WrongValueException("non-negative only");
        }
        if (this._ttsz != size) {
            this._ttsz = size;
            this.smartUpdate("totalSize", this._ttsz);
            this.updatePageNum();
        }
    }

    public void setGrandTotalForRows(boolean grandTotalForRows) {
        if (this._grandTotalForRows != grandTotalForRows) {
            this._grandTotalForRows = grandTotalForRows;
            this.smartUpdate("grandTotalForRows", this._grandTotalForRows);
        }
    }

    public boolean isGrandTotalForRows() {
        return this._grandTotalForRows;
    }

    public void setGrandTotalForColumns(boolean grandTotalForColumns) {
        if (this._grandTotalForColumns != grandTotalForColumns) {
            this._grandTotalForColumns = grandTotalForColumns;
            this.smartUpdate("grandTotalForColumns", this._grandTotalForColumns);
        }
    }

    public boolean isGrandTotalForColumns() {
        return this._grandTotalForColumns;
    }

    public boolean addTitleCell(String type, Component component) {
        Component refChild = null;
        if (DATA_TITLE.equals(type)) {
            if (this._dcell != null) {
                throw new UiException("Only one data title cell is allowed: " + this);
            }
            refChild = this.getFirstChild();
        } else if (COLUMN_TITLE.equals(type)) {
            if (this._ccell != null) {
                throw new UiException("Only one column title cell is allowed: " + this);
            }
            refChild = this._rcell;
        } else if (ROW_TITLE.equals(type)) {
            if (this._rcell != null) {
                throw new UiException("Only one row title cell is allowed: " + this);
            }
        } else {
            throw new UiException("Unknown title cell type: " + type);
        }
        if (super.insertBefore(component, refChild)) {
            if (DATA_TITLE.equals(type)) {
                this._dcell = component;
            } else if (COLUMN_TITLE.equals(type)) {
                this._ccell = component;
            } else {
                this._rcell = component;
            }
            return true;
        }
        return false;
    }

    public Component getDataCell() {
        return this._dcell;
    }

    public Component getColumnCell() {
        return this._ccell;
    }

    public Component getRowCell() {
        return this._rcell;
    }

    public void beforeChildAdded(Component newChild, Component refChild) {
        if (refChild != null) {
            if (refChild == this._dcell || refChild == this._ccell && newChild != this._dcell) {
                throw new UiException("Only one data title cell is allowed: " + this);
            }
            if (refChild == this._rcell && newChild != this._ccell) {
                throw new UiException("Only one column title cell is allowed: " + this);
            }
        } else if (this.getChildren().size() == 3 && newChild != this._rcell) {
            throw new UiException("At most three children are allowed: " + this);
        }
        super.beforeChildAdded(newChild, refChild);
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        if (this._dcell == child) {
            this._dcell = null;
        } else if (this._rcell == child) {
            this._rcell = null;
        } else if (this._ccell == child) {
            this._ccell = null;
        }
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (super.insertBefore(newChild, refChild)) {
            if (refChild != null) {
                if (refChild == this._ccell) {
                    this._dcell = newChild;
                } else if (refChild == this._rcell) {
                    this._ccell = newChild;
                }
            } else if (this._ccell != null) {
                this._rcell = newChild;
            } else if (this._dcell != null) {
                this._ccell = newChild;
            } else {
                this._dcell = newChild;
            }
            return true;
        }
        return false;
    }

    public String getDataFieldOrient() {
        return this._orient;
    }

    public void setDataFieldOrient(String orient) {
        if (!"column".equals(orient) && !"row".equals(orient)) {
            throw new IllegalArgumentException("Unknown data orient: " + orient);
        }
        if (!orient.equals(this._orient)) {
            this._orient = orient;
            PivotModel model = this.getModel();
            if (model != null) {
                int dataSize = model.getFields(PivotField.Type.DATA).length;
                if (dataSize <= 0) {
                    dataSize = 1;
                }
                this._actpg = this.isColumnOrient() ? (this._actpg /= dataSize) : (this._actpg *= dataSize);
            }
            this.clearCustomSizes();
            this.postOnInitRender();
            super.invalidate();
        }
    }

    public void clearCustomSizes() {
        this._customWidths.clear();
        this._rowWidths.clear();
    }

    public PivotModel getModel() {
        return this._model;
    }

    public void setModel(PivotModel model) {
        if (model != null) {
            if (this._model != model) {
                if (this._model != null) {
                    this._model.removePivotDataListener(this._dataListener);
                }
                this._model = model;
                this.initDataListener();
            }
            this._actpg = 0;
            this.clearCustomSizes();
            this.postOnInitRender();
        } else if (this._model != null) {
            this._model.removePivotDataListener(this._dataListener);
            this._model = null;
            this.clearCustomSizes();
            this._cacheRenderingMap.clear();
        }
        super.invalidate();
    }

    public void setPivotRenderer(PivotRenderer renderer) {
        if (this._renderer != renderer) {
            this._renderer = renderer;
            this.postOnInitRender();
            super.invalidate();
        }
    }

    public PivotRenderer getPivotRenderer() {
        return this._renderer;
    }

    public void setAutowrap(boolean autowrap) {
        if (this._autowrap != autowrap) {
            this._autowrap = autowrap;
            this.smartUpdate("autowrap", this._autowrap);
        }
    }

    public boolean isAutowrap() {
        return this._autowrap;
    }

    public boolean isFrozenColumnHeaders() {
        return this._frozenColumnHeaders;
    }

    public void setFrozenColumnHeaders(boolean frozenColumnHeaders) {
        if (this._frozenColumnHeaders != frozenColumnHeaders) {
            this._frozenColumnHeaders = frozenColumnHeaders;
            this.smartUpdate("frozenColumnHeaders", this._frozenColumnHeaders);
        }
    }

    private void postOnInitRender() {
        this.postOnInitRender(new JSONObject());
    }

    private void postOnInitRender(JSONObject scrollPos) {
        if (this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
            this.setAttribute(ATTR_ON_INIT_RENDER_POSTED, Boolean.TRUE);
            Events.postEvent((String)"onInitRender", (Component)this, (Object)scrollPos);
        }
    }

    private boolean checkLock() {
        return _RGEN.nextInt(20) > 0 || "true".equals(Library.getProperty((String)PVT_LOCK));
    }

    public void onInitRender(Event event) {
        int i;
        if (!this.checkLock()) {
            return;
        }
        this.removeAttribute(ATTR_ON_INIT_RENDER_POSTED);
        if (this._actpg < 0) {
            throw new WrongValueException("Negative page number: " + this._actpg);
        }
        PivotModel model = this.getModel();
        if (model == null) {
            throw new NullPointerException("PivotModel cannot be empty.");
        }
        PivotRenderer renderer = this.getRealPivotRenderer();
        PivotField[] dataPF = model.getFields(PivotField.Type.DATA);
        PivotField[] rowPF = model.getFields(PivotField.Type.ROW);
        PivotField[] colPF = model.getFields(PivotField.Type.COLUMN);
        boolean isColOrient = this.isColumnOrient();
        int dataFieldSize = dataPF.length;
        int colFieldSize = colPF.length;
        int rowFieldSize = rowPF.length;
        this._cacheRenderingMap.put("colfsz", colFieldSize);
        this._cacheRenderingMap.put("rowfsz", rowFieldSize);
        this._cacheRenderingMap.put("dataLs", JSONArray.toJSONString((Object[])Pivottable.getLabels(dataPF, renderer)));
        this._cacheRenderingMap.put("columnOrient", String.valueOf(isColOrient));
        PivotHeaderTree rowTree = model.getRowHeaderTree();
        PivotHeaderTree colTree = model.getColumnHeaderTree();
        int dataFieldCells = Math.max(dataFieldSize, 1);
        int rowDFSize = isColOrient ? 1 : dataFieldCells;
        int colDFSize = isColOrient ? dataFieldCells : 1;
        PagingInfo rowPagingInfo = new PagingInfo(this._actpg * this._pgsz, this._pgsz, rowDFSize);
        PagingInfo colPagingInfo = new PagingInfo(colDFSize);
        this._cacheRenderingMap.put(SCROLL_POS, (JSONObject)event.getData());
        HeaderTraverser rowHeaderTrav = new HeaderTraverser(rowTree, rowPagingInfo, false);
        HeaderTraverser colHeaderTrav = new HeaderTraverser(colTree, colPagingInfo, false);
        this.setTotalSize(rowHeaderTrav.getSize() * rowPagingInfo.getDataSize());
        if (this._actpg > this._npg) {
            throw new WrongValueException("Unable to set active page to " + this._actpg + " since only " + this._npg + " pages are available.");
        }
        HeaderMergeFiller rowMGF = new HeaderMergeFiller();
        HeaderMergeFiller colMGF = new HeaderMergeFiller();
        HeaderLabelFiller rowLBF = new HeaderLabelFiller(this, renderer);
        HeaderLabelFiller colLBF = new HeaderLabelFiller(this, renderer);
        Object[] rowGtLBs = this.getGrandTotalLabels(renderer, isColOrient ? null : dataPF);
        Object[] colGtLBs = this.getGrandTotalLabels(renderer, (PivotField[])(isColOrient ? dataPF : null));
        HeaderKeyFiller rowKF = new HeaderKeyFiller();
        HeaderKeyFiller colKF = new HeaderKeyFiller();
        HeaderSizeInfo headerSizeInfo = new HeaderSizeInfo(this, renderer, model, isColOrient);
        HeaderSizeFiller rowSF = headerSizeInfo.getRowFiller();
        HeaderSizeFiller colSF = headerSizeInfo.getColumnFiller();
        rowHeaderTrav.run(new HeaderTraverser.Filler[]{rowMGF, rowLBF, rowKF, rowSF});
        colHeaderTrav.run(new HeaderTraverser.Filler[]{colMGF, colLBF, colKF, colSF});
        this._cacheRenderingMap.put("rowMs", JSONArray.toJSONString((Object[])rowMGF.getSpans()));
        this._cacheRenderingMap.put("colMs", JSONArray.toJSONString((Object[])colMGF.getSpans()));
        this._cacheRenderingMap.put("rowKs", JSONArray.toJSONString((Object[])rowKF.getKeys()));
        this._cacheRenderingMap.put("colKs", JSONArray.toJSONString((Object[])colKF.getKeys()));
        this._cacheRenderingMap.put("rowLids", JSONArray.toJSONString((Object[])rowLBF.getLabelIDs()));
        this._cacheRenderingMap.put("colLids", JSONArray.toJSONString((Object[])colLBF.getLabelIDs()));
        List<String> stringList = null;
        stringList = rowLBF.getLabelList();
        this._cacheRenderingMap.put("rowLs", JSONArray.toJSONString((Object[])(stringList == null ? null : stringList.toArray())));
        stringList = colLBF.getLabelList();
        this._cacheRenderingMap.put("colLs", JSONArray.toJSONString((Object[])(stringList == null ? null : stringList.toArray())));
        this._cacheRenderingMap.put("rowGtLBs", JSONArray.toJSONString((Object[])rowGtLBs));
        this._cacheRenderingMap.put("colGtLBs", JSONArray.toJSONString((Object[])colGtLBs));
        int colDispOffset = Math.max(rowFieldSize, 1) + (rowDFSize > 1 ? 1 : 0);
        int[] colSizes = colSF.getSizes();
        for (Map.Entry<Integer, Integer> e : this._customWidths.entrySet()) {
            i = e.getKey() + colDispOffset;
            if (i >= colSizes.length) continue;
            colSizes[i] = e.getValue();
        }
        for (Map.Entry<Integer, Integer> e : this._rowWidths.entrySet()) {
            i = e.getKey();
            if (i >= colSizes.length) continue;
            colSizes[i] = e.getValue();
        }
        this._cacheRenderingMap.put("rowSizes", JSONArray.toJSONString((int[])rowSF.getSizes()));
        this._cacheRenderingMap.put("colSizes", JSONArray.toJSONString((int[])colSizes));
        this._cacheRenderingMap.put("rowOffset", headerSizeInfo.getRowDisplayOffset());
        this._cacheRenderingMap.put("colOffset", headerSizeInfo.getColumnDisplayOffset());
        this._cacheRenderingMap.put("pageCutoff", JSONArray.toJSONString((int[])new int[]{rowPagingInfo.getCutoffStart(), rowPagingInfo.getRealCutoffEnd(rowHeaderTrav.getRealSize())}));
        this._cacheRenderingMap.put("iconCutoffs", JSONArray.toJSONString((int[])rowMGF.getIconCutoffs()));
        int rowSize = rowHeaderTrav.getRealSize();
        int colSize = colHeaderTrav.getRealSize();
        DataCellTraverser cellTrav = new DataCellTraverser(model, isColOrient, rowSize, colSize, rowPagingInfo, false);
        CellLabelFiller labelFiller = new CellLabelFiller(this, renderer, cellTrav);
        cellTrav.addCellFiller(labelFiller);
        boolean isRendererExt = renderer instanceof PivotRendererExt;
        CellStyleFiller styleFiller = null;
        if (isRendererExt) {
            styleFiller = new CellStyleFiller(this, (PivotRendererExt)renderer, cellTrav);
            cellTrav.addCellFiller(styleFiller);
        }
        cellTrav.fill();
        String[][] cells = labelFiller.getDataCells();
        String[][] rowGTCells = labelFiller.getRowGrandTotalCells();
        this._cacheRenderingMap.put("cells", JSONArray.toJSONString((Object[])cells));
        this._cacheRenderingMap.put("rgtCells", JSONArray.toJSONString((Object[])rowGTCells));
        if (isRendererExt) {
            String[][] cellClasses = styleFiller.getDataCellClasses();
            String[][] rowGTCellClasses = styleFiller.getRowGrandTotalCellClasses();
            this._cacheRenderingMap.put("cellCls", JSONArray.toJSONString((Object[])cellClasses));
            this._cacheRenderingMap.put("rgtCellCls", JSONArray.toJSONString((Object[])rowGTCellClasses));
            this._cacheRenderingMap.put("cellStyKs", styleFiller.getStyleKeys());
            stringList = styleFiller.getStyleValues();
            this._cacheRenderingMap.put("cellStyVs", JSONArray.toJSONString((Object[])(stringList != null ? stringList.toArray() : null)));
        }
        for (Map.Entry<String, Object> me : this._cacheRenderingMap.entrySet()) {
            this.smartUpdate(me.getKey(), me.getValue());
        }
        super.invalidate();
    }

    private PivotRenderer getRealPivotRenderer() {
        return this._renderer == null ? DEFAULT_RENDERER : this._renderer;
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new PivotDataListener(){

                @Override
                public void onChange(PivotDataEvent event) {
                    Pivottable.this.clearCustomSizes();
                    Pivottable.this.postOnInitRender();
                    Pivottable.this._actpg = 0;
                }
            };
        }
        this._model.addPivotDataListener(this._dataListener);
    }

    public String getZclass() {
        return this._zclass == null ? "z-pivottable" : this._zclass;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        for (Map.Entry<String, Object> me : this._cacheRenderingMap.entrySet()) {
            this.render(renderer, me.getKey(), me.getValue());
        }
        renderer.render("grandTotalForColumns", this._grandTotalForColumns);
        renderer.render("grandTotalForRows", this._grandTotalForRows);
        renderer.render("autowrap", this._autowrap);
        if (this._frozenColumnHeaders) {
            renderer.render("frozenColumnHeaders", this._frozenColumnHeaders);
        }
        renderer.render("titleCells", JSONArray.toJSONString((int[])new int[]{this._dcell != null ? 1 : 0, this._ccell != null ? 1 : 0, this._rcell != null ? 1 : 0}));
        if (this._ttsz != 0) {
            renderer.render("totalSize", this._ttsz);
        }
        if (this._pgsz != 20) {
            renderer.render("pageSize", this._pgsz);
        }
        if (this._actpg != 0) {
            renderer.render("activePage", this._actpg);
        }
        if (this._npg != 1) {
            renderer.render("pageCount", this._npg);
        }
    }

    public Object clone() {
        Pivottable clone = (Pivottable)((Object)super.clone());
        clone.init();
        if (clone._model != null) {
            clone._dataListener = null;
            clone.initDataListener();
        }
        clone.afterUnmarshal();
        return clone;
    }

    private void afterUnmarshal() {
        if (this._dcell != null) {
            this._dcell = (Component)this.getChildren().get(Pivottable.indexOf(this._dcell));
        }
        if (this._ccell != null) {
            this._ccell = (Component)this.getChildren().get(Pivottable.indexOf(this._ccell));
        }
        if (this._rcell != null) {
            this._rcell = (Component)this.getChildren().get(Pivottable.indexOf(this._rcell));
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this.willSerialize(this._model);
        s.writeObject(this._model instanceof Serializable || this._model instanceof Externalizable ? this._model : null);
        this.willSerialize(this._renderer);
        s.writeObject(this._renderer instanceof Serializable || this._renderer instanceof Externalizable ? this._renderer : null);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._model = (PivotModel)s.readObject();
        this.didDeserialize(this._model);
        this._renderer = (PivotRenderer)s.readObject();
        this.didDeserialize(this._renderer);
        this.init();
        if (this._model != null) {
            this.initDataListener();
        }
        this.afterUnmarshal();
    }

    public void sessionWillPassivate(Page page) {
        super.sessionWillPassivate(page);
        this.willPassivate(this._model);
        this.willPassivate(this._renderer);
    }

    public void sessionDidActivate(Page page) {
        super.sessionDidActivate(page);
        this.didActivate(this._model);
        this.didActivate(this._renderer);
    }

    public boolean isChildable() {
        return true;
    }

    public void service(AuRequest request, boolean everError) {
        String name = request.getCommand();
        if ("onPaging".equals(name)) {
            PagingEvent evt = PagingEvent.getPagingEvent((AuRequest)request);
            this.setActivePage(evt.getActivePage());
            Events.postEvent((Event)evt);
        } else if ("onPivotColumnResize".equals(name)) {
            PivotColumnResizeEvent evt = PivotColumnResizeEvent.getPivotColumnResizeEvent(request);
            this._customWidths.put(evt.getColumnContext().getDisplayIndex(), evt.getWidth());
            Events.postEvent((Event)evt);
        } else if ("onPivotRowResize".equals(name)) {
            PivotRowResizeEvent evt = PivotRowResizeEvent.getPivotRowResizeEvent(request);
            int[] widthArray = evt.getWidthArray();
            int[] indexArray = evt.getIndexArray();
            int length = widthArray.length;
            for (int i = 0; i < length; ++i) {
                this._rowWidths.put(indexArray[i], widthArray[i]);
            }
            Events.postEvent((Event)evt);
        } else {
            PivotUIEvent evt = PivotUIEvent.getPivotUIEvent(request);
            if ("onPivotNodeOpen".equals(name)) {
                PivotModel model = this.getModel();
                if (model == null) {
                    return;
                }
                boolean isRow = evt.getFieldType() == PivotField.Type.ROW;
                PivotHeaderContext ctx = isRow ? evt.getRowContext() : evt.getColumnContext();
                PivotHeaderNode node = ctx.getNode();
                if (node == null) {
                    throw new IllegalStateException();
                }
                node.setOpen(evt.isOpen());
                if (!isRow) {
                    this.clearCustomSizes();
                }
                this.postOnInitRender((JSONObject)request.getData().get(SCROLL_POS));
                super.invalidate();
                Events.postEvent((Event)evt);
            } else if ("onPivotPopup".equals(name)) {
                Events.postEvent((Event)evt);
            } else if ("onPivotContext".equals(name)) {
                Events.postEvent((Event)evt);
            } else if ("onPivotTooltip".equals(name)) {
                Events.postEvent((Event)evt);
            } else {
                super.service(request, everError);
            }
        }
    }

    public void invalidate() {
        super.invalidate();
        this.postOnInitRender();
    }

    private boolean isColumnOrient() {
        return "column".equals(this._orient);
    }

    private String[] getGrandTotalLabels(PivotRenderer renderer, PivotField[] fields) {
        if (fields == null) {
            return new String[]{renderer.renderGrandTotalField(this, null)};
        }
        int len = fields.length;
        String[] result = new String[len];
        for (int i = 0; i < len; ++i) {
            result[i] = renderer.renderGrandTotalField(this, fields[i]);
        }
        return result;
    }

    private static String[] getLabels(PivotField[] fields, PivotRenderer renderer) {
        int len = fields.length;
        String[] labels = new String[len];
        for (int i = 0; i < len; ++i) {
            labels[i] = renderer.renderDataField(fields[i]);
        }
        return labels;
    }

    private static int indexOf(Component comp) {
        return comp.getParent().getChildren().indexOf(comp);
    }

    static {
        Library.setProperty((String)PVT_LOCK, (String)"true");
        Pivottable.addClientEvent(Pivottable.class, (String)"onPaging", (int)1);
        Pivottable.addClientEvent(Pivottable.class, (String)"onPivotColumnResize", (int)1);
        Pivottable.addClientEvent(Pivottable.class, (String)"onPivotRowResize", (int)1);
        Pivottable.addClientEvent(Pivottable.class, (String)"onPivotNodeOpen", (int)3);
        Pivottable.addClientEvent(Pivottable.class, (String)"onPivotPopup", (int)8192);
        Pivottable.addClientEvent(Pivottable.class, (String)"onPivotContext", (int)8192);
        Pivottable.addClientEvent(Pivottable.class, (String)"onPivotTooltip", (int)8192);
        _RGEN = new Random(new Date().getTime());
        DEFAULT_RENDERER = new SimplePivotRenderer();
    }
}

