/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zel.impl.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.zkoss.zel.ELException;
import org.zkoss.zel.impl.lang.EvaluationContext;
import org.zkoss.zel.impl.parser.SimpleNode;

public final class AstNegative
extends SimpleNode {
    public AstNegative(int id) {
        super(id);
    }

    @Override
    public Class<?> getType(EvaluationContext ctx) throws ELException {
        return Number.class;
    }

    @Override
    public Object getValue(EvaluationContext ctx) throws ELException {
        Object obj = this.children[0].getValue(ctx);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).negate();
        }
        if (obj instanceof BigInteger) {
            return ((BigInteger)obj).negate();
        }
        if (obj instanceof String) {
            if (AstNegative.isStringFloat((String)obj)) {
                return new Double(-Double.parseDouble((String)obj));
            }
            return -Long.parseLong((String)obj);
        }
        if (obj instanceof Long) {
            return -((Long)obj).longValue();
        }
        if (obj instanceof Double) {
            return new Double(-((Double)obj).doubleValue());
        }
        if (obj instanceof Integer) {
            return -((Integer)obj).intValue();
        }
        if (obj instanceof Float) {
            return new Float(-((Float)obj).floatValue());
        }
        if (obj instanceof Short) {
            return -((Short)obj).shortValue();
        }
        if (obj instanceof Byte) {
            return -((Byte)obj).byteValue();
        }
        Long num = (Long)AstNegative.coerceToNumber(obj, Long.class);
        return -num.longValue();
    }
}

