/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.io.Serializable;
import org.zkoss.lang.Objects;
import org.zkoss.util.Cache;
import org.zkoss.util.CacheMap;

public class MultiCache
implements Cache,
Serializable,
Cloneable {
    private final CacheMap[] _caches;
    private int _maxsize;
    private int _lifetime;

    public MultiCache() {
        this(17);
    }

    public MultiCache(int nCache, int maxSize, int lifetime) {
        if (nCache <= 0) {
            throw new IllegalArgumentException();
        }
        this._caches = new CacheMap[nCache];
        this._maxsize = maxSize;
        this._lifetime = lifetime;
    }

    public MultiCache(int nCache) {
        this(nCache, 51, 1800000);
    }

    public MultiCache(int nCache, int initSize) {
        this(nCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        CacheMap cache;
        CacheMap cacheMap = cache = this.getCache(key);
        synchronized (cacheMap) {
            return cache.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        CacheMap cache;
        CacheMap cacheMap = cache = this.getCache(key);
        synchronized (cacheMap) {
            return cache.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        CacheMap cache;
        CacheMap cacheMap = cache = this.getCache(key);
        synchronized (cacheMap) {
            return cache.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        CacheMap cache;
        CacheMap cacheMap = cache = this.getCache(key);
        synchronized (cacheMap) {
            return cache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        MultiCache multiCache = this;
        synchronized (multiCache) {
            for (int j = 0; j < this._caches.length; ++j) {
                this._caches[j] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheMap getCache(Object key) {
        int j = Objects.hashCode(key);
        j = (j >= 0 ? j : -j) % this._caches.length;
        CacheMap cache = this._caches[j];
        if (cache == null) {
            MultiCache multiCache = this;
            synchronized (multiCache) {
                cache = this._caches[j];
                if (cache == null) {
                    cache = new CacheMap(4);
                    cache.setMaxSize(this._maxsize);
                    cache.setLifetime(this._lifetime);
                    this._caches[j] = cache;
                }
            }
        }
        return cache;
    }

    public int getLifetime() {
        return this._lifetime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLifetime(int lifetime) {
        this._lifetime = lifetime;
        for (int j = 0; j < this._caches.length; ++j) {
            if (this._caches[j] == null) continue;
            CacheMap cacheMap = this._caches[j];
            synchronized (cacheMap) {
                this._caches[j].setLifetime(lifetime);
                continue;
            }
        }
    }

    public int getMaxSize() {
        return this._maxsize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxSize(int maxsize) {
        this._maxsize = maxsize;
        for (int j = 0; j < this._caches.length; ++j) {
            if (this._caches[j] == null) continue;
            CacheMap cacheMap = this._caches[j];
            synchronized (cacheMap) {
                this._caches[j].setMaxSize(maxsize);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        MultiCache clone = new MultiCache(this._caches.length, this._maxsize, this._lifetime);
        for (int j = 0; j < this._caches.length; ++j) {
            if (this._caches[j] == null) continue;
            CacheMap cacheMap = this._caches[j];
            synchronized (cacheMap) {
                clone._caches[j] = (CacheMap)this._caches[j].clone();
                continue;
            }
        }
        return clone;
    }
}

