/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

class ComodifiableIterator
implements Iterator {
    private final List _visited = new LinkedList();
    private List _lastVisited;
    private final Collection _col;
    private Iterator _it;
    private Object _next;
    private boolean _nextAvail;

    ComodifiableIterator(Collection col) {
        this._col = col;
        this._it = col.iterator();
    }

    public boolean hasNext() {
        if (this._nextAvail) {
            return true;
        }
        while (!this._col.isEmpty()) {
            Object o;
            try {
                o = this._it.next();
            }
            catch (NoSuchElementException ex) {
                return false;
            }
            catch (ConcurrentModificationException ex) {
                this._lastVisited = new LinkedList(this._visited);
                this._it = this._col.iterator();
                continue;
            }
            if (this.removeFromLastVisited(o)) continue;
            this._visited.add(o);
            this._next = o;
            this._nextAvail = true;
            return true;
        }
        return false;
    }

    public Object next() {
        Object o;
        if (this._nextAvail) {
            this._nextAvail = false;
            return this._next;
        }
        while (true) {
            try {
                o = this._it.next();
            }
            catch (ConcurrentModificationException ex) {
                this._lastVisited = new LinkedList(this._visited);
                this._it = this._col.iterator();
                continue;
            }
            if (!this.removeFromLastVisited(o)) break;
        }
        this._visited.add(o);
        return o;
    }

    private boolean removeFromLastVisited(Object o) {
        if (this._lastVisited != null) {
            Iterator it = this._lastVisited.iterator();
            while (it.hasNext()) {
                if (it.next() != o) continue;
                it.remove();
                return true;
            }
        }
        return false;
    }

    public void remove() {
        this._it.remove();
    }
}

