/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.util.logging.Log;

public class Cleanups {
    private static final Log log = Log.lookup(Cleanups.class);
    private static final List _cleanups = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean add(Cleanup cleanup) {
        if (cleanup == null) {
            throw new IllegalArgumentException();
        }
        List list = _cleanups;
        synchronized (list) {
            if (_cleanups.contains(cleanup)) {
                return false;
            }
            return _cleanups.add(cleanup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean remove(Cleanup cleanup) {
        List list = _cleanups;
        synchronized (list) {
            return _cleanups.remove(cleanup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup() {
        ArrayList cleanups;
        List list = _cleanups;
        synchronized (list) {
            cleanups = new ArrayList(_cleanups);
        }
        Iterator it = cleanups.iterator();
        while (it.hasNext()) {
            Cleanup cleanup = (Cleanup)it.next();
            try {
                cleanup.cleanup();
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + cleanup);
            }
        }
    }

    public static interface Cleanup {
        public void cleanup();
    }
}

