/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.lang;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.rmi.MarshalledObject;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.SystemException;
import org.zkoss.text.DateFormats;
import org.zkoss.util.ArraysX;

public class Objects {
    private static final Logger log = LoggerFactory.getLogger(Objects.class);
    public static final Object UNKNOWN = new Object(){

        public final String toString() {
            return "(null)";
        }
    };
    public static final Long ZERO_LONG = 0L;
    public static final Integer ZERO_INTEGER = 0;
    public static final Short ZERO_SHORT = 0;
    public static final Byte ZERO_BYTE = 0;
    public static final Float ZERO_FLOAT = Float.valueOf(0.0f);
    public static final Double ZERO_DOUBLE = 0.0;
    public static final BigDecimal ZERO_BIG_DECIMAL = BigDecimal.valueOf(0.0);
    public static final BigInteger ZERO_BIG_INTEGER = BigInteger.ZERO;
    public static final Character NULL_CHARACTER = Character.valueOf('\u0000');

    public static final int nextHashCode(int prevHashVal, int newVal) {
        return prevHashVal * 31 + newVal;
    }

    public static final int hashCode(boolean[] v) {
        int h = 1;
        int j = v.length;
        while (--j >= 0) {
            h = Objects.nextHashCode(h, v[j] ? 1 : 0);
        }
        return h;
    }

    public static final int hashCode(byte[] v) {
        int h = 1;
        int j = v.length;
        while (--j >= 0) {
            h = Objects.nextHashCode(h, v[j]);
        }
        return h;
    }

    public static final int hashCode(byte[] v, int len) {
        int h = 1;
        if (len > v.length) {
            len = v.length;
        }
        int j = len;
        while (--j >= 0) {
            h = Objects.nextHashCode(h, v[j]);
        }
        return h;
    }

    public static final int hashCode(char[] v) {
        int h = 1;
        int j = v.length;
        while (--j >= 0) {
            h = Objects.nextHashCode(h, v[j]);
        }
        return h;
    }

    public static final int hashCode(short[] v) {
        int h = 1;
        int j = v.length;
        while (--j >= 0) {
            h = Objects.nextHashCode(h, v[j]);
        }
        return h;
    }

    public static final int hashCode(int[] v) {
        int h = 1;
        int j = v.length;
        while (--j >= 0) {
            h = Objects.nextHashCode(h, v[j]);
        }
        return h;
    }

    public static final int hashCode(long[] v) {
        int h = 1;
        int j = v.length;
        while (--j >= 0) {
            h = Objects.nextHashCode(h, (int)v[j]);
            h = Objects.nextHashCode(h, (int)(v[j] >> 32));
        }
        return h;
    }

    public static final int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public static final boolean equals(Object a, Object b) {
        if (a == b || a != null && b != null && a.equals(b)) {
            return true;
        }
        if (a instanceof BigDecimal && b instanceof BigDecimal) {
            return ((BigDecimal)a).compareTo((BigDecimal)b) == 0;
        }
        if (a == null || !a.getClass().isArray()) {
            return false;
        }
        if (a instanceof Object[] && b instanceof Object[]) {
            Object[] as = (Object[])a;
            Object[] bs = (Object[])b;
            if (as.length != bs.length) {
                return false;
            }
            int j = as.length;
            while (--j >= 0) {
                if (Objects.equals(as[j], bs[j])) continue;
                return false;
            }
            return true;
        }
        if (a instanceof int[] && b instanceof int[]) {
            int[] as = (int[])a;
            int[] bs = (int[])b;
            if (as.length != bs.length) {
                return false;
            }
            int j = as.length;
            while (--j >= 0) {
                if (as[j] == bs[j]) continue;
                return false;
            }
            return true;
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            byte[] as = (byte[])a;
            byte[] bs = (byte[])b;
            if (as.length != bs.length) {
                return false;
            }
            int j = as.length;
            while (--j >= 0) {
                if (as[j] == bs[j]) continue;
                return false;
            }
            return true;
        }
        if (a instanceof char[] && b instanceof char[]) {
            char[] as = (char[])a;
            char[] bs = (char[])b;
            if (as.length != bs.length) {
                return false;
            }
            int j = as.length;
            while (--j >= 0) {
                if (as[j] == bs[j]) continue;
                return false;
            }
            return true;
        }
        if (a instanceof long[] && b instanceof long[]) {
            long[] as = (long[])a;
            long[] bs = (long[])b;
            if (as.length != bs.length) {
                return false;
            }
            int j = as.length;
            while (--j >= 0) {
                if (as[j] == bs[j]) continue;
                return false;
            }
            return true;
        }
        if (a instanceof short[] && b instanceof short[]) {
            short[] as = (short[])a;
            short[] bs = (short[])b;
            if (as.length != bs.length) {
                return false;
            }
            int j = as.length;
            while (--j >= 0) {
                if (as[j] == bs[j]) continue;
                return false;
            }
            return true;
        }
        if (a instanceof double[] && b instanceof double[]) {
            double[] as = (double[])a;
            double[] bs = (double[])b;
            if (as.length != bs.length) {
                return false;
            }
            int j = as.length;
            while (--j >= 0) {
                if (Double.compare(as[j], bs[j]) == 0) continue;
                return false;
            }
            return true;
        }
        if (a instanceof float[] && b instanceof float[]) {
            float[] as = (float[])a;
            float[] bs = (float[])b;
            if (as.length != bs.length) {
                return false;
            }
            int j = as.length;
            while (--j >= 0) {
                if (Float.compare(as[j], bs[j]) == 0) continue;
                return false;
            }
            return true;
        }
        if (a instanceof boolean[] && b instanceof boolean[]) {
            boolean[] as = (boolean[])a;
            boolean[] bs = (boolean[])b;
            if (as.length != bs.length) {
                return false;
            }
            int j = as.length;
            while (--j >= 0) {
                if (as[j] == bs[j]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static final char[] toCharArray(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof char[]) {
            return (char[])o;
        }
        if (o instanceof String) {
            return ((String)o).toCharArray();
        }
        try {
            Method m = o.getClass().getMethod("toCharArray", new Class[0]);
            return (char[])m.invoke(o, new Object[0]);
        }
        catch (Exception ex) {
            return o.toString().toCharArray();
        }
    }

    public static final String toString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return DateFormats.format((Date)o, false);
        }
        if (o instanceof Class) {
            Class cls = (Class)o;
            String clsnm = cls.getName();
            if (!clsnm.startsWith("$Proxy")) {
                return "class " + clsnm;
            }
            Class<?>[] ifs = cls.getInterfaces();
            switch (ifs.length) {
                case 0: {
                    return "class " + clsnm;
                }
                case 1: {
                    return "proxy " + Objects.toString(ifs[0]);
                }
            }
            return "proxy " + Objects.toString(ifs);
        }
        if (o.getClass().isArray()) {
            if (o instanceof Object[]) {
                return ArraysX.toString((Object[])o);
            }
            if (o instanceof int[]) {
                return ArraysX.toString((int[])o);
            }
            if (o instanceof short[]) {
                return ArraysX.toString((short[])o);
            }
            if (o instanceof long[]) {
                return ArraysX.toString((long[])o);
            }
            if (o instanceof double[]) {
                return ArraysX.toString((double[])o);
            }
            if (o instanceof byte[]) {
                return ArraysX.toString((byte[])o);
            }
            if (o instanceof boolean[]) {
                return ArraysX.toString((boolean[])o);
            }
            if (o instanceof char[]) {
                return ArraysX.toString((char[])o);
            }
            if (o instanceof float[]) {
                return ArraysX.toString((float[])o);
            }
        }
        return o.toString();
    }

    public static final byte[] toByteArray(int v) {
        return new byte[]{(byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)v};
    }

    public static final byte[] toByteArray(long v) {
        return new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)v};
    }

    public static final byte[] toByteArray(short v) {
        return new byte[]{(byte)(v >>> 8), (byte)v};
    }

    public static final byte[] toByteArray(byte v) {
        return new byte[]{v};
    }

    public static final Object clone(Object o) {
        if (o == null) {
            return o;
        }
        try {
            block7: {
                Class<?> kls = o.getClass();
                if (kls.isArray()) {
                    return ArraysX.duplicate(o);
                }
                if (o instanceof Cloneable) {
                    try {
                        return kls.getMethod("clone", new Class[0]).invoke(o, new Object[0]);
                    }
                    catch (NoSuchMethodException ex) {
                        if (!log.isDebugEnabled()) break block7;
                        log.debug("No clone() for {}", kls);
                    }
                }
            }
            return new MarshalledObject<Object>(o).get();
        }
        catch (Exception ex) {
            throw SystemException.Aide.wrap(ex);
        }
    }
}

