/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.idom.impl;

import java.util.List;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Text;
import org.zkoss.idom.DOMException;
import org.zkoss.idom.Item;
import org.zkoss.idom.Textual;
import org.zkoss.idom.Verifier;
import org.zkoss.idom.impl.AbstractItem;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Objects;
import org.zkoss.lang.SystemException;

public abstract class AbstractTextual
extends AbstractItem
implements Textual,
CharacterData {
    protected String _text;

    protected AbstractTextual(String text) {
        this.setText(text);
    }

    protected AbstractTextual() {
        this._text = "";
    }

    @Override
    public boolean isPartOfParentText() {
        return true;
    }

    @Override
    public boolean isCoalesceable() {
        return false;
    }

    @Override
    public Textual split(int offset) {
        Textual vtx;
        String s = this.getText();
        if (offset < s.length()) {
            return null;
        }
        try {
            vtx = (Textual)Classes.newInstance(this.getClass(), new Class[]{String.class}, new Object[]{s.substring(offset)});
        }
        catch (Exception ex) {
            throw SystemException.Aide.wrap((Throwable)ex, String.valueOf(this.getClass()) + " must have a String constructor");
        }
        this.setText(s.substring(0, offset));
        if (this.getParent() != null) {
            List<Item> list = this.getParent().getChildren();
            list.add(list.indexOf(this) + 1, (Item)((Object)vtx));
        }
        return vtx;
    }

    protected void checkText(String text) {
        Verifier.checkCharacterData(text, this.getLocator());
    }

    @Override
    public String getText() {
        return this._text;
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        if (!Objects.equals(this._text, text)) {
            this.checkText(text);
            this._text = text;
        }
    }

    @Override
    public final int getLength() {
        return this.getText().length();
    }

    @Override
    public final String getData() {
        return this.getText();
    }

    @Override
    public final void setData(String data) {
        this.setText(data);
    }

    @Override
    public final String substringData(int offset, int count) {
        return this.getText().substring(offset, offset + count);
    }

    @Override
    public final void appendData(String newData) {
        if (newData != null && newData.length() != 0) {
            this.setText(this.getText() + newData);
        }
    }

    @Override
    public final void insertData(int offset, String arg) {
        if (arg != null && arg.length() != 0) {
            this.setText(new StringBuffer(this.getText()).insert(offset, arg).toString());
        }
    }

    @Override
    public final void deleteData(int offset, int count) {
        if (offset < this.getLength()) {
            this.setText(new StringBuffer(this.getText()).delete(offset, offset + count).toString());
        }
    }

    @Override
    public final void replaceData(int offset, int count, String arg) {
        this.setText(new StringBuffer(this.getText()).replace(offset, offset + count, arg).toString());
    }

    public final Text splitText(int offset) {
        return (Text)((Object)this.split(offset));
    }

    public boolean isElementContentWhitespace() {
        throw new UnsupportedOperationException("DOM Level 3");
    }

    public String getWholeText() {
        throw new UnsupportedOperationException("DOM Level 3");
    }

    public Text replaceWholeText(String content) throws DOMException {
        throw new UnsupportedOperationException("DOM Level 3");
    }

    @Override
    public String getTextContent() {
        return this.getText();
    }

    public String toString() {
        String clsName = this.getClass().getName();
        int j = clsName.lastIndexOf(46);
        if (j >= 0) {
            clsName = clsName.substring(j + 1);
        }
        return "[" + clsName + ": \"" + this.getText() + "\"]";
    }
}

