/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.officeDocument.x2006.relationships.STRelationshipId;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColFields;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColItems;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDataField;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDataFields;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTField;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTI;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTLocation;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPivotField;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPivotFields;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPivotTableDefinition;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRowFields;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRowItems;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTX;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.PivotTableDefinitionDocument;
import org.zkoss.poi.POIXMLDocumentPart;
import org.zkoss.poi.openxml4j.opc.PackagePart;
import org.zkoss.poi.openxml4j.opc.PackageRelationship;
import org.zkoss.poi.openxml4j.opc.TargetMode;
import org.zkoss.poi.ss.usermodel.Calculation;
import org.zkoss.poi.ss.usermodel.DataField;
import org.zkoss.poi.ss.usermodel.PivotCache;
import org.zkoss.poi.ss.usermodel.PivotField;
import org.zkoss.poi.ss.usermodel.PivotTable;
import org.zkoss.poi.ss.usermodel.Sheet;
import org.zkoss.poi.ss.util.AreaReference;
import org.zkoss.poi.ss.util.CellReference;
import org.zkoss.poi.ss.util.ItemInfo;
import org.zkoss.poi.xssf.usermodel.XSSFDataField;
import org.zkoss.poi.xssf.usermodel.XSSFPivotCache;
import org.zkoss.poi.xssf.usermodel.XSSFPivotField;
import org.zkoss.poi.xssf.usermodel.XSSFRelation;

public class XSSFPivotTable
extends POIXMLDocumentPart
implements PivotTable,
Serializable {
    private static final long serialVersionUID = -8138808664919441702L;
    private CTPivotTableDefinition _pivotTableDefinition;
    private XSSFPivotCache _pivotCache;
    private LinkedHashMap<String, PivotField> _pivotFields;

    XSSFPivotTable() {
        this.onDocumentCreate();
    }

    protected void onDocumentCreate() {
        this._pivotTableDefinition = CTPivotTableDefinition.Factory.newInstance();
        this._pivotTableDefinition.setApplyNumberFormats(false);
        this._pivotTableDefinition.setApplyBorderFormats(false);
        this._pivotTableDefinition.setApplyFontFormats(false);
        this._pivotTableDefinition.setApplyPatternFormats(false);
        this._pivotTableDefinition.setApplyAlignmentFormats(false);
        this._pivotTableDefinition.setApplyWidthHeightFormats(true);
        this._pivotTableDefinition.setDataCaption("Values");
        this._pivotTableDefinition.setShowCalcMbrs(false);
        this._pivotTableDefinition.setUseAutoFormatting(true);
        this._pivotTableDefinition.setItemPrintTitles(true);
        this._pivotTableDefinition.setIndent(0L);
        this._pivotTableDefinition.setOutlineData(true);
        this._pivotTableDefinition.setMultipleFieldFilters(false);
    }

    public XSSFPivotTable(PackagePart part, PackageRelationship rel, List<PivotCache> pivotCaches) throws IOException, XmlException {
        InputStream in = part.getInputStream();
        this._pivotTableDefinition = PivotTableDefinitionDocument.Factory.parse((InputStream)in).getPivotTableDefinition();
        long cacheId = this.getCacheId();
        for (PivotCache e : pivotCaches) {
            if (e.getCacheId() != cacheId) continue;
            this._pivotCache = (XSSFPivotCache)e;
            break;
        }
    }

    protected void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTPivotTableDefinition.type.getName().getNamespaceURI(), "pivotTableDefinition"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(STRelationshipId.type.getName().getNamespaceURI(), "r");
        xmlOptions.setSaveSuggestedPrefixes(map);
        PackagePart part = this.getPackagePart();
        this.clearMemoryPackagePart(part);
        OutputStream out = part.getOutputStream();
        this._pivotTableDefinition.save(out, xmlOptions);
        out.close();
    }

    public CTPivotTableDefinition getPivotTableDefinition() {
        return this._pivotTableDefinition;
    }

    private String nextReleationId() {
        int idx = 1;
        String rId = "rId" + idx;
        while (this.getRelationById(rId) != null) {
            rId = "rId" + ++idx;
        }
        return rId;
    }

    public void setPivotCache(PivotCache pivotCache) {
        this._pivotCache = (XSSFPivotCache)pivotCache;
        this.getPackagePart().addRelationship(this._pivotCache.getPackagePart().getPartName(), TargetMode.INTERNAL, XSSFRelation.PIVOT_CACHE_DEFINITION.getRelation());
        this.addRelation(this.nextReleationId(), this._pivotCache);
        this._pivotTableDefinition.setCacheId(pivotCache.getCacheId());
        this._pivotTableDefinition.setUpdatedVersion(pivotCache.getRefreshedVersion());
        this._pivotTableDefinition.setMinRefreshableVersion(pivotCache.getMinRefreshableVersion());
        this._pivotTableDefinition.setCreatedVersion(pivotCache.getCreatedVersion());
    }

    public long getCacheId() {
        return this._pivotTableDefinition.getCacheId();
    }

    public List<PivotField> getColumnFields() {
        CTColFields colFields = this._pivotTableDefinition.getColFields();
        if (colFields == null) {
            return Collections.emptyList();
        }
        ArrayList<PivotField> list = new ArrayList<PivotField>();
        List<PivotField> pivotFields = this.getPivotFields();
        for (CTField f : colFields.getFieldArray()) {
            int x = f.getX();
            if (x < 0) continue;
            list.add(pivotFields.get(x));
        }
        return list;
    }

    private static CTColFields initColFields(CTPivotTableDefinition pivotTableDefinition) {
        CTColFields ctColFields = pivotTableDefinition.addNewColFields();
        CTRowItems rowItems = pivotTableDefinition.getRowItems();
        if (rowItems == null) {
            rowItems = pivotTableDefinition.addNewRowItems();
            rowItems.addNewI();
            rowItems.setCount(1L);
        }
        return ctColFields;
    }

    public void setColumnField(PivotField field) {
        int idx = this.getPivotFieldIndex(field, this.getPivotFields());
        if (idx < 0) {
            throw new IllegalArgumentException("Can't find PivotField");
        }
        boolean typeChanged = false;
        PivotField.Type type = field.getType();
        if (type != null) {
            switch (type) {
                case ROW: {
                    typeChanged = true;
                    this.removeRowField(idx, field);
                    break;
                }
                case DATA: {
                    typeChanged = true;
                    this.removeDataField(idx, field);
                }
            }
        } else {
            typeChanged = true;
        }
        if (typeChanged) {
            field.setType(PivotField.Type.COLUMN);
            CTColFields colFields = this._pivotTableDefinition.getColFields();
            if (colFields == null) {
                colFields = XSSFPivotTable.initColFields(this._pivotTableDefinition);
            }
            int count = (int)colFields.getCount();
            List<DataField> dataFields = this.getDataFields();
            boolean insrtDataCol = false;
            if (dataFields.size() > 1 && !this.getDataOnRows()) {
                CTField f;
                insrtDataCol = true;
                int lastIdx = count - 1;
                if (lastIdx >= 0 && (f = colFields.getFieldArray()[lastIdx]).getX() == -2) {
                    colFields.removeField(lastIdx);
                }
            }
            colFields.addNewField().setX(idx);
            if (insrtDataCol) {
                colFields.addNewField().setX(-2);
            }
            colFields.setCount((long)colFields.getFieldArray().length);
        }
    }

    public void setDataCaption(String caption) {
        this._pivotTableDefinition.setDataCaption(caption);
    }

    public String getDataCaption() {
        return this._pivotTableDefinition.getDataCaption();
    }

    public List<DataField> getDataFields() {
        CTDataField[] dataFieldArray;
        CTDataFields dataFields = this._pivotTableDefinition.getDataFields();
        if (dataFields == null) {
            return Collections.emptyList();
        }
        ArrayList<DataField> list = new ArrayList<DataField>();
        List<PivotField> pivotFields = this.getPivotFields();
        for (CTDataField dataField : dataFieldArray = dataFields.getDataFieldArray()) {
            PivotField pivotField = pivotFields.get((int)dataField.getFld());
            list.add(new XSSFDataField(dataField, pivotField));
        }
        return list;
    }

    public void setDataField(PivotField field, String name, Calculation subtotal) {
        CTColItems colItems;
        CTDataFields dataFields = this._pivotTableDefinition.getDataFields();
        if (dataFields == null) {
            dataFields = this._pivotTableDefinition.addNewDataFields();
        }
        CTDataField dataField = dataFields.addNewDataField();
        dataField.setName(name);
        int idx = this.getPivotFieldIndex(field, this.getPivotFields());
        if (idx < 0) {
            throw new IllegalArgumentException("Can't find PivotField");
        }
        field.setType(PivotField.Type.DATA);
        dataField.setFld((long)idx);
        dataField.setSubtotal(XSSFDataField.getSubtotalType(subtotal));
        dataField.setBaseField(0);
        dataField.setBaseItem(0L);
        dataFields.setCount((long)dataFields.getDataFieldArray().length);
        CTRowItems rowItems = this._pivotTableDefinition.getRowItems();
        if (rowItems == null) {
            rowItems = this._pivotTableDefinition.addNewRowItems();
            rowItems.addNewI();
            rowItems.setCount((long)rowItems.getIArray().length);
        }
        if ((colItems = this._pivotTableDefinition.getColItems()) == null) {
            colItems = this._pivotTableDefinition.addNewColItems();
            colItems.addNewI();
            colItems.setCount((long)colItems.getIArray().length);
        }
    }

    public void setFirstHeaderRow(int row) {
        this.getCTLocation().setFirstHeaderRow((long)row);
    }

    public CTLocation getCTLocation() {
        CTLocation location = this._pivotTableDefinition.getLocation();
        if (location == null) {
            return this._pivotTableDefinition.addNewLocation();
        }
        return location;
    }

    public CTColFields getCTColFields() {
        CTColFields colFields = this._pivotTableDefinition.getColFields();
        if (colFields == null) {
            return XSSFPivotTable.initColFields(this._pivotTableDefinition);
        }
        return colFields;
    }

    public CTRowFields getCTRowFields() {
        CTRowFields rowFields = this._pivotTableDefinition.getRowFields();
        if (rowFields == null) {
            return XSSFPivotTable.initRowFields(this._pivotTableDefinition);
        }
        return rowFields;
    }

    public void setFirstData(int row, int col) {
        CTLocation ctLocation = this.getCTLocation();
        ctLocation.setFirstDataRow((long)row);
        ctLocation.setFirstDataCol((long)col);
    }

    public void setLocationRef(AreaReference ref) {
        this.getCTLocation().setRef(ref.formatAsString());
    }

    public AreaReference getLocationRef() {
        return new AreaReference(this._pivotTableDefinition.getLocation().getRef());
    }

    public CellReference getFirstDataRef() {
        CellReference firstCellRef = this.getLocationRef().getFirstCell();
        CTLocation l = this.getCTLocation();
        int col = firstCellRef.getCol() + (int)l.getFirstDataCol();
        int row = firstCellRef.getRow() + (int)l.getFirstDataRow();
        return new CellReference(row, col);
    }

    public void setGrandTotalCaption(String caption) {
        this._pivotTableDefinition.setGrandTotalCaption(caption);
    }

    public String getGrandTotalCaption() {
        return this._pivotTableDefinition.getGrandTotalCaption();
    }

    public void setName(String name) {
        this._pivotTableDefinition.setName(name);
    }

    public String getName() {
        return this._pivotTableDefinition.getName();
    }

    public PivotCache getPivotCache() {
        return this._pivotCache;
    }

    public PivotField getPivotField(String name) {
        List<PivotField> pivotFields = this.getPivotFields();
        for (PivotField f : pivotFields) {
            String fName = f.getName();
            if (!fName.equalsIgnoreCase(name)) continue;
            return f;
        }
        return null;
    }

    public List<PivotField> getPivotFields() {
        if (this._pivotFields == null) {
            this.initPivotFields();
        }
        return new ArrayList<PivotField>(this._pivotFields.values());
    }

    private void initPivotFields() {
        this._pivotFields = new LinkedHashMap();
        CTPivotFields pivotFields = this._pivotTableDefinition.getPivotFields();
        if (pivotFields == null) {
            return;
        }
        Iterator<PivotCache.CacheField> iterator = this._pivotCache.getFields().iterator();
        for (CTPivotField f : pivotFields.getPivotFieldArray()) {
            XSSFPivotField pf = new XSSFPivotField(f, iterator.next(), this);
            this._pivotFields.put(pf.getName(), pf);
        }
    }

    private int getPivotFieldIndex(PivotField pivotField, List<PivotField> from) {
        int i = 0;
        for (PivotField pf : from) {
            if (pf.equals(pivotField)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public List<PivotField> getRowFields() {
        CTRowFields rowFields = this._pivotTableDefinition.getRowFields();
        if (rowFields == null) {
            return Collections.emptyList();
        }
        ArrayList<PivotField> list = new ArrayList<PivotField>();
        List<PivotField> pivotFields = this.getPivotFields();
        for (CTField f : rowFields.getFieldArray()) {
            int idx = f.getX();
            if (idx < 0) continue;
            list.add(pivotFields.get(idx));
        }
        return list;
    }

    private static CTRowFields initRowFields(CTPivotTableDefinition pivotTableDefinition) {
        CTRowFields rowFields = pivotTableDefinition.addNewRowFields();
        CTColItems colItems = pivotTableDefinition.getColItems();
        if (colItems == null) {
            colItems = pivotTableDefinition.addNewColItems();
            colItems.addNewI();
            colItems.setCount(1L);
        }
        return rowFields;
    }

    public Sheet getSheet() {
        return (Sheet)this.getParent();
    }

    private ItemInfo getNonDataTypeItem(List<ItemInfo> items) {
        for (int i = 0; i < items.size(); ++i) {
            ItemInfo info = items.get(i);
            if (info == null || info.getType() == PivotField.Item.Type.DATA) continue;
            return info;
        }
        return null;
    }

    public void setColumnItems(List<List<ItemInfo>> items) {
        CTColItems colItems = this._pivotTableDefinition.getColItems();
        if (colItems != null) {
            this._pivotTableDefinition.unsetColItems();
        }
        colItems = this._pivotTableDefinition.addNewColItems();
        IndexMapper indexMapper = new IndexMapper(this.getColumnFields());
        DataFieldIndexMapper dataIndexMapper = null;
        List<DataField> dataFields = this.getDataFields();
        if (!this.getDataOnRows() && dataFields.size() > 1) {
            dataIndexMapper = new DataFieldIndexMapper(dataFields);
        }
        int itemSize = items.size();
        for (int c = 0; c < itemSize; ++c) {
            List<ItemInfo> col = items.get(c);
            ItemInfo info = this.getNonDataTypeItem(col);
            if (info != null) {
                int index;
                CTI ctI = colItems.addNewI();
                if (info.getDepth() > 0) {
                    ctI.setR((long)info.getDepth());
                }
                PivotField.Item.Type type = info.getType();
                CTX ctX = ctI.addNewX();
                ctI.setT(XSSFPivotField.XSSFItem.getCTItemType(type));
                if (type == PivotField.Item.Type.GRAND) {
                    index = info.getIndex();
                    if (index <= 0) continue;
                    ctX.setV(index);
                    continue;
                }
                index = indexMapper.getShareItemIndex(info.getDepth(), info.getValue());
                if (index <= 0) continue;
                ctX.setV(index);
                continue;
            }
            boolean setRowIndex = false;
            Integer firstRowIndex = null;
            CTI ctI = colItems.addNewI();
            for (int i = 0; i < col.size(); ++i) {
                ItemInfo item = col.get(i);
                if (item != null) {
                    int depth;
                    if (firstRowIndex == null) {
                        firstRowIndex = i;
                    }
                    if ((depth = item.getDepth()) >= 0) {
                        CTX ctX = ctI.addNewX();
                        int idx = indexMapper.getShareItemIndex(i, item.getValue());
                        if (idx < 0) {
                            throw new IllegalArgumentException("can't find item: " + item.getValue());
                        }
                        if (idx <= 0) continue;
                        ctX.setV(idx);
                        continue;
                    }
                    int idx = dataIndexMapper.getIndex((String)item.getValue());
                    if (idx < 0) {
                        throw new IllegalArgumentException("can't find item: " + item.getValue());
                    }
                    CTX ctX = ctI.addNewX();
                    if (idx <= 0) continue;
                    ctI.setI((long)idx);
                    ctX.setV(idx);
                    continue;
                }
                setRowIndex = true;
            }
            if (!setRowIndex || firstRowIndex == null) continue;
            ctI.setR((long)firstRowIndex.intValue());
        }
        colItems.setCount((long)colItems.getIArray().length);
    }

    public void setRowItems(List<List<ItemInfo>> items) {
        CTRowItems rowItems = this._pivotTableDefinition.getRowItems();
        if (rowItems != null) {
            this._pivotTableDefinition.unsetRowItems();
        }
        rowItems = this._pivotTableDefinition.addNewRowItems();
        IndexMapper indexMapper = new IndexMapper(this.getRowFields());
        DataFieldIndexMapper dataIndexMapper = null;
        List<DataField> dataFields = this.getDataFields();
        if (this.getDataOnRows() && dataFields.size() > 1) {
            dataIndexMapper = new DataFieldIndexMapper(dataFields);
        }
        int itemSize = items.size();
        for (int i = 0; i < itemSize; ++i) {
            List<ItemInfo> row = items.get(i);
            ItemInfo info = this.getNonDataTypeItem(row);
            if (info != null) {
                int index;
                CTI ctI = rowItems.addNewI();
                if (info.getDepth() > 0) {
                    ctI.setR((long)info.getDepth());
                }
                PivotField.Item.Type type = info.getType();
                CTX ctX = ctI.addNewX();
                ctI.setT(XSSFPivotField.XSSFItem.getCTItemType(type));
                if (type == PivotField.Item.Type.GRAND) {
                    index = info.getIndex();
                    if (index <= 0) continue;
                    ctX.setV(index);
                    continue;
                }
                index = indexMapper.getShareItemIndex(info.getDepth(), info.getValue());
                if (index <= 0) continue;
                ctX.setV(index);
                continue;
            }
            boolean setColumnIndex = false;
            Integer firstColumnIndex = null;
            CTI ctI = rowItems.addNewI();
            for (int c = 0; c < row.size(); ++c) {
                ItemInfo item = row.get(c);
                if (item != null) {
                    int depth;
                    if (firstColumnIndex == null) {
                        firstColumnIndex = c;
                    }
                    if ((depth = item.getDepth()) >= 0) {
                        CTX ctX = ctI.addNewX();
                        int idx = indexMapper.getShareItemIndex(c, item.getValue());
                        if (idx < 0) {
                            throw new IllegalArgumentException("can't find item: " + item.getValue());
                        }
                        if (idx <= 0) continue;
                        ctX.setV(idx);
                        continue;
                    }
                    int idx = dataIndexMapper.getIndex((String)item.getValue());
                    if (idx < 0) {
                        throw new IllegalArgumentException("can't find item: " + item.getValue());
                    }
                    CTX ctX = ctI.addNewX();
                    if (idx <= 0) continue;
                    ctI.setI((long)idx);
                    ctX.setV(idx);
                    continue;
                }
                setColumnIndex = true;
            }
            if (!setColumnIndex || firstColumnIndex == null) continue;
            ctI.setR((long)firstColumnIndex.intValue());
        }
        rowItems.setCount((long)rowItems.getIArray().length);
    }

    public void setRowField(PivotField field) {
        int idx = this.getPivotFieldIndex(field, this.getPivotFields());
        if (idx < 0) {
            throw new IllegalArgumentException("Can't find PivotField");
        }
        boolean typeChanged = false;
        PivotField.Type type = field.getType();
        if (type != null) {
            switch (type) {
                case COLUMN: {
                    typeChanged = true;
                    this.removeColumnField(idx, field);
                    break;
                }
                case DATA: {
                    typeChanged = true;
                    this.removeDataField(idx, field);
                }
            }
        } else {
            typeChanged = true;
        }
        if (typeChanged) {
            field.setType(PivotField.Type.ROW);
            CTRowFields rowFields = this._pivotTableDefinition.getRowFields();
            if (rowFields == null) {
                rowFields = XSSFPivotTable.initRowFields(this._pivotTableDefinition);
            }
            int count = (int)rowFields.getCount();
            List<DataField> dataFields = this.getDataFields();
            boolean insrtDataRow = false;
            if (dataFields.size() > 1 && this.getDataOnRows()) {
                CTField f;
                insrtDataRow = true;
                int lastIdx = count - 1;
                if (lastIdx >= 0 && (f = rowFields.getFieldArray()[lastIdx]).getX() == -2) {
                    rowFields.removeField(lastIdx);
                }
            }
            rowFields.addNewField().setX(idx);
            if (insrtDataRow) {
                rowFields.addNewField().setX(-2);
            }
            rowFields.setCount((long)rowFields.getFieldArray().length);
        }
    }

    private void removeDataField(int idx, PivotField field) {
        CTDataField dataField = null;
        CTDataFields dataFields = this._pivotTableDefinition.getDataFields();
        int i = 0;
        for (CTDataField d : dataFields.getDataFieldArray()) {
            if (d.getFld() == (long)idx) {
                dataField = d;
                break;
            }
            ++i;
        }
        if (dataField != null) {
            dataFields.removeDataField(i);
            dataFields.setCount((long)dataFields.getDataFieldArray().length);
        }
    }

    private void removeRowField(int idx, PivotField field) {
        CTField ctField = null;
        CTRowFields rowFields = this._pivotTableDefinition.getRowFields();
        int i = 0;
        for (CTField f : rowFields.getFieldArray()) {
            if (f.getX() != idx) continue;
            ctField = f;
            break;
        }
        if (ctField != null) {
            rowFields.removeField(i);
            rowFields.setCount((long)rowFields.getFieldArray().length);
        }
    }

    private void removeColumnField(int idx, PivotField field) {
        CTField ctField = null;
        CTColFields colFields = this._pivotTableDefinition.getColFields();
        int i = 0;
        for (CTField f : colFields.getFieldArray()) {
            if (f.getX() == idx) {
                ctField = f;
                break;
            }
            ++i;
        }
        if (ctField != null) {
            colFields.removeField(i);
            colFields.setCount((long)colFields.getFieldArray().length);
        }
    }

    public void setDataOnRows(boolean dataOnRows) {
        this._pivotTableDefinition.setDataOnRows(dataOnRows);
    }

    public boolean getDataOnRows() {
        return this._pivotTableDefinition.getDataOnRows();
    }

    public String getRowHeaderCaption() {
        return this._pivotTableDefinition.getRowHeaderCaption();
    }

    public void setRowHeaderCaption(String caption) {
        this._pivotTableDefinition.setRowHeaderCaption(caption);
    }

    public void setOutline(boolean outline) {
        this._pivotTableDefinition.setOutline(outline);
    }

    public boolean getOutline() {
        return this._pivotTableDefinition.getOutline();
    }

    public void setOutlineData(boolean outlineData) {
        this._pivotTableDefinition.setOutlineData(outlineData);
    }

    public boolean getOutlineData() {
        return this._pivotTableDefinition.getOutlineData();
    }

    private class DataFieldIndexMapper {
        HashMap<String, Integer> _mapper = new HashMap();

        DataFieldIndexMapper(List<DataField> dataFields) {
            for (int i = 0; i < dataFields.size(); ++i) {
                DataField f = dataFields.get(i);
                this._mapper.put(f.getName(), i);
            }
        }

        int getIndex(String str) {
            Integer index = this._mapper.get(str);
            if (index != null) {
                return index;
            }
            return -1;
        }
    }

    private class IndexMapper {
        List<HashMap<Object, Integer>> _mapper = new ArrayList<HashMap<Object, Integer>>();

        IndexMapper(List<PivotField> fields) {
            for (PivotField pivotField : fields) {
                HashMap<Object, Integer> map = new HashMap<Object, Integer>();
                this._mapper.add(map);
                List items = pivotField.getItems();
                for (int j = 0; j < items.size(); ++j) {
                    PivotField.Item item = (PivotField.Item)items.get(j);
                    Object value = item.getValue();
                    if (value instanceof Calendar) {
                        map.put(((Calendar)value).getTime(), j);
                        continue;
                    }
                    if (value instanceof Number) {
                        map.put(((Number)value).doubleValue(), j);
                        continue;
                    }
                    map.put(value != null ? value.toString() : null, j);
                }
            }
        }

        int getShareItemIndex(int fieldIndex, Object key) {
            HashMap<Object, Integer> map = this._mapper.get(fieldIndex);
            Integer index = map.get(key);
            if (index != null) {
                return index;
            }
            return -1;
        }
    }
}

