/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBoolean;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCacheField;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDateTime;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTIndex;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTNumber;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRecord;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSharedItems;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTString;
import org.w3c.dom.Node;
import org.zkoss.poi.ss.usermodel.PivotCache;

public class XSSFCacheRecord
implements PivotCache.CacheRecord,
Serializable {
    private static final long serialVersionUID = 6090905779116889504L;
    private CTRecord _record;
    private CTCacheField[] _fields;
    private List<Object> _data;

    XSSFCacheRecord(CTRecord record, CTCacheField[] fields) {
        this._record = record;
        this._fields = fields;
    }

    public List<Object> getData() {
        if (this._data == null) {
            this.initData();
        }
        return this._data;
    }

    private void initData() {
        CTBoolean[] bArray;
        CTDateTime[] dArray;
        CTString[] sArray;
        CTNumber[] nArray;
        this._data = new ArrayList<Object>();
        HashMap<Integer, Object> dataMap = new HashMap<Integer, Object>();
        IndexMapper indexMapper = new IndexMapper(this._record.getDomNode());
        CTIndex[] xArray = this._record.getXArray();
        if (xArray != null) {
            for (CTIndex e : xArray) {
                int index = (Integer)indexMapper.get(e.getDomNode());
                CTSharedItems sharedItems = this._fields[index].getSharedItems();
                CTString[] sArray2 = sharedItems.getSArray();
                String s = sArray2[(int)e.getV()].getV();
                dataMap.put(index, s);
            }
        }
        if ((nArray = this._record.getNArray()) != null) {
            for (CTNumber n : nArray) {
                int index = (Integer)indexMapper.get(n.getDomNode());
                dataMap.put(index, n.getV());
            }
        }
        if ((sArray = this._record.getSArray()) != null) {
            for (CTString s : sArray) {
                int index = (Integer)indexMapper.get(s.getDomNode());
                dataMap.put(index, s.getV());
            }
        }
        if ((dArray = this._record.getDArray()) != null) {
            for (CTDateTime d : dArray) {
                int index = (Integer)indexMapper.get(d.getDomNode());
                dataMap.put(index, d.getV());
            }
        }
        if ((bArray = this._record.getBArray()) != null) {
            for (CTBoolean b : bArray) {
                int index = (Integer)indexMapper.get(b.getDomNode());
                dataMap.put(index, b.getV());
            }
        }
        for (int i = 0; i < dataMap.size(); ++i) {
            this._data.add(dataMap.get(i));
        }
    }

    private class IndexMapper
    extends HashMap<Node, Integer> {
        IndexMapper(Node parent) {
            int i = 0;
            for (Node chd = parent.getFirstChild(); chd != null; chd = chd.getNextSibling()) {
                this.put(chd, i++);
            }
        }
    }
}

