/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCacheField;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDateTime;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDiscretePr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFieldGroup;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTGroupItems;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTIndex;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTNumber;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSharedItems;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTString;
import org.zkoss.poi.ss.usermodel.PivotCache;

public class XSSFCacheField
implements PivotCache.CacheField,
Serializable {
    private static final long serialVersionUID = -5976672310014964599L;
    private final CTCacheField _cacheField;

    XSSFCacheField(CTCacheField cacheField) {
        this._cacheField = cacheField;
        this._cacheField.getDatabaseField();
    }

    public void setName(String name) {
        this._cacheField.setName(name);
    }

    public String getName() {
        return this._cacheField.getName();
    }

    private static void addDates(CTDateTime[] from, List<Object> to) {
        if (from != null) {
            for (CTDateTime e : from) {
                to.add(e.getV());
            }
        }
    }

    private static void addNumbers(CTNumber[] from, List<Object> to) {
        if (from != null) {
            for (CTNumber e : from) {
                to.add(e.getV());
            }
        }
    }

    private static void addStrings(CTString[] from, List<Object> to) {
        if (from != null) {
            for (CTString e : from) {
                to.add(e.getV());
            }
        }
    }

    public List<Object> getSharedItems() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this._cacheField.getDatabaseField()) {
            CTSharedItems sharedItems = this._cacheField.getSharedItems();
            if (sharedItems != null) {
                if (sharedItems.getContainsBlank()) {
                    list.add(null);
                }
                XSSFCacheField.addDates(sharedItems.getDArray(), list);
                XSSFCacheField.addNumbers(sharedItems.getNArray(), list);
                XSSFCacheField.addStrings(sharedItems.getSArray(), list);
                return list;
            }
        } else {
            CTFieldGroup fieldGroup = this._cacheField.getFieldGroup();
            if (fieldGroup != null) {
                CTGroupItems groupItems = fieldGroup.getGroupItems();
                XSSFCacheField.addDates(groupItems.getDArray(), list);
                XSSFCacheField.addNumbers(groupItems.getNArray(), list);
                XSSFCacheField.addStrings(groupItems.getSArray(), list);
                return list;
            }
        }
        return list;
    }

    public void setDatabaseField(boolean databaseField) {
        this._cacheField.setDatabaseField(databaseField);
    }

    public boolean getDatabaseField() {
        return this._cacheField.getDatabaseField();
    }

    public List<Integer> getGroupDiscrete() {
        CTFieldGroup fieldGroup = this._cacheField.getFieldGroup();
        if (fieldGroup == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        CTDiscretePr discretePr = fieldGroup.getDiscretePr();
        for (CTIndex i : discretePr.getXArray()) {
            list.add((int)i.getV());
        }
        return list;
    }

    public int getFieldGroup() {
        CTFieldGroup fieldGroup = this._cacheField.getFieldGroup();
        if (fieldGroup == null) {
            return -1;
        }
        return (int)fieldGroup.getPar();
    }

    public int getGroupBase() {
        CTFieldGroup fieldGroup = this._cacheField.getFieldGroup();
        if (fieldGroup == null) {
            return -1;
        }
        return (int)fieldGroup.getBase();
    }

    public long getNumberFormatId() {
        return this._cacheField.getNumFmtId();
    }
}

