/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.util;

import java.util.Locale;
import org.zkoss.poi.ss.format.Formatters;
import org.zkoss.poi.ss.util.ExpandedDouble;
import org.zkoss.poi.ss.util.NormalisedDecimal;
import org.zkoss.poi.ss.util.NumberToTextConverter;

public class NumberToGeneralTextConverter {
    private static final int ZERO = Character.getNumericValue('0');

    public static String toGeneralText(double value, Locale locale, int maxLen) {
        if (maxLen <= 0) {
            return "";
        }
        return NumberToGeneralTextConverter.rawDoubleBitsToGeneralText(Double.doubleToLongBits(value), locale, maxLen);
    }

    static String rawDoubleBitsToGeneralText(long pRawBits, Locale locale, int maxLen) {
        String decimalDigits;
        NormalisedDecimal nd;
        NormalisedDecimal rnd;
        int decExponent;
        boolean isNegative;
        long rawBits = pRawBits;
        boolean bl = isNegative = rawBits < 0L;
        if (isNegative) {
            rawBits &= Long.MAX_VALUE;
        }
        if (rawBits == 0L) {
            return isNegative ? "-0" : "0";
        }
        ExpandedDouble ed = new ExpandedDouble(rawBits);
        if (ed.getBinaryExponent() < -1022) {
            return isNegative ? "-0" : "0";
        }
        maxLen = maxLen >= 12 ? 11 : (isNegative ? maxLen - 1 : maxLen);
        char dot = Formatters.getDecimalSeparator((Locale)locale);
        if (ed.getBinaryExponent() == 1024) {
            if (rawBits == -276939487313920L) {
                return NumberToGeneralTextConverter.convertToGeneralText("3" + dot + "484840871308", "+308", 308, maxLen, dot, false);
            }
            isNegative = false;
        }
        if (Math.abs(decExponent = (rnd = (nd = ed.normaliseBaseTen()).roundUnits()).getDecimalExponent()) > 98) {
            decimalDigits = rnd.getSignificantDecimalDigitsLastDigitRounded();
            if (decimalDigits.length() == 16) {
                ++decExponent;
            }
        } else {
            decimalDigits = rnd.getSignificantDecimalDigits();
        }
        int countSigDigits = NumberToTextConverter.countSignifantDigits((String)decimalDigits);
        decimalDigits = decimalDigits.substring(0, countSigDigits);
        decimalDigits = "" + decimalDigits.charAt(0) + dot + (decimalDigits.length() > 1 ? decimalDigits.substring(1) : "");
        return NumberToGeneralTextConverter.convertToGeneralText(decimalDigits, NumberToGeneralTextConverter.getExp(decExponent), decExponent, maxLen, dot, isNegative);
    }

    private static String getExp(int decExponent) {
        StringBuilder sb = new StringBuilder(5);
        if (decExponent < 0) {
            sb.append('-');
            NumberToTextConverter.appendExp((StringBuilder)sb, (int)(-decExponent));
        } else {
            sb.append('+');
            NumberToTextConverter.appendExp((StringBuilder)sb, (int)decExponent);
        }
        return sb.toString();
    }

    private static String convertToGeneralText(String base, String exp, int e, int maxLen, char dot, boolean isNegative) {
        int blen = base.length();
        int nExpDigits = exp.length() + 1;
        int nExpSpace = maxLen - nExpDigits;
        if (nExpSpace > 1) {
            --nExpSpace;
        }
        if (e < 0) {
            int nLeadingZeros = -e - 1;
            int nLiteralSpace = maxLen - 2 - nLeadingZeros;
            int nSignificantDigits = blen - 1;
            if (nLiteralSpace >= nSignificantDigits || nLiteralSpace > 0 && nLiteralSpace >= nExpSpace) {
                return NumberToGeneralTextConverter.literalNotation(base, exp, blen, e, maxLen, dot, isNegative);
            }
            if (nExpSpace > 0) {
                return NumberToGeneralTextConverter.scientificNotation(base, exp, e, maxLen, dot, isNegative);
            }
            if (maxLen > 0 && nExpSpace < 0) {
                if (maxLen < nLeadingZeros + 2) {
                    return isNegative ? "-0" : "0";
                }
                return NumberToGeneralTextConverter.literalNotation(base, exp, blen, e, maxLen, dot, isNegative);
            }
            return NumberToGeneralTextConverter.overflowNotation(isNegative ? maxLen + 1 : maxLen);
        }
        if (e >= maxLen) {
            if (nExpSpace > 0) {
                return NumberToGeneralTextConverter.scientificNotation(base, exp, e, maxLen, dot, isNegative);
            }
            return NumberToGeneralTextConverter.overflowNotation(isNegative ? maxLen + 1 : maxLen);
        }
        return NumberToGeneralTextConverter.literalNotation(base, exp, blen, e, maxLen, dot, isNegative);
    }

    private static String overflowNotation(int maxLen) {
        StringBuilder sb = new StringBuilder(maxLen);
        for (int j = maxLen; j > 0; --j) {
            sb.append('#');
        }
        return sb.toString();
    }

    private static String scientificNotation(String base, String exp, int e, int maxLen, char dot, boolean isNegative) {
        StringBuilder sb = new StringBuilder(maxLen + 1);
        if (isNegative) {
            sb.append('-');
        }
        int roundIndex = maxLen - exp.length() - 1;
        String newbase = NumberToGeneralTextConverter.carryDigits(base, roundIndex, dot);
        return sb.append(newbase).append('E').append(exp).toString();
    }

    private static String literalNotation(String base, String exp, int blen, int e, int maxLen, char dot, boolean isNegative) {
        StringBuilder sb = new StringBuilder(maxLen + 1);
        if (isNegative) {
            sb.append('-');
        }
        if (e < 0) {
            int nLeadingZeros = -e - 1;
            sb.append("0" + dot);
            for (int j = nLeadingZeros; j > 0; --j) {
                sb.append('0');
            }
            sb.append(base.charAt(0)).append(base.substring(2));
        } else {
            int dotPos = 1 + e;
            if (blen > dotPos + 1) {
                if (dotPos == 1) {
                    sb.append(base);
                } else {
                    sb.append(base.charAt(0)).append(base.substring(2, dotPos + 1)).append(dot).append(base.substring(dotPos + 1));
                }
            } else {
                int nAppendZeros = dotPos + 1 - blen;
                sb.append(base.charAt(0)).append(base.substring(2));
                for (int j = nAppendZeros; j > 0; --j) {
                    sb.append('0');
                }
            }
        }
        return NumberToGeneralTextConverter.carryDigits(sb.toString(), isNegative ? maxLen + 1 : maxLen, dot);
    }

    private static String carryDigits(String v, int roundIndex, char dot) {
        if (v.length() <= roundIndex) {
            return v;
        }
        boolean withDot = false;
        if (v.charAt(roundIndex) >= '5') {
            char[] list0 = new char[roundIndex];
            boolean carry = true;
            int k = roundIndex;
            while (--k >= 0) {
                char ch = v.charAt(k);
                if (ch != dot) {
                    if (carry) {
                        if (ch == '9') {
                            list0[k] = 48;
                            carry = true;
                            continue;
                        }
                        list0[k] = Character.forDigit(Character.getNumericValue(ch) + 1 - ZERO, 10);
                        carry = false;
                        continue;
                    }
                } else {
                    withDot = true;
                }
                list0[k] = ch;
            }
            v = String.valueOf(list0);
        }
        return NumberToGeneralTextConverter.removeTailZeros(v, roundIndex, withDot, dot);
    }

    static String removeTailZeros(String v, int roundIndex, boolean withDot, char dot) {
        int r = -1;
        int j = roundIndex;
        while (--j >= 0) {
            char ch = v.charAt(j);
            if (ch == dot) {
                withDot = true;
                if (r >= 0) break;
                r = j;
                break;
            }
            if (ch == '0' || r >= 0) continue;
            r = j + 1;
            if (!withDot) continue;
            break;
        }
        return v.substring(0, withDot ? r : roundIndex);
    }
}

