/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STXstring;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFont;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRElt;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRPrElt;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRst;

public class XSSFRichTextStringHelper {
    public static void addRun(XSSFRichTextString richTextString, String text, XSSFFont font) {
        CTRst st = richTextString.getCTRst();
        if (st.sizeOfRArray() == 0 && st.isSetT()) {
            st.unsetT();
        }
        CTRElt lt = st.addNewR();
        lt.setT(XSSFRichTextStringHelper.utfEncode(text));
        XSSFRichTextString.preserveSpaces((STXstring)lt.xgetT());
        CTRPrElt pr = lt.addNewRPr();
        if (font != null) {
            Method setRunAttributes = null;
            try {
                setRunAttributes = richTextString.getClass().getDeclaredMethod("setRunAttributes", CTFont.class, CTRPrElt.class);
                setRunAttributes.setAccessible(true);
                setRunAttributes.invoke((Object)richTextString, font.getCTFont(), pr);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (setRunAttributes != null) {
                    setRunAttributes.setAccessible(false);
                }
            }
        }
    }

    public static String utfEncode(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        int len = value.length();
        for (int j = 0; j < len; ++j) {
            char ch = value.charAt(j);
            if (Character.isISOControl(ch) && ch != '\n') {
                char code = ch;
                String s = Integer.toString(code, 16).toUpperCase();
                buf.append("_x").append((String)(s.length() <= 4 ? "0000".substring(s.length()) + s : s)).append("_");
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }
}

