/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel;

import java.util.Locale;
import org.zkoss.lang.Library;
import org.zkoss.util.Locales;

public class ZssContext {
    private final Locale locale;
    private final int twoDigitYearUpperBound;
    private final int maxCount;
    private final double maxChange;
    private static final String KEIKAI_FORMULA_MAX_ITERATIONS = "io.keikai.formula.maxIterations";
    private static final String KEIKAI_FORMULA_MAX_CHANGE = "io.keikai.formula.maxChange";
    private static final InheritableThreadLocal<ZssContext> _thdLocale = new InheritableThreadLocal();

    public ZssContext(Locale locale, int twoDigitYearUpperBound) {
        this.locale = locale;
        this.twoDigitYearUpperBound = twoDigitYearUpperBound;
        this.maxChange = 0.001;
        this.maxCount = 0;
    }

    public ZssContext(Locale locale, int twoDigitYearUpperBound, double maxChange, int maxCount) {
        this.locale = locale;
        this.twoDigitYearUpperBound = twoDigitYearUpperBound;
        this.maxChange = Math.abs(maxChange);
        this.maxCount = maxCount;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int getTwoDigitYearUpperBound() {
        return this.twoDigitYearUpperBound;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public double getMaxChange() {
        return this.maxChange;
    }

    public static final ZssContext getCurrent() {
        ZssContext zssContext = (ZssContext)_thdLocale.get();
        if (zssContext == null) {
            double _maxChange;
            int _maxIters = Library.getIntProperty((String)KEIKAI_FORMULA_MAX_ITERATIONS, (int)0);
            String maxChangeStr = Library.getProperty((String)KEIKAI_FORMULA_MAX_CHANGE, (String)"0.001");
            try {
                _maxChange = Double.parseDouble(maxChangeStr);
            }
            catch (NumberFormatException ex) {
                _maxChange = 0.001;
            }
            return new ZssContext(Locales.getCurrent(), -1, _maxChange, _maxIters);
        }
        return zssContext;
    }

    public static final ZssContext setThreadLocal(ZssContext ctx) {
        ZssContext old = (ZssContext)_thdLocale.get();
        _thdLocale.set(ctx);
        return old;
    }

    public static final ZssContext getThreadLocal() {
        return (ZssContext)_thdLocale.get();
    }
}

