/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.token;

import java.util.Collections;
import java.util.List;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.formula.FormulaTokenParser;
import org.apache.poi.ss.formula.token.FormulaTokenNode;
import org.apache.poi.ss.formula.token.NodeId;
import org.apache.poi.ss.formula.token.TokenNodeVisitor;

public abstract class ErrorNode
implements FormulaTokenNode {
    public static final ErrorNode DIV_ERROR = new DivErrorNode();
    public static final ErrorNode NA_ERROR = new NAErrorNode();
    public static final ErrorNode NAME_ERROR = new NameErrorNode();
    public static final ErrorNode NULL_ERROR = new NullErrorNode();
    public static final ErrorNode NUM_ERROR = new NumErrorNode();
    public static final ErrorNode REF_ERROR = new RefErrorNode();
    public static final ErrorNode VALUE_ERROR = new ValueErrorNode();

    public abstract int getErrorCode();

    @Override
    public NodeId getNodeId() {
        return NodeId.ErrorNode;
    }

    @Override
    public int getType() {
        return 64;
    }

    @Override
    public boolean hasOperands() {
        return true;
    }

    @Override
    public boolean isOp() {
        return false;
    }

    @Override
    public boolean add(FormulaTokenNode child) {
        throw new FormulaParseException("ERROR operand should not have any child");
    }

    @Override
    public FormulaTokenNode normalize(FormulaTokenParser parser) {
        return this;
    }

    @Override
    public <R> R accept(TokenNodeVisitor<R> visitor) {
        return visitor.visitError(this);
    }

    @Override
    public <R> List<R> visitChildren(TokenNodeVisitor<R> visitor) {
        return Collections.emptyList();
    }

    private static class ValueErrorNode
    extends ErrorNode {
        private ValueErrorNode() {
        }

        public String toString() {
            return "#VALUE!";
        }

        @Override
        public int getErrorCode() {
            return 15;
        }
    }

    private static class RefErrorNode
    extends ErrorNode {
        private RefErrorNode() {
        }

        public String toString() {
            return "#REF!";
        }

        @Override
        public int getErrorCode() {
            return 23;
        }
    }

    private static class NumErrorNode
    extends ErrorNode {
        private NumErrorNode() {
        }

        public String toString() {
            return "#NUM!";
        }

        @Override
        public int getErrorCode() {
            return 36;
        }
    }

    private static class NullErrorNode
    extends ErrorNode {
        private NullErrorNode() {
        }

        public String toString() {
            return "#NULL!";
        }

        @Override
        public int getErrorCode() {
            return 0;
        }
    }

    private static class NameErrorNode
    extends ErrorNode {
        private NameErrorNode() {
        }

        public String toString() {
            return "#NAME?";
        }

        @Override
        public int getErrorCode() {
            return 29;
        }
    }

    private static class NAErrorNode
    extends ErrorNode {
        private NAErrorNode() {
        }

        public String toString() {
            return "#N/A";
        }

        @Override
        public int getErrorCode() {
            return 42;
        }
    }

    private static class DivErrorNode
    extends ErrorNode {
        private DivErrorNode() {
        }

        public String toString() {
            return "#DIV/0!";
        }

        @Override
        public int getErrorCode() {
            return 7;
        }
    }
}

