/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.common;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public class XFPropGradient {
    private int type;
    private double numDegree;
    private double numFillToLeft;
    private double numFillToRight;
    private double numFillToTop;
    private double numFillToBottom;

    public XFPropGradient(RecordInputStream in) {
        this.type = in.readInt();
        this.numDegree = in.readDouble();
        this.numFillToLeft = in.readDouble();
        this.numFillToRight = in.readDouble();
        this.numFillToTop = in.readDouble();
        this.numFillToBottom = in.readDouble();
    }

    public XFPropGradient(int type, double numDegree, double numFillToLeft, double numFillToRight, double numFillToTop, double numFillToBottom) {
        this.type = type;
        this.numDegree = numDegree;
        this.numFillToLeft = numFillToLeft;
        this.numFillToRight = numFillToRight;
        this.numFillToTop = numFillToTop;
        this.numFillToBottom = numFillToBottom;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getDataSize() {
        return 44;
    }

    public void serialize(LittleEndianOutput out) {
        out.writeInt(this.type);
        out.writeDouble(this.numDegree);
        out.writeDouble(this.numFillToLeft);
        out.writeDouble(this.numFillToRight);
        out.writeDouble(this.numFillToTop);
        out.writeDouble(this.numFillToBottom);
    }

    public void appendString(StringBuffer sb, String prefix) {
        sb.append(prefix).append("[XFPROPGRADIENT]").append("\n");
        sb.append(prefix).append("    .type           = ").append(HexDump.intToHex(this.type)).append("\n");
        sb.append(prefix).append("    .numDegree      = ").append(this.numDegree).append("\n");
        sb.append(prefix).append("    .numFillToLeft  = ").append(this.numFillToLeft).append("\n");
        sb.append(prefix).append("    .numFillToRight = ").append(this.numFillToRight).append("\n");
        sb.append(prefix).append("    .numFillToToop  = ").append(this.numFillToTop).append("\n");
        sb.append(prefix).append("    .numFillToBottom= ").append(this.numFillToBottom).append("\n");
        sb.append(prefix).append("[/XFPROPGRADIENT]").append("\n");
    }
}

