/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.common;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.common.XFPropColor;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public class XFPropBorder {
    private XFPropColor color;
    private short borderStyle;

    public XFPropBorder(RecordInputStream in) {
        this.color = new XFPropColor(in);
        this.borderStyle = in.readShort();
    }

    public XFPropBorder(XFPropColor color, int borderStyle) {
        this.color = color;
        this.borderStyle = (short)borderStyle;
    }

    public int getDataSize() {
        return this.color.getDataSize() + 2;
    }

    public void serialize(LittleEndianOutput out) {
        this.color.serialize(out);
        out.writeShort(this.borderStyle);
    }

    public void appendString(StringBuffer sb, String prefix) {
        sb.append(prefix).append("[XFPROPBORDER]").append("\n");
        sb.append(prefix).append("    .color       = \n");
        this.color.appendString(sb, prefix + "    ");
        sb.append(prefix).append("    .borderStyle = ").append(HexDump.shortToHex(this.borderStyle)).append("\n");
        sb.append(prefix).append("[/XFPROPBORDER]").append("\n");
    }
}

