/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.chart;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.hssf.record.HSSFRecordTypes;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public final class Chart3DBarShapeRecord
extends StandardRecord {
    public static final short sid = 4191;
    private short field_1_riser;
    private short field_2_taper;

    public Chart3DBarShapeRecord() {
    }

    public Chart3DBarShapeRecord(RecordInputStream in) {
        this.field_1_riser = in.readByte();
        this.field_2_taper = in.readByte();
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        out.writeByte(this.field_1_riser);
        out.writeByte(this.field_2_taper);
    }

    @Override
    public Chart3DBarShapeRecord copy() {
        return (Chart3DBarShapeRecord)this.clone();
    }

    @Override
    protected int getDataSize() {
        return 2;
    }

    @Override
    public short getSid() {
        return 4191;
    }

    @Override
    public HSSFRecordTypes getGenericRecordType() {
        return HSSFRecordTypes.CHART_3D_BAR;
    }

    public Object clone() {
        Chart3DBarShapeRecord rec = new Chart3DBarShapeRecord();
        rec.field_1_riser = this.field_1_riser;
        rec.field_2_taper = this.field_2_taper;
        return rec;
    }

    public short getRiser() {
        return this.field_1_riser;
    }

    public void setRiser(short field_1_riser) {
        this.field_1_riser = field_1_riser;
    }

    public short getTaper() {
        return this.field_2_taper;
    }

    public void setTaper(short field_2_taper) {
        this.field_2_taper = field_2_taper;
    }

    @Override
    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties("riser", () -> "0x" + HexDump.toHex(this.getRiser()), "taper", () -> "0x" + HexDump.toHex(this.getTaper()));
    }
}

