/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.hssf.record.HSSFRecordTypes;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.common.FtrHeader;
import org.apache.poi.hssf.record.cont.ContinuableRecord;
import org.apache.poi.hssf.record.cont.ContinuableRecordOutput;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.HexDump;

public final class ThemeRecord
extends ContinuableRecord {
    public static final int DEFAULT_THEME = 124226;
    private FtrHeader futureHeader;
    private int version;
    private byte[] _themedata;
    public static final short sid = 2198;

    public ThemeRecord() {
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2198);
        this.setVersion(124226);
    }

    public ThemeRecord(RecordInputStream in) {
        this.futureHeader = new FtrHeader(in);
        this.version = in.readInt();
        if (this.version == 0) {
            this._themedata = in.readRemainder();
        }
    }

    @Override
    public short getSid() {
        return 2198;
    }

    @Override
    public ThemeRecord copy() {
        return (ThemeRecord)this.clone();
    }

    @Override
    public HSSFRecordTypes getGenericRecordType() {
        return HSSFRecordTypes.THEME;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public byte[] getThemeData() {
        return this._themedata;
    }

    public Object clone() {
        return this.cloneViaReserialise();
    }

    @Override
    protected void serialize(ContinuableRecordOutput out) {
        this.futureHeader.serialize(out);
        out.writeInt(this.version);
        if (this._themedata != null) {
            out.write(this._themedata);
        }
    }

    @Override
    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties("version", () -> this.version, "themeData", () -> HexDump.toHex(this._themedata));
    }
}

