/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.hssf.record.HSSFRecordTypes;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.common.FtrHeader;
import org.apache.poi.hssf.record.common.UnicodeString;
import org.apache.poi.hssf.record.cont.ContinuableRecord;
import org.apache.poi.hssf.record.cont.ContinuableRecordOutput;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.GenericRecordUtil;

public final class HeaderFooterRecord
extends ContinuableRecord {
    public static final short sid = 2204;
    private static final byte[] BLANK_GUID = new byte[16];
    private static final BitField fHFDiffOddEven = BitFieldFactory.getInstance(1);
    private static final BitField fHFDiffFirst = BitFieldFactory.getInstance(2);
    private static final BitField fHFScaleWidthDoc = BitFieldFactory.getInstance(4);
    private static final BitField fHFAlignMargins = BitFieldFactory.getInstance(8);
    private FtrHeader futureHeader;
    byte[] guidSView = new byte[16];
    private short bits;
    private short cchHeaderEven;
    private short cchFooterEven;
    private short cchHeaderFirst;
    private short cchFooterFirst;
    private UnicodeString strHeaderEven;
    private UnicodeString strFooterEven;
    private UnicodeString strHeaderFirst;
    private UnicodeString strFooterFirst;
    private byte[] _rawData;

    public HeaderFooterRecord() {
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2204);
    }

    public HeaderFooterRecord(byte[] data) {
        this._rawData = data;
    }

    public HeaderFooterRecord(HeaderFooterRecord other) {
        super(other);
        this._rawData = other._rawData == null ? null : (byte[])other._rawData.clone();
        this.futureHeader = other.futureHeader.copy();
        this.bits = other.bits;
        this.cchHeaderEven = other.cchHeaderEven;
        this.cchFooterEven = other.cchFooterEven;
        this.cchHeaderFirst = other.cchHeaderFirst;
        this.cchFooterFirst = other.cchFooterFirst;
        if (this.cchHeaderEven > 0) {
            this.strHeaderEven = other.strHeaderEven.copy();
        }
        if (this.cchFooterEven > 0) {
            this.strFooterEven = other.strFooterEven.copy();
        }
        if (this.cchHeaderFirst > 0) {
            this.strHeaderFirst = other.strHeaderFirst.copy();
        }
        if (this.cchFooterFirst > 0) {
            this.strFooterFirst = other.strFooterFirst.copy();
        }
    }

    public HeaderFooterRecord(RecordInputStream in) {
        this.futureHeader = new FtrHeader(in);
        in.read(this.guidSView, 0, 16);
        this.bits = in.readShort();
        this.cchHeaderEven = in.readShort();
        this.cchFooterEven = in.readShort();
        this.cchHeaderFirst = in.readShort();
        this.cchFooterFirst = in.readShort();
        if (this.cchHeaderEven > 0) {
            this.strHeaderEven = new UnicodeString(in);
        }
        if (this.cchFooterEven > 0) {
            this.strFooterEven = new UnicodeString(in);
        }
        if (this.cchHeaderFirst > 0) {
            this.strHeaderFirst = new UnicodeString(in);
        }
        if (this.cchFooterFirst > 0) {
            this.strFooterFirst = new UnicodeString(in);
        }
    }

    @Override
    public void serialize(ContinuableRecordOutput out) {
        this.futureHeader.serialize(out);
        out.write(this.guidSView);
        out.writeShort(this.bits);
        out.writeShort(this.cchHeaderEven);
        out.writeShort(this.cchFooterEven);
        out.writeShort(this.cchHeaderFirst);
        out.writeShort(this.cchFooterFirst);
        if (this.cchHeaderEven > 0) {
            this.strHeaderEven.serialize(out);
        }
        if (this.cchFooterEven > 0) {
            this.strFooterEven.serialize(out);
        }
        if (this.cchHeaderFirst > 0) {
            this.strHeaderFirst.serialize(out);
        }
        if (this.cchFooterFirst > 0) {
            this.strFooterFirst.serialize(out);
        }
    }

    @Override
    public short getSid() {
        return 2204;
    }

    public byte[] getGuid() {
        return this.guidSView;
    }

    public boolean isCurrentSheet() {
        return Arrays.equals(this.getGuid(), BLANK_GUID);
    }

    @Override
    public HeaderFooterRecord copy() {
        return new HeaderFooterRecord(this);
    }

    @Override
    public HSSFRecordTypes getGenericRecordType() {
        return HSSFRecordTypes.HEADER_FOOTER;
    }

    @Override
    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties("rawData", () -> this._rawData);
    }

    public boolean isDiffOddEven() {
        return fHFDiffOddEven.isSet(this.bits);
    }

    public void setDiffOddEven(boolean flag) {
        this.bits = (short)fHFDiffOddEven.setBoolean(this.bits, flag);
        if (!flag) {
            this.setHeaderEven(null);
            this.setFooterEven(null);
        }
    }

    public boolean isDiffFirst() {
        return fHFDiffFirst.isSet(this.bits);
    }

    public void setDiffFirst(boolean flag) {
        this.bits = (short)fHFDiffFirst.setBoolean(this.bits, flag);
        if (!flag) {
            this.setHeaderFirst(null);
            this.setFooterFirst(null);
        }
    }

    public boolean isScaleWithDoc() {
        return fHFScaleWidthDoc.isSet(this.bits);
    }

    public void setScaleWithDoc(boolean flag) {
        this.bits = (short)fHFScaleWidthDoc.setBoolean(this.bits, flag);
    }

    public boolean isAlignMargins() {
        return fHFAlignMargins.isSet(this.bits);
    }

    public void setAlignMargins(boolean flag) {
        this.bits = (short)fHFAlignMargins.setBoolean(this.bits, flag);
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public String getHeaderEven() {
        return this.strHeaderEven == null ? "" : this.strHeaderEven.getString();
    }

    public void setHeaderEven(String str) {
        boolean empty = this.isEmpty(str);
        this.strHeaderEven = empty ? null : new UnicodeString(str);
        this.cchHeaderEven = empty ? (short)0 : this.strHeaderEven.getCharCountShort();
    }

    public String getFooterEven() {
        return this.strFooterEven == null ? "" : this.strFooterEven.getString();
    }

    public void setFooterEven(String str) {
        boolean empty = this.isEmpty(str);
        this.strFooterEven = empty ? null : new UnicodeString(str);
        this.cchFooterEven = empty ? (short)0 : this.strFooterEven.getCharCountShort();
    }

    public String getHeaderFirst() {
        return this.strHeaderFirst == null ? "" : this.strHeaderFirst.getString();
    }

    public void setHeaderFirst(String str) {
        boolean empty = this.isEmpty(str);
        this.strHeaderFirst = empty ? null : new UnicodeString(str);
        this.cchHeaderFirst = empty ? (short)0 : this.strHeaderFirst.getCharCountShort();
    }

    public String getFooterFirst() {
        return this.strFooterFirst == null ? "" : this.strFooterFirst.getString();
    }

    public void setFooterFirst(String str) {
        boolean empty = this.isEmpty(str);
        this.strFooterFirst = empty ? null : new UnicodeString(str);
        this.cchFooterFirst = empty ? (short)0 : this.strFooterFirst.getCharCountShort();
    }
}

