/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.usermodel.ColorFilter;
import org.apache.poi.ss.usermodel.CustomFilters;
import org.apache.poi.ss.usermodel.DynamicFilter;
import org.apache.poi.ss.usermodel.FilterColumn;
import org.apache.poi.ss.usermodel.Top10Filter;
import org.apache.poi.xssf.usermodel.XSSFColorFilter;
import org.apache.poi.xssf.usermodel.XSSFCustomFilters;
import org.apache.poi.xssf.usermodel.XSSFDxfCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDynamicFilter;
import org.apache.poi.xssf.usermodel.XSSFTop10Filter;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbookHelper;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColorFilter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCustomFilters;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDynamicFilter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFilter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFilterColumn;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFilters;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTop10;

public class XSSFFilterColumn
implements FilterColumn {
    private CTFilterColumn _ctfc;
    private Set _criteria1;
    private Set _criteria2;
    private int _operator;
    private XSSFColorFilter _colorFilter;
    private XSSFCustomFilters _customFilters;
    private XSSFDynamicFilter _dynamicFilter;
    private XSSFTop10Filter _top10Filter;

    private Set getCriteriaSet(Object criteria) {
        HashSet<String> set = new HashSet<String>();
        if (criteria instanceof String[]) {
            String[] strings = (String[])criteria;
            for (int j = 0; j < strings.length; ++j) {
                set.add(strings[j]);
            }
        }
        return set;
    }

    @Deprecated
    void init() {
        List<String> filters = this.getFilters();
        if (filters != null) {
            this._criteria1 = this.getCriteriaSet(filters.toArray(new String[filters.size()]));
            if (this.isShowBlank()) {
                this._criteria1.add("=");
            }
            this._operator = 7;
        }
    }

    void init(XSSFWorkbook book) {
        List<String> filters = this.getFilters();
        if (filters != null) {
            this._criteria1 = this.getCriteriaSet(filters.toArray(new String[filters.size()]));
            if (this.isShowBlank()) {
                this._criteria1.add("=");
            }
            this._operator = 7;
        }
        this._colorFilter = this._createColorFilter(book);
        if (this._colorFilter != null) {
            this._operator = this._colorFilter.isByFontColor() ? 9 : 8;
        }
        this._customFilters = this._createCustomFilters();
        this._dynamicFilter = this._createDynamicFilter();
        if (this._dynamicFilter != null) {
            if ("aboveAverage".equals(this._dynamicFilter.getType())) {
                this._operator = 10;
            } else if ("belowAverage".equals(this._dynamicFilter.getType())) {
                this._operator = 11;
            }
        }
        this._top10Filter = this._createTop10Filter();
        if (this._top10Filter != null) {
            this._operator = this._top10Filter.isTop() ? (this._top10Filter.isPercent() ? 6 : 5) : (this._top10Filter.isPercent() ? 3 : 2);
        }
    }

    private XSSFTop10Filter _createTop10Filter() {
        CTTop10 cttop10 = this._ctfc.getTop10();
        if (cttop10 == null) {
            return null;
        }
        return new XSSFTop10Filter(cttop10);
    }

    @Override
    public Top10Filter getTop10Filter() {
        return this._top10Filter;
    }

    private XSSFDynamicFilter _createDynamicFilter() {
        CTDynamicFilter ctdf = this._ctfc.getDynamicFilter();
        if (ctdf == null) {
            return null;
        }
        return new XSSFDynamicFilter(ctdf);
    }

    @Override
    public DynamicFilter getDynamicFilter() {
        return this._dynamicFilter;
    }

    private XSSFCustomFilters _createCustomFilters() {
        CTCustomFilters ctFilters = this._ctfc.getCustomFilters();
        if (ctFilters == null) {
            return null;
        }
        return new XSSFCustomFilters(ctFilters);
    }

    @Override
    public CustomFilters getCustomFilters() {
        return this._customFilters;
    }

    public CTFilterColumn getCTFilterColumn() {
        return this._ctfc;
    }

    private XSSFColorFilter _createColorFilter(XSSFWorkbook book) {
        CTColorFilter ctFilter = this._ctfc.getColorFilter();
        if (ctFilter == null || book == null) {
            return null;
        }
        XSSFDxfCellStyle dxfStyle = XSSFWorkbookHelper.createDxfCellStyle(book, (int)ctFilter.getDxfId());
        boolean byFontColor = ctFilter.isSetCellColor() && !ctFilter.getCellColor();
        return new XSSFColorFilter(dxfStyle, byFontColor);
    }

    @Override
    public ColorFilter getColorFilter() {
        return this._colorFilter;
    }

    public void setProperties(Object criteria1, int filterOp, Object criteria2, Boolean visibleDropDown, Map<String, Object> extra) {
        this._setProperties(criteria1, filterOp, criteria2, visibleDropDown, extra);
    }

    private void _setProperties(Object criteria1, int filterOp, Object criteria2, Boolean visibleDropDown, Map<String, Object> extra) {
        this._operator = filterOp;
        this._criteria1 = this.getCriteriaSet(criteria1);
        this._criteria2 = this.getCriteriaSet(criteria2);
        boolean blank1 = this._criteria1.contains("=");
        this._colorFilter = (XSSFColorFilter)extra.get("colorFilter");
        if (this._colorFilter != null && this._ctfc.getColorFilter() == null) {
            CTColorFilter ctFilter = this._ctfc.addNewColorFilter();
            ctFilter.setDxfId((long)this._colorFilter.getDxfCellStyle().getIndex());
            if (this._colorFilter.isByFontColor()) {
                ctFilter.setCellColor(false);
            } else if (ctFilter.isSetCellColor()) {
                ctFilter.unsetCellColor();
            }
        }
        if (visibleDropDown != null) {
            if (visibleDropDown.booleanValue()) {
                if (this._ctfc.isSetHiddenButton()) {
                    this._ctfc.unsetHiddenButton();
                }
            } else {
                this._ctfc.setHiddenButton(true);
            }
        }
        if (this._criteria1 == null || this._criteria1.isEmpty()) {
            if (this._ctfc.isSetFilters()) {
                this._ctfc.unsetFilters();
            }
            return;
        }
        switch (this._operator) {
            case 7: {
                String[] filters = (String[])criteria1;
                if (this._ctfc.isSetFilters()) {
                    this._ctfc.unsetFilters();
                }
                CTFilters cflts = this._ctfc.addNewFilters();
                if (blank1) {
                    cflts.setBlank(blank1);
                }
                for (int j = 0; j < filters.length; ++j) {
                    CTFilter cflt = cflts.addNewFilter();
                    cflt.setVal(filters[j]);
                }
                break;
            }
        }
    }

    @Override
    public int getColId() {
        return (int)this._ctfc.getColId();
    }

    @Override
    public List<String> getFilters() {
        CTFilters fts = this._ctfc.getFilters();
        if (fts != null) {
            CTFilter[] ftary = fts.getFilterArray();
            ArrayList<String> result = new ArrayList<String>(ftary.length);
            for (int j = 0; j < ftary.length; ++j) {
                result.add(ftary[j].getVal());
            }
            return result;
        }
        return null;
    }

    private boolean isShowBlank() {
        CTFilters fts = this._ctfc.getFilters();
        return fts == null || fts.isSetBlank() && fts.getBlank();
    }

    public XSSFFilterColumn(CTFilterColumn ctfc) {
        this._ctfc = ctfc;
    }

    @Override
    public Set getCriteria1() {
        return this._criteria1;
    }

    @Override
    public Set getCriteria2() {
        return this._criteria2;
    }

    @Override
    public boolean isOn() {
        return !this._ctfc.isSetHiddenButton() || !this._ctfc.getHiddenButton();
    }

    @Override
    public int getOperator() {
        return this._operator;
    }
}

