/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.DxfCellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.model.ThemesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellAlignment;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorderPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellAlignment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDxf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFont;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTNumFmt;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPatternFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STBorderStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPatternType;

public class XSSFDxfCellStyle
extends XSSFCellStyle
implements DxfCellStyle {
    private int _dxfId = Integer.MIN_VALUE;
    private StylesTable _stylesSource;
    private CTDxf _ctDxf;
    private XSSFFont _font;
    private XSSFCellAlignment _cellAlignment;
    private ThemesTable _theme;

    public XSSFDxfCellStyle(StylesTable stylesSource, ThemesTable theme) {
        super(stylesSource);
        this._stylesSource = stylesSource;
        this._ctDxf = (CTDxf)CTDxf.Factory.newInstance();
        this._theme = theme;
    }

    public XSSFDxfCellStyle(int dxfId, StylesTable stylesSource, ThemesTable theme) {
        super(stylesSource);
        this._dxfId = dxfId;
        this._stylesSource = stylesSource;
        this._ctDxf = stylesSource.getDxfAt(dxfId);
        this._theme = theme;
        if (this._ctDxf.isSetFont()) {
            this._font = new XSSFFont(this._ctDxf.getFont());
        }
        if (this._ctDxf.isSetAlignment()) {
            this._cellAlignment = new XSSFCellAlignment(this._ctDxf.getAlignment());
        }
    }

    public void setIndex(int dxfId) {
        this._dxfId = dxfId;
    }

    public CTDxf getDxf() {
        return this._ctDxf;
    }

    @Override
    public short getIndex() {
        return (short)this._dxfId;
    }

    @Override
    public void setDataFormat(short fmt) {
        if (this._ctDxf.isSetNumFmt()) {
            this._ctDxf.unsetNumFmt();
        }
        if (fmt >= 0) {
            CTNumFmt numFmt = this._ctDxf.addNewNumFmt();
            numFmt.setNumFmtId((long)fmt);
            String index = this._stylesSource.getNumberFormatAt(fmt);
            if (index == null) {
                index = BuiltinFormats.getBuiltinFormat(fmt);
            }
            numFmt.setFormatCode(index);
        }
    }

    @Override
    public short getDataFormat() {
        if (this._ctDxf.isSetNumFmt()) {
            return (short)this._ctDxf.getNumFmt().getNumFmtId();
        }
        return 0;
    }

    @Override
    public String getDataFormatString() {
        short idx = this.getDataFormat();
        return new XSSFDataFormat(this._stylesSource).getFormat(idx);
    }

    public String getRawDataFormatString() {
        String val = null;
        if (this._ctDxf.isSetNumFmt()) {
            val = this._ctDxf.getNumFmt().getFormatCode();
        }
        return val;
    }

    @Override
    public void setFont(Font font) {
        if (this._ctDxf.isSetFont()) {
            this._ctDxf.unsetFont();
        }
        if (font != null) {
            XSSFFont font0 = (XSSFFont)font;
            this._ctDxf.setFont((CTFont)font0.getCTFont().copy());
        }
    }

    public XSSFFont getOrCreateFont() {
        if (this._font == null) {
            CTFont font = this._ctDxf.addNewFont();
            this._font = new XSSFFont(font);
        }
        return this._font;
    }

    @Override
    public int getFontIndex() {
        return -1;
    }

    @Override
    public void setHidden(boolean hidden) {
        if (!this._ctDxf.isSetProtection()) {
            this._ctDxf.addNewProtection();
        }
        this._ctDxf.getProtection().setHidden(hidden);
    }

    @Override
    public boolean getHidden() {
        if (this._ctDxf.isSetProtection() && this._ctDxf.getProtection().isSetHidden()) {
            return this._ctDxf.getProtection().getHidden();
        }
        return false;
    }

    @Override
    public void setLocked(boolean locked) {
        if (!this._ctDxf.isSetProtection()) {
            this._ctDxf.addNewProtection();
        }
        this._ctDxf.getProtection().setLocked(locked);
    }

    @Override
    public boolean getLocked() {
        if (this._ctDxf.isSetProtection() && this._ctDxf.getProtection().isSetLocked()) {
            return this._ctDxf.getProtection().getLocked();
        }
        return true;
    }

    @Override
    public void setWrapText(boolean wrapped) {
        this.getCellAlignment().setWrapText(wrapped);
    }

    @Override
    public boolean getWrapText() {
        if (this._ctDxf.isSetAlignment()) {
            CTCellAlignment align = this._ctDxf.getAlignment();
            return align != null && align.getWrapText();
        }
        return false;
    }

    @Override
    public void setRotation(short rotation) {
        this.getCellAlignment().setTextRotation((long)rotation);
    }

    @Override
    public short getRotation() {
        if (this._ctDxf.isSetAlignment()) {
            CTCellAlignment align = this._ctDxf.getAlignment();
            return (short)(align == null ? 0 : align.getTextRotation().intValue());
        }
        return 0;
    }

    @Override
    public void setIndention(short indent) {
        this.getCellAlignment().setIndent((long)indent);
    }

    @Override
    public short getIndention() {
        if (this._ctDxf.isSetAlignment()) {
            CTCellAlignment align = this._ctDxf.getAlignment();
            return (short)(align == null ? 0L : align.getIndent());
        }
        return 0;
    }

    @Override
    public void setBorderLeft(BorderStyle border) {
        if (border != BorderStyle.NONE && !this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        if (this._ctDxf.isSetBorder()) {
            CTBorder ct = this._ctDxf.getBorder();
            if (border == BorderStyle.NONE) {
                if (ct.isSetLeft()) {
                    ct.unsetLeft();
                }
            } else {
                CTBorderPr pr = ct.isSetLeft() ? ct.getLeft() : ct.addNewLeft();
                pr.setStyle(STBorderStyle.Enum.forInt((int)(border.getCode() + 1)));
            }
        }
    }

    @Override
    public BorderStyle getBorderLeft() {
        STBorderStyle.Enum ptrn;
        if (!this._ctDxf.isSetBorder()) {
            return BorderStyle.NONE;
        }
        CTBorder ct = this._ctDxf.getBorder();
        STBorderStyle.Enum enum_ = ptrn = ct.isSetLeft() ? ct.getLeft().getStyle() : null;
        if (ptrn == null) {
            return BorderStyle.NONE;
        }
        return BorderStyle.valueOf((short)(ptrn.intValue() - 1));
    }

    @Override
    public void setBorderRight(BorderStyle border) {
        if (border != BorderStyle.NONE && !this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        if (this._ctDxf.isSetBorder()) {
            CTBorder ct = this._ctDxf.getBorder();
            if (border == BorderStyle.NONE) {
                if (ct.isSetRight()) {
                    ct.unsetRight();
                }
            } else {
                CTBorderPr pr = ct.isSetRight() ? ct.getRight() : ct.addNewRight();
                pr.setStyle(STBorderStyle.Enum.forInt((int)(border.getCode() + 1)));
            }
        }
    }

    @Override
    public BorderStyle getBorderRight() {
        STBorderStyle.Enum ptrn;
        if (!this._ctDxf.isSetBorder()) {
            return BorderStyle.NONE;
        }
        CTBorder ct = this._ctDxf.getBorder();
        STBorderStyle.Enum enum_ = ptrn = ct.isSetRight() ? ct.getRight().getStyle() : null;
        if (ptrn == null) {
            return BorderStyle.NONE;
        }
        return BorderStyle.valueOf((short)(ptrn.intValue() - 1));
    }

    @Override
    public void setBorderTop(BorderStyle border) {
        if (border != BorderStyle.NONE && !this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        if (this._ctDxf.isSetBorder()) {
            CTBorder ct = this._ctDxf.getBorder();
            if (border == BorderStyle.NONE) {
                if (ct.isSetTop()) {
                    ct.unsetTop();
                }
            } else {
                CTBorderPr pr = ct.isSetTop() ? ct.getTop() : ct.addNewTop();
                pr.setStyle(STBorderStyle.Enum.forInt((int)(border.getCode() + 1)));
            }
        }
    }

    @Override
    public BorderStyle getBorderTop() {
        STBorderStyle.Enum ptrn;
        if (!this._ctDxf.isSetBorder()) {
            return BorderStyle.NONE;
        }
        CTBorder ct = this._ctDxf.getBorder();
        STBorderStyle.Enum enum_ = ptrn = ct.isSetTop() ? ct.getTop().getStyle() : null;
        if (ptrn == null) {
            return BorderStyle.NONE;
        }
        return BorderStyle.valueOf((short)(ptrn.intValue() - 1));
    }

    @Override
    public void setBorderBottom(BorderStyle border) {
        if (border != BorderStyle.NONE && !this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        if (this._ctDxf.isSetBorder()) {
            CTBorder ct = this._ctDxf.getBorder();
            if (border == BorderStyle.NONE) {
                if (ct.isSetBottom()) {
                    ct.unsetBottom();
                }
            } else {
                CTBorderPr pr = ct.isSetBottom() ? ct.getBottom() : ct.addNewBottom();
                pr.setStyle(STBorderStyle.Enum.forInt((int)(border.getCode() + 1)));
            }
        }
    }

    @Override
    public BorderStyle getBorderBottom() {
        STBorderStyle.Enum ptrn;
        if (!this._ctDxf.isSetBorder()) {
            return BorderStyle.NONE;
        }
        CTBorder ct = this._ctDxf.getBorder();
        STBorderStyle.Enum enum_ = ptrn = ct.isSetBottom() ? ct.getBottom().getStyle() : null;
        if (ptrn == null) {
            return BorderStyle.NONE;
        }
        return BorderStyle.valueOf((short)(ptrn.intValue() - 1));
    }

    @Override
    public void setFillPattern(FillPatternType fp) {
        CTFill ct;
        CTPatternFill ptrn;
        if (!this._ctDxf.isSetFill()) {
            if (fp == FillPatternType.NO_FILL) {
                return;
            }
            this._ctDxf.addNewFill();
        }
        CTPatternFill cTPatternFill = ptrn = (ct = this._ctDxf.getFill()).isSetPatternFill() ? ct.getPatternFill() : ct.addNewPatternFill();
        if (fp == FillPatternType.NO_FILL && ptrn.isSetPatternType()) {
            ptrn.unsetPatternType();
        } else {
            ptrn.setPatternType(STPatternType.Enum.forInt((int)(fp.getCode() + 1)));
        }
    }

    @Override
    public FillPatternType getFillPattern() {
        CTFill fill;
        if (this._ctDxf.isSetFill() && (fill = this._ctDxf.getFill()).isSetPatternFill()) {
            CTPatternFill pf = fill.getPatternFill();
            STPatternType.Enum ptrn = pf.getPatternType();
            return ptrn == null ? FillPatternType.NO_FILL : FillPatternType.forInt(ptrn.intValue() - 1);
        }
        return FillPatternType.NO_FILL;
    }

    protected XSSFCellAlignment getCellAlignment() {
        if (this._cellAlignment == null) {
            CTCellAlignment ctAlign = this._ctDxf.addNewAlignment();
            this._cellAlignment = new XSSFCellAlignment(ctAlign);
        }
        return this._cellAlignment;
    }

    @Override
    public void setBorderHorizontal(BorderStyle border) {
        if (border != BorderStyle.NONE && !this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        if (this._ctDxf.isSetBorder()) {
            CTBorder ct = this._ctDxf.getBorder();
            if (border == BorderStyle.NONE) {
                if (ct.isSetHorizontal()) {
                    ct.unsetHorizontal();
                }
            } else {
                CTBorderPr pr = ct.isSetHorizontal() ? ct.getHorizontal() : ct.addNewHorizontal();
                pr.setStyle(STBorderStyle.Enum.forInt((int)(border.getCode() + 1)));
            }
        }
    }

    @Override
    public BorderStyle getBorderHorizontal() {
        if (this._ctDxf.isSetBorder()) {
            CTBorder ct = this._ctDxf.getBorder();
            STBorderStyle.Enum ptrn = ct.isSetHorizontal() ? ct.getHorizontal().getStyle() : null;
            return ptrn == null ? BorderStyle.NONE : BorderStyle.valueOf((short)(ptrn.intValue() - 1));
        }
        return BorderStyle.NONE;
    }

    @Override
    public Color getHorizontalBorderColorColor() {
        return this.getHorizontalBorderXSSFColor();
    }

    @Override
    public void setHorizontalBorderColor(short color) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed((int)color);
        this.setHorizontalBorderColor(clr);
    }

    @Override
    public short getHorizontalBorderColor() {
        XSSFColor clr = this.getHorizontalBorderXSSFColor();
        return clr == null ? IndexedColors.BLACK.getIndex() : clr.getIndexed();
    }

    @Override
    public void setBorderVertical(BorderStyle border) {
        if (border != BorderStyle.NONE && !this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        if (this._ctDxf.isSetBorder()) {
            CTBorder ct = this._ctDxf.getBorder();
            if (border == BorderStyle.NONE) {
                if (ct.isSetVertical()) {
                    ct.unsetVertical();
                }
            } else {
                CTBorderPr pr = ct.isSetVertical() ? ct.getVertical() : ct.addNewVertical();
                pr.setStyle(STBorderStyle.Enum.forInt((int)(border.getCode() + 1)));
            }
        }
    }

    @Override
    public BorderStyle getBorderVertical() {
        if (this._ctDxf.isSetBorder()) {
            CTBorder ct = this._ctDxf.getBorder();
            STBorderStyle.Enum ptrn = ct.isSetVertical() ? ct.getVertical().getStyle() : null;
            return ptrn == null ? BorderStyle.NONE : BorderStyle.valueOf((short)(ptrn.intValue() - 1));
        }
        return BorderStyle.NONE;
    }

    @Override
    public Color getVerticalBorderColorColor() {
        return this.getVerticalBorderXSSFColor();
    }

    @Override
    public void setVerticalBorderColor(short color) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed((int)color);
        this.setVerticalBorderColor(clr);
    }

    @Override
    public short getVerticalBorderColor() {
        XSSFColor clr = this.getVerticalBorderXSSFColor();
        return clr == null ? IndexedColors.BLACK.getIndex() : clr.getIndexed();
    }

    @Override
    public void setBorderDiagonal(BorderStyle border) {
        if (border != BorderStyle.NONE && !this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        if (this._ctDxf.isSetBorder()) {
            CTBorder ct = this._ctDxf.getBorder();
            if (border == BorderStyle.NONE) {
                if (ct.isSetDiagonal()) {
                    ct.unsetDiagonal();
                }
            } else {
                CTBorderPr pr = ct.isSetDiagonal() ? ct.getDiagonal() : ct.addNewDiagonal();
                pr.setStyle(STBorderStyle.Enum.forInt((int)(border.getCode() + 1)));
            }
        }
    }

    @Override
    public BorderStyle getBorderDiagonal() {
        if (this._ctDxf.isSetBorder()) {
            CTBorder ct = this._ctDxf.getBorder();
            STBorderStyle.Enum ptrn = ct.isSetDiagonal() ? ct.getDiagonal().getStyle() : null;
            return ptrn == null ? BorderStyle.NONE : BorderStyle.valueOf((short)(ptrn.intValue() - 1));
        }
        return BorderStyle.NONE;
    }

    @Override
    public Color getDiagonalBorderColorColor() {
        return this.getDiagonalBorderXSSFColor();
    }

    @Override
    public void setDiagonalBorderColor(short color) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed((int)color);
        this.setDiagonalBorderColor(clr);
    }

    @Override
    public short getDiagonalBorderColor() {
        XSSFColor clr = this.getDiagonalBorderXSSFColor();
        return clr == null ? IndexedColors.BLACK.getIndex() : clr.getIndexed();
    }

    @Override
    public boolean isShowDiagonalUpBorder() {
        if (this._ctDxf.isSetBorder()) {
            CTBorder border = this._ctDxf.getBorder();
            return border.getDiagonalUp();
        }
        return false;
    }

    @Override
    public boolean isShowDiagonalDownBorder() {
        if (this._ctDxf.isSetBorder()) {
            CTBorder border = this._ctDxf.getBorder();
            return border.getDiagonalDown();
        }
        return false;
    }

    @Override
    public void setShowDiagonalUpBorder(boolean up) {
        if (!this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        CTBorder border = this._ctDxf.getBorder();
        border.setDiagonalUp(up);
    }

    @Override
    public void setShowDiagonalDownBorder(boolean down) {
        if (!this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        CTBorder border = this._ctDxf.getBorder();
        border.setDiagonalDown(down);
    }

    public void setLeftBorderColor(XSSFColor color) {
        CTBorder ct;
        CTBorderPr pr;
        if (!(color != null || this._ctDxf.isSetBorder() && this._ctDxf.getBorder().isSetLeft())) {
            return;
        }
        if (!this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        CTBorderPr cTBorderPr = pr = (ct = this._ctDxf.getBorder()).isSetLeft() ? ct.getLeft() : ct.addNewLeft();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
    }

    public void setTopBorderColor(XSSFColor color) {
        CTBorder ct;
        CTBorderPr pr;
        if (!(color != null || this._ctDxf.isSetBorder() && this._ctDxf.getBorder().isSetTop())) {
            return;
        }
        if (!this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        CTBorderPr cTBorderPr = pr = (ct = this._ctDxf.getBorder()).isSetTop() ? ct.getTop() : ct.addNewTop();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
    }

    public void setRightBorderColor(XSSFColor color) {
        CTBorder ct;
        CTBorderPr pr;
        if (!(color != null || this._ctDxf.isSetBorder() && this._ctDxf.getBorder().isSetRight())) {
            return;
        }
        if (!this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        CTBorderPr cTBorderPr = pr = (ct = this._ctDxf.getBorder()).isSetRight() ? ct.getRight() : ct.addNewRight();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
    }

    public void setBottomBorderColor(XSSFColor color) {
        CTBorder ct;
        CTBorderPr pr;
        if (!(color != null || this._ctDxf.isSetBorder() && this._ctDxf.getBorder().isSetBottom())) {
            return;
        }
        if (!this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        CTBorderPr cTBorderPr = pr = (ct = this._ctDxf.getBorder()).isSetBottom() ? ct.getBottom() : ct.addNewBottom();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
    }

    public void setHorizontalBorderColor(XSSFColor color) {
        CTBorder ct;
        CTBorderPr pr;
        if (!(color != null || this._ctDxf.isSetBorder() && this._ctDxf.getBorder().isSetHorizontal())) {
            return;
        }
        if (!this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        CTBorderPr cTBorderPr = pr = (ct = this._ctDxf.getBorder()).isSetHorizontal() ? ct.getHorizontal() : ct.addNewHorizontal();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
    }

    public void setVerticalBorderColor(XSSFColor color) {
        CTBorder ct;
        CTBorderPr pr;
        if (!(color != null || this._ctDxf.isSetBorder() && this._ctDxf.getBorder().isSetVertical())) {
            return;
        }
        if (!this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        CTBorderPr cTBorderPr = pr = (ct = this._ctDxf.getBorder()).isSetVertical() ? ct.getVertical() : ct.addNewVertical();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
    }

    public void setDiagonalBorderColor(XSSFColor color) {
        CTBorder ct;
        CTBorderPr pr;
        if (!(color != null || this._ctDxf.isSetBorder() && this._ctDxf.getBorder().isSetDiagonal())) {
            return;
        }
        if (!this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        CTBorderPr cTBorderPr = pr = (ct = this._ctDxf.getBorder()).isSetDiagonal() ? ct.getDiagonal() : ct.addNewDiagonal();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
    }

    public XSSFColor getLeftBorderXSSFColor() {
        CTBorderPr pr;
        CTBorder ct;
        if (this._ctDxf.isSetBorder() && (ct = this._ctDxf.getBorder()).isSetLeft() && (pr = ct.getLeft()).isSetColor()) {
            CTColor color = pr.getColor();
            return XSSFColor.from((CTColor)color);
        }
        return null;
    }

    public XSSFColor getTopBorderXSSFColor() {
        CTBorderPr pr;
        CTBorder ct;
        if (this._ctDxf.isSetBorder() && (ct = this._ctDxf.getBorder()).isSetTop() && (pr = ct.getTop()).isSetColor()) {
            CTColor color = pr.getColor();
            return XSSFColor.from((CTColor)color);
        }
        return null;
    }

    public XSSFColor getRightBorderXSSFColor() {
        CTBorderPr pr;
        CTBorder ct;
        if (this._ctDxf.isSetBorder() && (ct = this._ctDxf.getBorder()).isSetRight() && (pr = ct.getRight()).isSetColor()) {
            CTColor color = pr.getColor();
            return XSSFColor.from((CTColor)color);
        }
        return null;
    }

    public XSSFColor getBottomBorderXSSFColor() {
        CTBorderPr pr;
        CTBorder ct;
        if (this._ctDxf.isSetBorder() && (ct = this._ctDxf.getBorder()).isSetBottom() && (pr = ct.getBottom()).isSetColor()) {
            CTColor color = pr.getColor();
            return XSSFColor.from((CTColor)color);
        }
        return null;
    }

    public XSSFColor getHorizontalBorderXSSFColor() {
        CTBorderPr pr;
        CTBorder ct;
        if (this._ctDxf.isSetBorder() && (ct = this._ctDxf.getBorder()).isSetHorizontal() && (pr = ct.getHorizontal()).isSetColor()) {
            CTColor color = pr.getColor();
            return XSSFColor.from((CTColor)color);
        }
        return null;
    }

    public XSSFColor getVerticalBorderXSSFColor() {
        CTBorderPr pr;
        CTBorder ct;
        if (this._ctDxf.isSetBorder() && (ct = this._ctDxf.getBorder()).isSetVertical() && (pr = ct.getVertical()).isSetColor()) {
            CTColor color = pr.getColor();
            return XSSFColor.from((CTColor)color);
        }
        return null;
    }

    public XSSFColor getDiagonalBorderXSSFColor() {
        CTBorderPr pr;
        CTBorder ct;
        if (this._ctDxf.isSetBorder() && (ct = this._ctDxf.getBorder()).isSetDiagonal() && (pr = ct.getDiagonal()).isSetColor()) {
            CTColor color = pr.getColor();
            return XSSFColor.from((CTColor)color);
        }
        return null;
    }

    public void setFillForegroundColor(XSSFColor color) {
        if (!this._ctDxf.isSetFill()) {
            this._ctDxf.addNewFill();
        }
        CTFill ct = this._ctDxf.getFill();
        CTPatternFill ptrn = ct.getPatternFill();
        if (color == null) {
            if (ptrn != null) {
                ptrn.unsetFgColor();
            }
        } else {
            if (ptrn == null) {
                ptrn = ct.addNewPatternFill();
            }
            ptrn.setFgColor(color.getCTColor());
        }
    }

    public void setFillBackgroundColor(XSSFColor color) {
        if (!this._ctDxf.isSetFill()) {
            this._ctDxf.addNewFill();
        }
        CTFill ct = this._ctDxf.getFill();
        CTPatternFill ptrn = ct.getPatternFill();
        if (color == null) {
            if (ptrn != null) {
                ptrn.unsetBgColor();
            }
        } else {
            if (ptrn == null) {
                ptrn = ct.addNewPatternFill();
            }
            ptrn.setBgColor(color.getCTColor());
        }
    }

    public XSSFColor getFillBackgroundXSSFColor() {
        CTPatternFill pf;
        CTFill fill;
        if (this._ctDxf.isSetFill() && (fill = this._ctDxf.getFill()).isSetPatternFill() && (pf = fill.getPatternFill()).isSetBgColor()) {
            CTColor color = pf.getBgColor();
            return XSSFColor.from((CTColor)color);
        }
        return null;
    }

    public XSSFColor getFillForegroundXSSFColor() {
        CTPatternFill pf;
        CTFill fill;
        if (this._ctDxf.isSetFill() && (fill = this._ctDxf.getFill()).isSetPatternFill() && (pf = fill.getPatternFill()).isSetFgColor()) {
            CTColor color = pf.getFgColor();
            return XSSFColor.from((CTColor)color);
        }
        return null;
    }

    @Override
    public int getFontIndexAsInt() {
        return -1;
    }

    public void setBorder(BorderStyle left, Color leftColor, BorderStyle top, Color topColor, BorderStyle right, Color rightColor, BorderStyle bottom, Color bottomColor, BorderStyle diagonal, Color diagonalColor, BorderStyle horizontal, Color horizontalColor, BorderStyle vertical, Color verticalColor, boolean diaUp, boolean diaDown) {
        if (!this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        CTBorder ct = this._ctDxf.getBorder();
        if (diagonal != BorderStyle.NONE) {
            ct.setDiagonalUp(diaUp);
            ct.setDiagonalDown(diaDown);
        }
        CTBorderPr lbpr = ct.isSetLeft() ? ct.getLeft() : (left != BorderStyle.NONE ? ct.addNewLeft() : null);
        this.setBorderStyle(lbpr, left);
        CTBorderPr tbpr = ct.isSetTop() ? ct.getTop() : (top != BorderStyle.NONE ? ct.addNewTop() : null);
        this.setBorderStyle(tbpr, top);
        CTBorderPr rbpr = ct.isSetRight() ? ct.getRight() : (right != BorderStyle.NONE ? ct.addNewRight() : null);
        this.setBorderStyle(rbpr, right);
        CTBorderPr bbpr = ct.isSetBottom() ? ct.getBottom() : (bottom != BorderStyle.NONE ? ct.addNewBottom() : null);
        this.setBorderStyle(bbpr, bottom);
        CTBorderPr dbpr = ct.isSetDiagonal() ? ct.getDiagonal() : (diagonal != BorderStyle.NONE ? ct.addNewDiagonal() : null);
        this.setBorderStyle(dbpr, diagonal);
        CTBorderPr vbpr = ct.isSetVertical() ? ct.getVertical() : (vertical != BorderStyle.NONE ? ct.addNewVertical() : null);
        this.setBorderStyle(vbpr, vertical);
        CTBorderPr hbpr = ct.isSetHorizontal() ? ct.getHorizontal() : (horizontal != BorderStyle.NONE ? ct.addNewHorizontal() : null);
        this.setBorderStyle(hbpr, horizontal);
        this.setBorderColor(lbpr, (XSSFColor)leftColor);
        this.setBorderColor(tbpr, (XSSFColor)topColor);
        this.setBorderColor(rbpr, (XSSFColor)rightColor);
        this.setBorderColor(bbpr, (XSSFColor)bottomColor);
        this.setBorderColor(hbpr, (XSSFColor)horizontalColor);
        this.setBorderColor(vbpr, (XSSFColor)verticalColor);
        this.setBorderColor(dbpr, (XSSFColor)diagonalColor);
    }

    private void setBorderStyle(CTBorderPr bpr, BorderStyle ordinal) {
        if (bpr != null) {
            if (ordinal != BorderStyle.NONE) {
                bpr.setStyle(STBorderStyle.Enum.forInt((int)(ordinal.getCode() + 1)));
            } else if (bpr.isSetStyle()) {
                bpr.unsetStyle();
            }
        }
    }

    private void setBorderColor(CTBorderPr bpr, XSSFColor color) {
        if (bpr != null) {
            if (color == null) {
                if (bpr.isSetColor()) {
                    bpr.unsetColor();
                }
            } else {
                bpr.setColor(color.getCTColor());
            }
        }
    }

    public void setFill(Color fillColor, Color backColor, short patternType) {
        if (!this._ctDxf.isSetFill()) {
            this._ctDxf.addNewFill();
        }
        CTFill ct = this._ctDxf.getFill();
        XSSFCellFill fill = new XSSFCellFill(ct, null);
        XSSFColor fc = (XSSFColor)fillColor;
        XSSFColor bc = (XSSFColor)backColor;
        if (fc != null) {
            fill.setFillForegroundColor(fc);
        }
        if (bc != null) {
            fill.setFillBackgroundColor(bc);
        }
        if (patternType >= 0) {
            fill.setPatternType(STPatternType.Enum.forInt((int)(patternType + 1)));
        }
    }

    public int getDxfIndex() {
        if (this._dxfId != Integer.MIN_VALUE) {
            return this._dxfId;
        }
        return -1;
    }
}

