/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.apache.poi.common.Duplicatable;
import org.apache.poi.logging.PoiLogManager;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellCopyContext;
import org.apache.poi.ss.usermodel.CellCopyPolicy;
import org.apache.poi.ss.usermodel.CellPropertyType;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.Removal;

public final class CellUtil {
    private static final Logger LOGGER = PoiLogManager.getLogger(CellUtil.class);
    private static final Set<CellPropertyType> SHORT_VALUES = EnumSet.of(CellPropertyType.BOTTOM_BORDER_COLOR, new CellPropertyType[]{CellPropertyType.LEFT_BORDER_COLOR, CellPropertyType.RIGHT_BORDER_COLOR, CellPropertyType.TOP_BORDER_COLOR, CellPropertyType.FILL_FOREGROUND_COLOR, CellPropertyType.FILL_BACKGROUND_COLOR, CellPropertyType.INDENTION, CellPropertyType.DATA_FORMAT, CellPropertyType.ROTATION});
    private static final Set<CellPropertyType> COLOR_VALUES = EnumSet.of(CellPropertyType.FILL_FOREGROUND_COLOR_COLOR, CellPropertyType.FILL_BACKGROUND_COLOR_COLOR);
    private static final Set<CellPropertyType> INT_VALUES = EnumSet.of(CellPropertyType.FONT);
    private static final Set<CellPropertyType> BOOLEAN_VALUES = EnumSet.of(CellPropertyType.LOCKED, CellPropertyType.HIDDEN, CellPropertyType.WRAP_TEXT, CellPropertyType.SHRINK_TO_FIT, CellPropertyType.QUOTE_PREFIXED);
    private static final Set<CellPropertyType> BORDER_TYPE_VALUES = EnumSet.of(CellPropertyType.BORDER_BOTTOM, CellPropertyType.BORDER_LEFT, CellPropertyType.BORDER_RIGHT, CellPropertyType.BORDER_TOP);
    @Deprecated
    @Removal(version="7.0.0")
    public static final String ALIGNMENT = "alignment";
    @Deprecated
    @Removal(version="7.0.0")
    public static final String BORDER_BOTTOM = "borderBottom";
    @Deprecated
    @Removal(version="7.0.0")
    public static final String BORDER_LEFT = "borderLeft";
    @Deprecated
    @Removal(version="7.0.0")
    public static final String BORDER_RIGHT = "borderRight";
    @Deprecated
    @Removal(version="7.0.0")
    public static final String BORDER_TOP = "borderTop";
    @Deprecated
    @Removal(version="7.0.0")
    public static final String BOTTOM_BORDER_COLOR = "bottomBorderColor";
    @Deprecated
    @Removal(version="7.0.0")
    public static final String LEFT_BORDER_COLOR = "leftBorderColor";
    @Deprecated
    @Removal(version="7.0.0")
    public static final String RIGHT_BORDER_COLOR = "rightBorderColor";
    @Deprecated
    @Removal(version="7.0.0")
    public static final String TOP_BORDER_COLOR = "topBorderColor";
    @Deprecated
    @Removal(version="7.0.0")
    public static final String DATA_FORMAT = "dataFormat";
    @Deprecated
    @Removal(version="7.0.0")
    public static final String FILL_BACKGROUND_COLOR = "fillBackgroundColor";
    @Deprecated
    @Removal(version="7.0.0")
    public static final String FILL_FOREGROUND_COLOR = "fillForegroundColor";
    @Deprecated
    @Removal(version="7.0.0")
    public static final String FILL_BACKGROUND_COLOR_COLOR = "fillBackgroundColorColor";
    @Deprecated
    @Removal(version="7.0.0")
    public static final String FILL_FOREGROUND_COLOR_COLOR = "fillForegroundColorColor";
    @Deprecated
    @Removal(version="7.0.0")
    public static final String FILL_PATTERN = "fillPattern";
    @Deprecated
    @Removal(version="7.0.0")
    public static final String FONT = "font";
    @Deprecated
    @Removal(version="7.0.0")
    public static final String HIDDEN = "hidden";
    @Deprecated
    @Removal(version="7.0.0")
    public static final String INDENTION = "indention";
    @Deprecated
    @Removal(version="7.0.0")
    public static final String LOCKED = "locked";
    @Deprecated
    @Removal(version="7.0.0")
    public static final String ROTATION = "rotation";
    @Deprecated
    @Removal(version="7.0.0")
    public static final String VERTICAL_ALIGNMENT = "verticalAlignment";
    @Deprecated
    @Removal(version="7.0.0")
    public static final String WRAP_TEXT = "wrapText";
    @Deprecated
    @Removal(version="7.0.0")
    public static final String SHRINK_TO_FIT = "shrinkToFit";
    @Deprecated
    @Removal(version="7.0.0")
    public static final String QUOTE_PREFIXED = "quotePrefixed";
    static final Map<String, CellPropertyType> namePropertyMap;
    private static final UnicodeMapping[] unicodeMappings;

    private CellUtil() {
    }

    public static Row getRow(int rowIndex, Sheet sheet) {
        Row row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
        }
        return row;
    }

    public static Cell getCell(Row row, int columnIndex) {
        Cell cell = row.getCell(columnIndex);
        if (cell == null) {
            cell = row.createCell(columnIndex);
        }
        return cell;
    }

    public static Cell createCell(Row row, int column, String value, CellStyle style) {
        Cell cell = CellUtil.getCell(row, column);
        cell.setCellValue(cell.getRow().getSheet().getWorkbook().getCreationHelper().createRichTextString(value));
        if (style != null) {
            cell.setCellStyle(style);
        }
        return cell;
    }

    public static Cell createCell(Row row, int column, String value) {
        return CellUtil.createCell(row, column, value, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyCell(Cell srcCell, Cell destCell, CellCopyPolicy policy, CellCopyContext context) {
        Hyperlink newHyperlink;
        Hyperlink srcHyperlink;
        if (policy.isCopyCellValue()) {
            if (srcCell != null) {
                CellType copyCellType = srcCell.getCellType();
                if (copyCellType == CellType.FORMULA && !policy.isCopyCellFormula()) {
                    copyCellType = srcCell.getCachedFormulaResultType();
                }
                switch (copyCellType) {
                    case NUMERIC: {
                        if (!policy.isCopyCellStyle() && DateUtil.isCellDateFormatted(srcCell)) {
                            destCell.setCellValue(srcCell.getDateCellValue());
                            break;
                        }
                        destCell.setCellValue(srcCell.getNumericCellValue());
                        break;
                    }
                    case STRING: {
                        destCell.setCellValue(srcCell.getRichStringCellValue());
                        break;
                    }
                    case FORMULA: {
                        destCell.setCellFormula(srcCell.getCellFormula());
                        break;
                    }
                    case BLANK: {
                        destCell.setBlank();
                        break;
                    }
                    case BOOLEAN: {
                        destCell.setCellValue(srcCell.getBooleanCellValue());
                        break;
                    }
                    case ERROR: {
                        destCell.setCellErrorValue(srcCell.getErrorCellValue());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid cell type " + String.valueOf((Object)srcCell.getCellType()));
                    }
                }
            } else {
                destCell.setBlank();
            }
        }
        if (policy.isCopyCellStyle() && srcCell != null) {
            if (srcCell.getSheet() != null && destCell.getSheet() != null && destCell.getSheet().getWorkbook() == srcCell.getSheet().getWorkbook()) {
                destCell.setCellStyle(srcCell.getCellStyle());
            } else {
                CellStyle destStyle;
                CellStyle srcStyle = srcCell.getCellStyle();
                CellStyle cellStyle = destStyle = context == null ? null : context.getMappedStyle(srcStyle);
                if (destStyle == null) {
                    destStyle = destCell.getSheet().getWorkbook().createCellStyle();
                    destStyle.cloneStyleFrom(srcStyle);
                    if (context != null) {
                        context.putMappedStyle(srcStyle, destStyle);
                    }
                }
                destCell.setCellStyle(destStyle);
            }
        }
        Hyperlink hyperlink = srcHyperlink = srcCell == null ? null : srcCell.getHyperlink();
        if (policy.isMergeHyperlink()) {
            if (srcHyperlink == null) return;
            if (!(srcHyperlink instanceof Duplicatable)) throw new IllegalStateException("srcCell hyperlink is not an instance of Duplicatable");
            newHyperlink = (Hyperlink)((Object)((Duplicatable)((Object)srcHyperlink)).copy());
            destCell.setHyperlink(newHyperlink);
            return;
        } else {
            if (!policy.isCopyHyperlink()) return;
            if (srcHyperlink == null) {
                destCell.setHyperlink(null);
                return;
            } else {
                if (!(srcHyperlink instanceof Duplicatable)) throw new IllegalStateException("srcCell hyperlink is not an instance of Duplicatable");
                newHyperlink = (Hyperlink)((Object)((Duplicatable)((Object)srcHyperlink)).copy());
                destCell.setHyperlink(newHyperlink);
            }
        }
    }

    public static void setAlignment(Cell cell, HorizontalAlignment align) {
        CellUtil.setCellStyleProperty(cell, CellPropertyType.ALIGNMENT, (Object)align);
    }

    public static void setVerticalAlignment(Cell cell, VerticalAlignment align) {
        CellUtil.setCellStyleProperty(cell, CellPropertyType.VERTICAL_ALIGNMENT, (Object)align);
    }

    public static void setFont(Cell cell, Font font) {
        int fontIndex;
        Workbook wb = cell.getSheet().getWorkbook();
        if (!wb.getFontAt(fontIndex = font.getIndex()).equals(font)) {
            throw new IllegalArgumentException("Font does not belong to this workbook");
        }
        CellUtil.setCellStyleProperty(cell, CellPropertyType.FONT, (Object)fontIndex);
    }

    @Deprecated
    @Removal(version="7.0.0")
    public static void setCellStyleProperties(Cell cell, Map<String, Object> properties) {
        HashMap<CellPropertyType, Object> strPropMap = new HashMap<CellPropertyType, Object>(properties.size());
        properties.forEach((k, v) -> strPropMap.put(namePropertyMap.get(k), v));
        CellUtil.setCellStyleProperties(cell, strPropMap, false);
    }

    public static void setCellStylePropertiesEnum(Cell cell, Map<CellPropertyType, Object> properties) {
        CellUtil.setCellStyleProperties(cell, properties, false);
    }

    private static void setCellStyleProperties(Cell cell, Map<CellPropertyType, Object> properties, boolean disableNullColorCheck) {
        Workbook workbook = cell.getSheet().getWorkbook();
        CellStyle originalStyle = cell.getCellStyle();
        CellStyle newStyle = null;
        Map<CellPropertyType, Object> values = CellUtil.getFormatProperties(originalStyle);
        if (properties.containsKey((Object)CellPropertyType.FILL_FOREGROUND_COLOR_COLOR) && properties.get((Object)CellPropertyType.FILL_FOREGROUND_COLOR_COLOR) == null) {
            values.remove((Object)CellPropertyType.FILL_FOREGROUND_COLOR);
        }
        if (properties.containsKey((Object)CellPropertyType.FILL_FOREGROUND_COLOR) && !properties.containsKey((Object)CellPropertyType.FILL_FOREGROUND_COLOR_COLOR)) {
            values.remove((Object)CellPropertyType.FILL_FOREGROUND_COLOR_COLOR);
        }
        if (properties.containsKey((Object)CellPropertyType.FILL_BACKGROUND_COLOR_COLOR) && properties.get((Object)CellPropertyType.FILL_BACKGROUND_COLOR_COLOR) == null) {
            values.remove((Object)CellPropertyType.FILL_BACKGROUND_COLOR);
        }
        if (properties.containsKey((Object)CellPropertyType.FILL_BACKGROUND_COLOR) && !properties.containsKey((Object)CellPropertyType.FILL_BACKGROUND_COLOR_COLOR)) {
            values.remove((Object)CellPropertyType.FILL_BACKGROUND_COLOR_COLOR);
        }
        CellUtil.putAll(properties, values);
        int numberCellStyles = workbook.getNumCellStyles();
        for (int i = 0; i < numberCellStyles; ++i) {
            CellStyle wbStyle = workbook.getCellStyleAt(i);
            Map<CellPropertyType, Object> wbStyleMap = CellUtil.getFormatProperties(wbStyle);
            if (!CellUtil.styleMapsMatch(wbStyleMap, values, disableNullColorCheck)) continue;
            newStyle = wbStyle;
            break;
        }
        if (newStyle == null) {
            newStyle = workbook.createCellStyle();
            CellUtil.setFormatProperties(newStyle, workbook, values);
        }
        cell.setCellStyle(newStyle);
    }

    private static boolean styleMapsMatch(Map<CellPropertyType, Object> newProps, Map<CellPropertyType, Object> storedProps, boolean disableNullColorCheck) {
        HashMap<CellPropertyType, Object> map1Copy = new HashMap<CellPropertyType, Object>(newProps);
        HashMap<CellPropertyType, Object> map2Copy = new HashMap<CellPropertyType, Object>(storedProps);
        Object backColor1 = map1Copy.remove((Object)CellPropertyType.FILL_BACKGROUND_COLOR_COLOR);
        Object backColor2 = map2Copy.remove((Object)CellPropertyType.FILL_BACKGROUND_COLOR_COLOR);
        Object foreColor1 = map1Copy.remove((Object)CellPropertyType.FILL_FOREGROUND_COLOR_COLOR);
        Object foreColor2 = map2Copy.remove((Object)CellPropertyType.FILL_FOREGROUND_COLOR_COLOR);
        if (map1Copy.equals(map2Copy)) {
            boolean backColorsMatch = !disableNullColorCheck && backColor2 == null || Objects.equals(backColor1, backColor2);
            boolean foreColorsMatch = !disableNullColorCheck && foreColor2 == null || Objects.equals(foreColor1, foreColor2);
            return backColorsMatch && foreColorsMatch;
        }
        return false;
    }

    public static void setCellStyleProperty(Cell cell, CellPropertyType property, Object propertyValue) {
        Map<Object, Object> propMap;
        boolean disableNullColorCheck = false;
        if (CellPropertyType.FILL_FOREGROUND_COLOR_COLOR.equals((Object)property) && propertyValue == null) {
            disableNullColorCheck = true;
            propMap = new HashMap();
            propMap.put((Object)CellPropertyType.FILL_FOREGROUND_COLOR_COLOR, null);
            propMap.put((Object)CellPropertyType.FILL_FOREGROUND_COLOR, null);
        } else if (CellPropertyType.FILL_BACKGROUND_COLOR_COLOR.equals((Object)property) && propertyValue == null) {
            disableNullColorCheck = true;
            propMap = new HashMap();
            propMap.put((Object)CellPropertyType.FILL_BACKGROUND_COLOR_COLOR, null);
            propMap.put((Object)CellPropertyType.FILL_BACKGROUND_COLOR, null);
        } else {
            propMap = Collections.singletonMap(property, propertyValue);
        }
        CellUtil.setCellStyleProperties(cell, propMap, disableNullColorCheck);
    }

    @Deprecated
    @Removal(version="7.0.0")
    public static void setCellStyleProperty(Cell cell, String propertyName, Object propertyValue) {
        CellUtil.setCellStyleProperty(cell, namePropertyMap.get(propertyName), propertyValue);
    }

    private static Map<CellPropertyType, Object> getFormatProperties(CellStyle style) {
        HashMap<CellPropertyType, Object> properties = new HashMap<CellPropertyType, Object>();
        CellUtil.put(properties, CellPropertyType.ALIGNMENT, (Object)style.getAlignment());
        CellUtil.put(properties, CellPropertyType.VERTICAL_ALIGNMENT, (Object)style.getVerticalAlignment());
        CellUtil.put(properties, CellPropertyType.BORDER_BOTTOM, (Object)style.getBorderBottom());
        CellUtil.put(properties, CellPropertyType.BORDER_LEFT, (Object)style.getBorderLeft());
        CellUtil.put(properties, CellPropertyType.BORDER_RIGHT, (Object)style.getBorderRight());
        CellUtil.put(properties, CellPropertyType.BORDER_TOP, (Object)style.getBorderTop());
        CellUtil.put(properties, CellPropertyType.BOTTOM_BORDER_COLOR, style.getBottomBorderColor());
        CellUtil.put(properties, CellPropertyType.DATA_FORMAT, style.getDataFormat());
        CellUtil.put(properties, CellPropertyType.FILL_PATTERN, (Object)style.getFillPattern());
        CellUtil.put(properties, CellPropertyType.FILL_FOREGROUND_COLOR, style.getFillForegroundColor());
        CellUtil.put(properties, CellPropertyType.FILL_BACKGROUND_COLOR, style.getFillBackgroundColor());
        CellUtil.put(properties, CellPropertyType.FILL_FOREGROUND_COLOR_COLOR, style.getFillForegroundColorColor());
        CellUtil.put(properties, CellPropertyType.FILL_BACKGROUND_COLOR_COLOR, style.getFillBackgroundColorColor());
        CellUtil.put(properties, CellPropertyType.FONT, style.getFontIndex());
        CellUtil.put(properties, CellPropertyType.HIDDEN, style.getHidden());
        CellUtil.put(properties, CellPropertyType.INDENTION, style.getIndention());
        CellUtil.put(properties, CellPropertyType.LEFT_BORDER_COLOR, style.getLeftBorderColor());
        CellUtil.put(properties, CellPropertyType.LOCKED, style.getLocked());
        CellUtil.put(properties, CellPropertyType.RIGHT_BORDER_COLOR, style.getRightBorderColor());
        CellUtil.put(properties, CellPropertyType.ROTATION, style.getRotation());
        CellUtil.put(properties, CellPropertyType.TOP_BORDER_COLOR, style.getTopBorderColor());
        CellUtil.put(properties, CellPropertyType.WRAP_TEXT, style.getWrapText());
        CellUtil.put(properties, CellPropertyType.SHRINK_TO_FIT, style.getShrinkToFit());
        CellUtil.put(properties, CellPropertyType.QUOTE_PREFIXED, style.getQuotePrefixed());
        return properties;
    }

    private static void putAll(Map<CellPropertyType, Object> src, Map<CellPropertyType, Object> dest) {
        for (CellPropertyType key : src.keySet()) {
            if (SHORT_VALUES.contains((Object)key)) {
                dest.put(key, CellUtil.nullableShort(src, key));
                continue;
            }
            if (COLOR_VALUES.contains((Object)key)) {
                dest.put(key, CellUtil.getColor(src, key));
                continue;
            }
            if (INT_VALUES.contains((Object)key)) {
                dest.put(key, CellUtil.getInt(src, key));
                continue;
            }
            if (BOOLEAN_VALUES.contains((Object)key)) {
                dest.put(key, CellUtil.getBoolean(src, key));
                continue;
            }
            if (BORDER_TYPE_VALUES.contains((Object)key)) {
                dest.put(key, (Object)CellUtil.getBorderStyle(src, key));
                continue;
            }
            if (CellPropertyType.ALIGNMENT.equals((Object)key)) {
                dest.put(key, (Object)CellUtil.getHorizontalAlignment(src, key));
                continue;
            }
            if (CellPropertyType.VERTICAL_ALIGNMENT.equals((Object)key)) {
                dest.put(key, (Object)CellUtil.getVerticalAlignment(src, key));
                continue;
            }
            if (CellPropertyType.FILL_PATTERN.equals((Object)key)) {
                dest.put(key, (Object)CellUtil.getFillPattern(src, key));
                continue;
            }
            LOGGER.atInfo().log("Ignoring unrecognized CellUtil format properties key: {}", (Object)key);
        }
    }

    private static void setFormatProperties(CellStyle style, Workbook workbook, Map<CellPropertyType, Object> properties) {
        Short fillBackColorShort;
        style.setAlignment(CellUtil.getHorizontalAlignment(properties, CellPropertyType.ALIGNMENT));
        style.setVerticalAlignment(CellUtil.getVerticalAlignment(properties, CellPropertyType.VERTICAL_ALIGNMENT));
        style.setBorderBottom(CellUtil.getBorderStyle(properties, CellPropertyType.BORDER_BOTTOM));
        style.setBorderLeft(CellUtil.getBorderStyle(properties, CellPropertyType.BORDER_LEFT));
        style.setBorderRight(CellUtil.getBorderStyle(properties, CellPropertyType.BORDER_RIGHT));
        style.setBorderTop(CellUtil.getBorderStyle(properties, CellPropertyType.BORDER_TOP));
        style.setBottomBorderColor(CellUtil.getShort(properties, CellPropertyType.BOTTOM_BORDER_COLOR));
        style.setDataFormat(CellUtil.getShort(properties, CellPropertyType.DATA_FORMAT));
        style.setFillPattern(CellUtil.getFillPattern(properties, CellPropertyType.FILL_PATTERN));
        Short fillForeColorShort = CellUtil.nullableShort(properties, CellPropertyType.FILL_FOREGROUND_COLOR);
        if (fillForeColorShort != null) {
            style.setFillForegroundColor(fillForeColorShort);
        }
        if ((fillBackColorShort = CellUtil.nullableShort(properties, CellPropertyType.FILL_BACKGROUND_COLOR)) != null) {
            style.setFillBackgroundColor(fillBackColorShort);
        }
        Color foregroundFillColor = CellUtil.getColor(properties, CellPropertyType.FILL_FOREGROUND_COLOR_COLOR);
        Color backgroundFillColor = CellUtil.getColor(properties, CellPropertyType.FILL_BACKGROUND_COLOR_COLOR);
        if (foregroundFillColor != null) {
            try {
                style.setFillForegroundColor(foregroundFillColor);
            }
            catch (IllegalArgumentException iae) {
                LOGGER.atDebug().log("Mismatched FillForegroundColor instance used", (Object)iae);
            }
        }
        if (backgroundFillColor != null) {
            try {
                style.setFillBackgroundColor(backgroundFillColor);
            }
            catch (IllegalArgumentException iae) {
                LOGGER.atDebug().log("Mismatched FillBackgroundColor instance used", (Object)iae);
            }
        }
        style.setFont(workbook.getFontAt(CellUtil.getInt(properties, CellPropertyType.FONT)));
        style.setHidden(CellUtil.getBoolean(properties, CellPropertyType.HIDDEN));
        style.setIndention(CellUtil.getShort(properties, CellPropertyType.INDENTION));
        style.setLeftBorderColor(CellUtil.getShort(properties, CellPropertyType.LEFT_BORDER_COLOR));
        style.setLocked(CellUtil.getBoolean(properties, CellPropertyType.LOCKED));
        style.setRightBorderColor(CellUtil.getShort(properties, CellPropertyType.RIGHT_BORDER_COLOR));
        style.setRotation(CellUtil.getShort(properties, CellPropertyType.ROTATION));
        style.setTopBorderColor(CellUtil.getShort(properties, CellPropertyType.TOP_BORDER_COLOR));
        style.setWrapText(CellUtil.getBoolean(properties, CellPropertyType.WRAP_TEXT));
        style.setShrinkToFit(CellUtil.getBoolean(properties, CellPropertyType.SHRINK_TO_FIT));
        style.setQuotePrefixed(CellUtil.getBoolean(properties, CellPropertyType.QUOTE_PREFIXED));
    }

    private static short getShort(Map<CellPropertyType, Object> properties, CellPropertyType property) {
        Object value = properties.get((Object)property);
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        return 0;
    }

    private static Short nullableShort(Map<CellPropertyType, Object> properties, CellPropertyType property) {
        Object value = properties.get((Object)property);
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        return null;
    }

    private static Color getColor(Map<CellPropertyType, Object> properties, CellPropertyType property) {
        Object value = properties.get((Object)property);
        if (value instanceof Color) {
            return (Color)value;
        }
        return null;
    }

    private static int getInt(Map<CellPropertyType, Object> properties, CellPropertyType property) {
        Object value = properties.get((Object)property);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return 0;
    }

    private static BorderStyle getBorderStyle(Map<CellPropertyType, Object> properties, CellPropertyType property) {
        BorderStyle border;
        Object value = properties.get((Object)property);
        if (value instanceof BorderStyle) {
            border = (BorderStyle)((Object)value);
        } else if (value instanceof Short) {
            LOGGER.atWarn().log("Deprecation warning: CellUtil properties map uses Short values for {}. Should use BorderStyle enums instead.", (Object)property);
            short code = (Short)value;
            border = BorderStyle.valueOf(code);
        } else if (value == null) {
            border = BorderStyle.NONE;
        } else {
            throw new IllegalStateException("Unexpected border style class. Must be BorderStyle or Short (deprecated).");
        }
        return border;
    }

    private static FillPatternType getFillPattern(Map<CellPropertyType, Object> properties, CellPropertyType property) {
        FillPatternType pattern;
        Object value = properties.get((Object)property);
        if (value instanceof FillPatternType) {
            pattern = (FillPatternType)((Object)value);
        } else if (value instanceof Short) {
            LOGGER.atWarn().log("Deprecation warning: CellUtil properties map uses Short values for {}. Should use FillPatternType enums instead.", (Object)property);
            short code = (Short)value;
            pattern = FillPatternType.forInt(code);
        } else if (value == null) {
            pattern = FillPatternType.NO_FILL;
        } else {
            throw new IllegalStateException("Unexpected fill pattern style class. Must be FillPatternType or Short (deprecated).");
        }
        return pattern;
    }

    private static HorizontalAlignment getHorizontalAlignment(Map<CellPropertyType, Object> properties, CellPropertyType property) {
        HorizontalAlignment align;
        Object value = properties.get((Object)property);
        if (value instanceof HorizontalAlignment) {
            align = (HorizontalAlignment)((Object)value);
        } else if (value instanceof Short) {
            LOGGER.atWarn().log("Deprecation warning: CellUtil properties map used a Short value for {}. Should use HorizontalAlignment enums instead.", (Object)property);
            short code = (Short)value;
            align = HorizontalAlignment.forInt(code);
        } else if (value == null) {
            align = HorizontalAlignment.GENERAL;
        } else {
            throw new IllegalStateException("Unexpected horizontal alignment style class. Must be HorizontalAlignment or Short (deprecated).");
        }
        return align;
    }

    private static VerticalAlignment getVerticalAlignment(Map<CellPropertyType, Object> properties, CellPropertyType property) {
        VerticalAlignment align;
        Object value = properties.get((Object)property);
        if (value instanceof VerticalAlignment) {
            align = (VerticalAlignment)((Object)value);
        } else if (value instanceof Short) {
            LOGGER.atWarn().log("Deprecation warning: CellUtil properties map used a Short value for {}. Should use VerticalAlignment enums instead.", (Object)property);
            short code = (Short)value;
            align = VerticalAlignment.forInt(code);
        } else if (value == null) {
            align = VerticalAlignment.BOTTOM;
        } else {
            throw new IllegalStateException("Unexpected vertical alignment style class. Must be VerticalAlignment or Short (deprecated).");
        }
        return align;
    }

    private static boolean getBoolean(Map<CellPropertyType, Object> properties, CellPropertyType property) {
        Object value = properties.get((Object)property);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    private static void put(Map<CellPropertyType, Object> properties, CellPropertyType property, Object value) {
        properties.put(property, value);
    }

    public static Cell translateUnicodeValues(Cell cell) {
        String s = cell.getRichStringCellValue().getString();
        boolean foundUnicode = false;
        String lowerCaseStr = s.toLowerCase(Locale.ROOT);
        for (UnicodeMapping entry : unicodeMappings) {
            String key = entry.entityName;
            if (!lowerCaseStr.contains(key)) continue;
            s = s.replaceAll(key, entry.resolvedValue);
            foundUnicode = true;
        }
        if (foundUnicode) {
            cell.setCellValue(cell.getRow().getSheet().getWorkbook().getCreationHelper().createRichTextString(s));
        }
        return cell;
    }

    private static UnicodeMapping um(String entityName, String resolvedValue) {
        return new UnicodeMapping(entityName, resolvedValue);
    }

    static {
        HashMap<String, CellPropertyType> map = new HashMap<String, CellPropertyType>();
        map.put(ALIGNMENT, CellPropertyType.ALIGNMENT);
        map.put(BORDER_BOTTOM, CellPropertyType.BORDER_BOTTOM);
        map.put(BORDER_LEFT, CellPropertyType.BORDER_LEFT);
        map.put(BORDER_RIGHT, CellPropertyType.BORDER_RIGHT);
        map.put(BORDER_TOP, CellPropertyType.BORDER_TOP);
        map.put(BOTTOM_BORDER_COLOR, CellPropertyType.BOTTOM_BORDER_COLOR);
        map.put(LEFT_BORDER_COLOR, CellPropertyType.LEFT_BORDER_COLOR);
        map.put(RIGHT_BORDER_COLOR, CellPropertyType.RIGHT_BORDER_COLOR);
        map.put(TOP_BORDER_COLOR, CellPropertyType.TOP_BORDER_COLOR);
        map.put(FILL_BACKGROUND_COLOR, CellPropertyType.FILL_BACKGROUND_COLOR);
        map.put(FILL_FOREGROUND_COLOR, CellPropertyType.FILL_FOREGROUND_COLOR);
        map.put(FILL_BACKGROUND_COLOR_COLOR, CellPropertyType.FILL_BACKGROUND_COLOR_COLOR);
        map.put(FILL_FOREGROUND_COLOR_COLOR, CellPropertyType.FILL_FOREGROUND_COLOR_COLOR);
        map.put(FILL_PATTERN, CellPropertyType.FILL_PATTERN);
        map.put(FONT, CellPropertyType.FONT);
        map.put(HIDDEN, CellPropertyType.HIDDEN);
        map.put(INDENTION, CellPropertyType.INDENTION);
        map.put(LOCKED, CellPropertyType.LOCKED);
        map.put(ROTATION, CellPropertyType.ROTATION);
        map.put(VERTICAL_ALIGNMENT, CellPropertyType.VERTICAL_ALIGNMENT);
        map.put(SHRINK_TO_FIT, CellPropertyType.SHRINK_TO_FIT);
        map.put(QUOTE_PREFIXED, CellPropertyType.QUOTE_PREFIXED);
        namePropertyMap = Collections.unmodifiableMap(map);
        unicodeMappings = new UnicodeMapping[]{CellUtil.um("alpha", "\u03b1"), CellUtil.um("beta", "\u03b2"), CellUtil.um("gamma", "\u03b3"), CellUtil.um("delta", "\u03b4"), CellUtil.um("epsilon", "\u03b5"), CellUtil.um("zeta", "\u03b6"), CellUtil.um("eta", "\u03b7"), CellUtil.um("theta", "\u03b8"), CellUtil.um("iota", "\u03b9"), CellUtil.um("kappa", "\u03ba"), CellUtil.um("lambda", "\u03bb"), CellUtil.um("mu", "\u03bc"), CellUtil.um("nu", "\u03bd"), CellUtil.um("xi", "\u03be"), CellUtil.um("omicron", "\u03bf")};
    }

    private static final class UnicodeMapping {
        public final String entityName;
        public final String resolvedValue;

        public UnicodeMapping(String pEntityName, String pResolvedValue) {
            this.entityName = "&" + pEntityName + ";";
            this.resolvedValue = pResolvedValue;
        }
    }
}

