/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.token;

import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.formula.FormulaTokenParser;
import org.apache.poi.ss.formula.token.AreaRefNode;
import org.apache.poi.ss.formula.token.BracketNode;
import org.apache.poi.ss.formula.token.ColonNode;
import org.apache.poi.ss.formula.token.ErrorNode;
import org.apache.poi.ss.formula.token.ErrorRefNode;
import org.apache.poi.ss.formula.token.ExternalRefNode;
import org.apache.poi.ss.formula.token.FormulaTokenNode;
import org.apache.poi.ss.formula.token.NameNode;
import org.apache.poi.ss.formula.token.NameRefNode;
import org.apache.poi.ss.formula.token.NodeId;
import org.apache.poi.ss.formula.token.OpNode;
import org.apache.poi.ss.formula.token.RefNode;
import org.apache.poi.ss.formula.token.TokenNodeVisitor;

public class ExclamationNode
extends OpNode {
    @Override
    public int getFlag() {
        return 0;
    }

    @Override
    public String getOp() {
        return "!";
    }

    @Override
    public NodeId getNodeId() {
        return NodeId.ExclamationNode;
    }

    private FormulaParseException _toError() {
        StringBuilder sb = new StringBuilder();
        sb.append("Expect a cell reference after a sheet name: ");
        if (this.left != null) {
            sb.append(this.left);
        }
        return new FormulaParseException(sb.toString());
    }

    @Override
    public FormulaTokenNode normalize(FormulaTokenParser parser) {
        ExternalRefNode externalRef = OpNode.toExternalRef(this.left);
        if (externalRef == null) {
            if (this.left == null || this.left.getNodeId() != NodeId.ColonNode) {
                throw this._toError();
            }
            OpNode opNode = (OpNode)this.left;
            this.left = opNode.right;
            return new ColonNode(opNode.left, this.normalize(parser));
        }
        switch (this.right.getNodeId()) {
            case BracketNode: {
                return ((BracketNode)this.right).normalize(parser, externalRef);
            }
            case NameNode: {
                return ((NameNode)this.right).normalize(parser, externalRef);
            }
            case ErrorNode: {
                return new ErrorRefNode((ErrorNode)this.right, externalRef);
            }
        }
        FormulaTokenNode rightNode = this.right.normalize(parser);
        switch (rightNode.getNodeId()) {
            case NameRefNode: {
                NameRefNode nameRefNode = (NameRefNode)rightNode;
                nameRefNode.setExternalRef(externalRef);
                return nameRefNode;
            }
            case RefNode: {
                RefNode refNode = (RefNode)this.right;
                refNode.setExternalRef(externalRef);
                return refNode;
            }
            case AreaRefNode: {
                AreaRefNode areaRefNode = (AreaRefNode)this.right;
                areaRefNode.setExternalRef(externalRef);
                return areaRefNode;
            }
        }
        throw this._toError();
    }

    @Override
    public <R> R accept(TokenNodeVisitor<R> visitor) {
        throw new FormulaParseException("Shouldn't run into this case");
    }
}

