/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import org.apache.poi.ss.formula.LazyAreaEval;
import org.apache.poi.ss.formula.eval.AreaEval;
import org.apache.poi.ss.formula.eval.ArrayEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.Function1Arg;

public abstract class Fixed1ArgFunction
implements Function1Arg {
    @Override
    public final ValueEval evaluate(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
        return this.evaluate(args, srcRowIndex, srcColumnIndex, false);
    }

    public final ValueEval evaluate(ValueEval[] args, int srcRowIndex, int srcColumnIndex, boolean isArrayValue) {
        if (args.length != 1) {
            return ErrorEval.VALUE_INVALID;
        }
        ValueEval arg0 = args[0];
        if (isArrayValue && arg0 instanceof AreaEval) {
            return this.evaluateArray(srcRowIndex, srcColumnIndex, arg0);
        }
        return this.evaluate(srcRowIndex, srcColumnIndex, arg0);
    }

    private ValueEval evaluateArray(int srcRowIndex, int srcColumnIndex, ValueEval arg0) {
        AreaEval ae0 = (AreaEval)arg0;
        int w0 = ae0.getWidth();
        int h0 = ae0.getHeight();
        ValueEval[][] results = new ValueEval[h0][];
        for (int r = 0; r < h0; ++r) {
            results[r] = new ValueEval[w0];
            for (int c = 0; c < w0; ++c) {
                ValueEval ve0 = ae0.getRelativeValue(r, c);
                ValueEval ve = this.evaluate(srcRowIndex, srcColumnIndex, ve0);
                if (ve0 instanceof ErrorEval) {
                    return ve0;
                }
                if (ve instanceof ErrorEval) {
                    return ve;
                }
                results[r][c] = ve;
            }
        }
        return new ArrayEval(results, ae0.getFirstRow(), ae0.getFirstColumn(), ae0.getLastRow(), ae0.getLastColumn(), ae0 instanceof ArrayEval ? ((ArrayEval)ae0).getRefEvaluator() : (ae0 instanceof LazyAreaEval ? ((LazyAreaEval)ae0).getRefEvaluator() : null));
    }
}

