/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.util.Unbox;
import org.apache.poi.logging.PoiLogManager;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.CacheAreaEval;
import org.apache.poi.ss.formula.CollaboratingWorkbooksEnvironment;
import org.apache.poi.ss.formula.DependencyTracker;
import org.apache.poi.ss.formula.EvaluationCache;
import org.apache.poi.ss.formula.EvaluationCell;
import org.apache.poi.ss.formula.EvaluationName;
import org.apache.poi.ss.formula.EvaluationSheet;
import org.apache.poi.ss.formula.EvaluationTracker;
import org.apache.poi.ss.formula.EvaluationWorkbook;
import org.apache.poi.ss.formula.FormulaCellCacheEntry;
import org.apache.poi.ss.formula.FormulaParser;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.FormulaType;
import org.apache.poi.ss.formula.IEvaluationListener;
import org.apache.poi.ss.formula.IStabilityClassifier;
import org.apache.poi.ss.formula.OperationEvaluationContext;
import org.apache.poi.ss.formula.OperationEvaluatorFactory;
import org.apache.poi.ss.formula.SortedValues;
import org.apache.poi.ss.formula.atp.AnalysisToolPak;
import org.apache.poi.ss.formula.eval.AreaEval;
import org.apache.poi.ss.formula.eval.BlankEval;
import org.apache.poi.ss.formula.eval.BoolEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.ExternalNameEval;
import org.apache.poi.ss.formula.eval.FunctionEval;
import org.apache.poi.ss.formula.eval.FunctionNameEval;
import org.apache.poi.ss.formula.eval.MissingArgEval;
import org.apache.poi.ss.formula.eval.NotImplementedException;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.RefListEval;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.ArrayMode;
import org.apache.poi.ss.formula.functions.Choose;
import org.apache.poi.ss.formula.functions.FreeRefFunction;
import org.apache.poi.ss.formula.functions.Function;
import org.apache.poi.ss.formula.functions.IfFunc;
import org.apache.poi.ss.formula.functions.OverridableFunction;
import org.apache.poi.ss.formula.ptg.AbstractFunctionPtg;
import org.apache.poi.ss.formula.ptg.Area3DPtg;
import org.apache.poi.ss.formula.ptg.Area3DPxg;
import org.apache.poi.ss.formula.ptg.AreaErrPtg;
import org.apache.poi.ss.formula.ptg.AreaPtg;
import org.apache.poi.ss.formula.ptg.AreaPtgBase;
import org.apache.poi.ss.formula.ptg.ArrayPtg;
import org.apache.poi.ss.formula.ptg.AttrPtg;
import org.apache.poi.ss.formula.ptg.BoolPtg;
import org.apache.poi.ss.formula.ptg.ControlPtg;
import org.apache.poi.ss.formula.ptg.DeferredNamePtg;
import org.apache.poi.ss.formula.ptg.DeletedArea3DPtg;
import org.apache.poi.ss.formula.ptg.DeletedRef3DPtg;
import org.apache.poi.ss.formula.ptg.ErrPtg;
import org.apache.poi.ss.formula.ptg.ExpPtg;
import org.apache.poi.ss.formula.ptg.FuncVarPtg;
import org.apache.poi.ss.formula.ptg.IntPtg;
import org.apache.poi.ss.formula.ptg.MemAreaPtg;
import org.apache.poi.ss.formula.ptg.MemErrPtg;
import org.apache.poi.ss.formula.ptg.MemFuncPtg;
import org.apache.poi.ss.formula.ptg.MissingArgPtg;
import org.apache.poi.ss.formula.ptg.NamePtg;
import org.apache.poi.ss.formula.ptg.NameXPtg;
import org.apache.poi.ss.formula.ptg.NameXPxg;
import org.apache.poi.ss.formula.ptg.NumberPtg;
import org.apache.poi.ss.formula.ptg.OperationPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.formula.ptg.Ref3DPtg;
import org.apache.poi.ss.formula.ptg.Ref3DPxg;
import org.apache.poi.ss.formula.ptg.RefErrorPtg;
import org.apache.poi.ss.formula.ptg.RefPtg;
import org.apache.poi.ss.formula.ptg.RefPtgBase;
import org.apache.poi.ss.formula.ptg.StringPtg;
import org.apache.poi.ss.formula.ptg.UnionPtg;
import org.apache.poi.ss.formula.ptg.UnknownPtg;
import org.apache.poi.ss.formula.udf.AggregatingUDFFinder;
import org.apache.poi.ss.formula.udf.UDFFinder;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.util.CellRangeAddressBase;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.Internal;

@Internal
public final class WorkbookEvaluator {
    private static final Logger LOG = PoiLogManager.getLogger(WorkbookEvaluator.class);
    private final EvaluationWorkbook _workbook;
    private EvaluationCache _cache;
    private int _workbookIx;
    private final IEvaluationListener _evaluationListener;
    private final Map<EvaluationSheet, Integer> _sheetIndexesBySheet;
    private final Map<String, Integer> _sheetIndexesByName;
    private CollaboratingWorkbooksEnvironment _collaboratingWorkbookEnvironment;
    private final IStabilityClassifier _stabilityClassifier;
    private final AggregatingUDFFinder _udfFinder;
    private boolean _ignoreMissingWorkbooks;
    private final Map<Integer, Map<Integer, SortedValues>> _columnCacheBySheetIndexes;
    private DependencyTracker _dependencyTracker;
    private CacheManager _cacheManager;
    private boolean dbgEvaluationOutputForNextEval;
    private static final Logger EVAL_LOG = PoiLogManager.getLogger("POI.FormulaEval");
    private int dbgEvaluationOutputIndent = -1;
    private boolean _enabledCacheManager = true;

    public WorkbookEvaluator(EvaluationWorkbook workbook, IStabilityClassifier stabilityClassifier, UDFFinder udfFinder) {
        this(workbook, null, stabilityClassifier, udfFinder);
    }

    public WorkbookEvaluator(EvaluationWorkbook workbook, IStabilityClassifier stabilityClassifier, UDFFinder udfFinder, CacheManager cacheManager) {
        this(workbook, null, stabilityClassifier, udfFinder);
        this._cacheManager = cacheManager;
    }

    WorkbookEvaluator(EvaluationWorkbook workbook, IEvaluationListener evaluationListener, IStabilityClassifier stabilityClassifier, UDFFinder udfFinder) {
        AggregatingUDFFinder defaultToolkit;
        this._workbook = workbook;
        this._evaluationListener = evaluationListener;
        this._cache = new EvaluationCache(evaluationListener);
        this._columnCacheBySheetIndexes = new HashMap<Integer, Map<Integer, SortedValues>>();
        this._sheetIndexesBySheet = new HashMap<EvaluationSheet, Integer>();
        this._sheetIndexesByName = new HashMap<String, Integer>();
        this._collaboratingWorkbookEnvironment = CollaboratingWorkbooksEnvironment.EMPTY;
        this._workbookIx = 0;
        this._stabilityClassifier = stabilityClassifier;
        AggregatingUDFFinder aggregatingUDFFinder = defaultToolkit = workbook == null ? null : (AggregatingUDFFinder)workbook.getUDFFinder();
        if (defaultToolkit != null && udfFinder != null) {
            defaultToolkit.add(udfFinder);
        }
        this._udfFinder = defaultToolkit;
    }

    public void setDependencyTracker(DependencyTracker tracker) {
        this._dependencyTracker = tracker;
    }

    String getSheetName(int sheetIndex) {
        return this._workbook.getSheetName(sheetIndex);
    }

    EvaluationSheet getSheet(int sheetIndex) {
        return this._workbook.getSheet(sheetIndex);
    }

    EvaluationWorkbook getWorkbook() {
        return this._workbook;
    }

    EvaluationName getName(String name, int sheetIndex) {
        return this._workbook.getName(name, sheetIndex);
    }

    void attachToEnvironment(CollaboratingWorkbooksEnvironment collaboratingWorkbooksEnvironment, EvaluationCache cache, int workbookIx) {
        this._collaboratingWorkbookEnvironment = collaboratingWorkbooksEnvironment;
        this._cache = cache;
        this._workbookIx = workbookIx;
    }

    CollaboratingWorkbooksEnvironment getEnvironment() {
        return this._collaboratingWorkbookEnvironment;
    }

    void detachFromEnvironment() {
        this._collaboratingWorkbookEnvironment = CollaboratingWorkbooksEnvironment.EMPTY;
        this._cache = new EvaluationCache(this._evaluationListener);
        this._workbookIx = 0;
    }

    WorkbookEvaluator getOtherWorkbookEvaluator(String workbookName) throws CollaboratingWorkbooksEnvironment.WorkbookNotFoundException {
        return this._collaboratingWorkbookEnvironment.getWorkbookEvaluator(workbookName);
    }

    IEvaluationListener getEvaluationListener() {
        return this._evaluationListener;
    }

    public void clearAllCachedResultValues() {
        this._cache.clear();
        this._sheetIndexesBySheet.clear();
        this._workbook.clearAllCachedResultValues();
        this._columnCacheBySheetIndexes.clear();
        this._sheetIndexesByName.clear();
    }

    public void notifyUpdateCell(EvaluationCell cell) {
        int sheetIndex = this.getSheetIndex(cell.getSheet());
        this._cache.notifyUpdateCell(this._workbookIx, sheetIndex, cell);
        this.clearColumnCache(sheetIndex, cell);
    }

    public void notifyClearIterationValue(EvaluationCell cell) {
        this._cache.notifyClearIterationValue(cell);
    }

    public void notifyDeleteCell(EvaluationCell cell) {
        int sheetIndex = this.getSheetIndex(cell.getSheet());
        this._cache.notifyDeleteCell(this._workbookIx, sheetIndex, cell);
        this.clearColumnCache(sheetIndex, cell);
    }

    private int getSheetIndex(EvaluationSheet sheet) {
        Integer result = this._sheetIndexesBySheet.get(sheet);
        if (result == null) {
            int sheetIndex = this._workbook.getSheetIndex(sheet);
            if (sheetIndex < 0) {
                throw new IllegalStateException("Specified sheet from a different book");
            }
            result = sheetIndex;
            this._sheetIndexesBySheet.put(sheet, result);
        }
        return result;
    }

    public void clearColumnCache(int sheetIndex, int start, int end) {
        Map<Integer, SortedValues> columnCache = this._columnCacheBySheetIndexes.get(sheetIndex);
        if (columnCache == null) {
            return;
        }
        for (int i = start; i <= end; ++i) {
            columnCache.remove(i);
        }
    }

    private void clearColumnCache(int sheetIndex, EvaluationCell cell) {
        this.clearColumnCache(sheetIndex, cell.getColumnIndex());
    }

    private void clearColumnCache(int sheetIndex, int columnIndex) {
        this.clearColumnCache(sheetIndex, columnIndex, columnIndex);
        Map<Integer, SortedValues> columnCache = this._columnCacheBySheetIndexes.get(sheetIndex);
        if (columnCache != null) {
            columnCache.remove(columnIndex);
        }
    }

    public ValueEval evaluate(EvaluationCell srcCell, Object ref) {
        return this.evaluate(srcCell, ref, null);
    }

    public ValueEval evaluate(EvaluationCell srcCell, Object ref, int[] offset) {
        ValueEval result;
        int sheetIndex = this.getSheetIndex(srcCell.getSheet());
        FormulaCellCacheEntry cce = null;
        do {
            result = this.evaluateAny(srcCell, sheetIndex, srcCell.getRowIndex(), srcCell.getColumnIndex(), new EvaluationTracker(this._cache), ref, offset);
            if (cce != null) continue;
            cce = this._cache.getFormulaCellEntry(srcCell);
        } while (cce != null && cce.hasNext());
        return result;
    }

    public ValueEval evaluate(EvaluationCell srcCell) {
        int sheetIndex = this.getSheetIndex(srcCell.getSheet());
        return this.evaluateAny(srcCell, sheetIndex, srcCell.getRowIndex(), srcCell.getColumnIndex(), new EvaluationTracker(this._cache), null, null);
    }

    int getSheetIndex(String sheetName) {
        Integer result = this._sheetIndexesByName.get(sheetName);
        if (result == null) {
            int sheetIndex = this._workbook.getSheetIndex(sheetName);
            if (sheetIndex < 0) {
                return -1;
            }
            result = sheetIndex;
            this._sheetIndexesByName.put(sheetName, result);
        }
        return result;
    }

    int getSheetIndexByExternIndex(int externSheetIndex) {
        return this._workbook.convertFromExternSheetIndex(externSheetIndex);
    }

    public void enableCacheManager() {
        this._enabledCacheManager = true;
    }

    public void disableCacheManager() {
        this._enabledCacheManager = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private ValueEval evaluateAny(EvaluationCell srcCell, int sheetIndex, int rowIndex, int columnIndex, EvaluationTracker tracker, Object ref, int[] offset) {
        void var11_29;
        block25: {
            boolean shouldCellDependencyBeRecorded;
            boolean bl = shouldCellDependencyBeRecorded = this._stabilityClassifier == null || !this._stabilityClassifier.isCellFinal(sheetIndex, rowIndex, columnIndex);
            if (srcCell == null || srcCell.getCellType() != CellType.FORMULA) {
                ValueEval result = WorkbookEvaluator.getValueFromNonFormulaCell(srcCell);
                if (!shouldCellDependencyBeRecorded) return result;
                tracker.acceptPlainValueDependency(this._workbook, this._workbookIx, sheetIndex, rowIndex, columnIndex, result);
                return result;
            }
            FormulaCellCacheEntry cce = this._cache.getOrCreateFormulaCellEntry(srcCell);
            if (tracker.isEvaluatingCell(cce)) {
                tracker.startIter(cce);
                if (cce.hasNext()) {
                    return cce.getIterValueEval();
                }
            }
            if (shouldCellDependencyBeRecorded || cce.isInputSensitive()) {
                tracker.acceptFormulaDependency(cce);
            }
            IEvaluationListener evalListener = this._evaluationListener;
            if (cce.getValue() != null) {
                if (evalListener == null) return cce.getValue();
                evalListener.onCacheHit(sheetIndex, rowIndex, columnIndex, cce.getValue());
                return cce.getValue();
            }
            if (!tracker.startEvaluate(cce)) {
                return ErrorEval.CIRCULAR_REF_ERROR;
            }
            try {
                void var11_22;
                boolean bl2;
                boolean bl3 = true;
                try {
                    bl2 = ref == null || ref.getClass().getDeclaredMethod("getObjectType", null) == null;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Ptg[] ptgs = this._workbook.getFormulaTokens(srcCell);
                OperationEvaluationContext ec = new OperationEvaluationContext(this, this._workbook, sheetIndex, rowIndex, columnIndex, tracker, bl2, this._dependencyTracker, ref, offset);
                if (evalListener == null) {
                    ValueEval valueEval = this.evaluateFormula(ec, ptgs, false);
                } else {
                    evalListener.onStartEvaluate(srcCell, cce);
                    ValueEval valueEval = this.evaluateFormula(ec, ptgs, false);
                    evalListener.onEndEvaluate(cce, valueEval);
                }
                if (cce.updateAndCheckCircularIteration((ValueEval)var11_22)) break block25;
                cce.resetIter();
                tracker.updateCacheResult((ValueEval)var11_22);
                this.clearColumnCache(sheetIndex, columnIndex);
                if (this._cacheManager != null && this._enabledCacheManager) {
                    this._cacheManager.onUpdateCacheResult(srcCell, (ValueEval)var11_22);
                }
            }
            catch (NotImplementedException notImplementedException) {
                throw this.addExceptionInfo(notImplementedException, sheetIndex, rowIndex, columnIndex);
            }
            catch (RuntimeException runtimeException) {
                if (!(runtimeException.getCause() instanceof CollaboratingWorkbooksEnvironment.WorkbookNotFoundException)) throw runtimeException;
                if (!this._ignoreMissingWorkbooks) throw runtimeException;
                LOG.atInfo().log("{} - Continuing with cached value!", (Object)runtimeException.getCause().getMessage());
                switch (srcCell.getCachedFormulaResultType()) {
                    case NUMERIC: {
                        NumberEval numberEval = new NumberEval(srcCell.getNumericCellValue());
                        break;
                    }
                    case STRING: {
                        StringEval stringEval = new StringEval(srcCell.getStringCellValue());
                        break;
                    }
                    case BLANK: {
                        BlankEval blankEval = BlankEval.instance;
                        break;
                    }
                    case BOOLEAN: {
                        BoolEval boolEval = BoolEval.valueOf(srcCell.getBooleanCellValue());
                        break;
                    }
                    case ERROR: {
                        ErrorEval errorEval = ErrorEval.valueOf(srcCell.getErrorCellValue());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected cell type '" + String.valueOf((Object)srcCell.getCellType()) + "' found!");
                    }
                }
            }
            finally {
                tracker.endEvaluate(cce);
                if (!this._enabledCacheManager) {
                    this._cache.notifyDeleteCell(0, sheetIndex, srcCell);
                }
            }
        }
        void var12_16 = var11_29;
        LOG.atDebug().log(() -> this.lambda$evaluateAny$0(sheetIndex, rowIndex, columnIndex, (ValueEval)var12_16));
        return var11_29;
    }

    private NotImplementedException addExceptionInfo(NotImplementedException inner, int sheetIndex, int rowIndex, int columnIndex) {
        try {
            String sheetName = this._workbook.getSheetName(sheetIndex);
            CellReference cr = new CellReference(sheetName, rowIndex, columnIndex, false, false);
            String msg = "Error evaluating cell " + cr.formatAsString();
            return new NotImplementedException(msg, inner);
        }
        catch (Exception e) {
            LOG.atError().withThrowable((Throwable)e).log("Can't add exception info");
            return inner;
        }
    }

    static ValueEval getValueFromNonFormulaCell(EvaluationCell cell) {
        if (cell == null) {
            return BlankEval.instance;
        }
        CellType cellType = cell.getCellType();
        switch (cellType) {
            case NUMERIC: {
                return new NumberEval(cell.getNumericCellValue());
            }
            case STRING: {
                return new StringEval(cell.getStringCellValue());
            }
            case BOOLEAN: {
                return BoolEval.valueOf(cell.getBooleanCellValue());
            }
            case BLANK: {
                return BlankEval.instance;
            }
            case ERROR: {
                return ErrorEval.valueOf(cell.getErrorCellValue());
            }
        }
        throw new IllegalStateException("Unexpected cell type (" + String.valueOf((Object)cellType) + ")");
    }

    private ValueEval postProcessValueEval(OperationEvaluationContext ec, ValueEval opResult, boolean eval) {
        if (this._dependencyTracker != null) {
            opResult = this._dependencyTracker.postProcessValueEval(ec, opResult, eval);
        }
        return opResult;
    }

    private void addDependency(OperationEvaluationContext ec, Ptg[] ptgs) {
        if (this._dependencyTracker != null) {
            this._dependencyTracker.addDependency(ec, ptgs);
        }
    }

    @Internal
    ValueEval evaluateFormula(OperationEvaluationContext ec, Ptg[] ptgs, boolean ignoreDependency) {
        ValueEval result;
        if (!ignoreDependency) {
            this.addDependency(ec, ptgs);
        }
        String dbgIndentStr = "";
        if (this.dbgEvaluationOutputForNextEval) {
            this.dbgEvaluationOutputIndent = 1;
            this.dbgEvaluationOutputForNextEval = true;
        }
        if (this.dbgEvaluationOutputIndent > 0) {
            dbgIndentStr = "                                                                                                    ";
            String finalDbgIndentStr = dbgIndentStr = dbgIndentStr.substring(0, Math.min(dbgIndentStr.length(), this.dbgEvaluationOutputIndent * 2));
            EVAL_LOG.atWarn().log(() -> {
                String message = finalDbgIndentStr + "- evaluateFormula('" + ec.getRefEvaluatorForCurrentSheet().getSheetNameRange() + "'/" + new CellReference(ec.getRowIndex(), ec.getColumnIndex()).formatAsString() + "): " + Arrays.toString(ptgs).replace("\\Qorg.apache.poi.ss.formula.ptg.\\E", "");
                return new SimpleMessage(message);
            });
            ++this.dbgEvaluationOutputIndent;
        }
        EvaluationSheet evalSheet = ec.getWorkbook().getSheet(ec.getSheetIndex());
        EvaluationCell evalCell = evalSheet.getCell(ec.getRowIndex(), ec.getColumnIndex());
        Stack<ValueEval> stack = new Stack<ValueEval>();
        ec.clearFunctionStack();
        int iSize = ptgs.length;
        for (int i = 0; i < iSize; ++i) {
            ValueEval opResult;
            ec.setPtgIndex(i);
            Ptg ptg = ptgs[i];
            if (this.dbgEvaluationOutputIndent > 0) {
                EVAL_LOG.atInfo().log("{}  * ptg {}: {}, stack: {}", (Object)dbgIndentStr, (Object)Unbox.box((int)i), (Object)ptg, stack);
            }
            if (ptg instanceof AttrPtg) {
                AttrPtg attrPtg = (AttrPtg)ptg;
                if (attrPtg.isSum()) {
                    ptg = FuncVarPtg.SUM;
                }
                if (attrPtg.isOptimizedChoose()) {
                    int dist;
                    ValueEval arg0 = (ValueEval)stack.pop();
                    int[] jumpTable = attrPtg.getJumpTable();
                    int nChoices = jumpTable.length;
                    try {
                        int switchIndex = Choose.evaluateFirstArg(arg0, ec.getRowIndex(), ec.getColumnIndex());
                        if (switchIndex < 1 || switchIndex > nChoices) {
                            stack.push(ErrorEval.VALUE_INVALID);
                            dist = attrPtg.getChooseFuncOffset() + 4;
                        } else {
                            dist = jumpTable[switchIndex - 1];
                        }
                    }
                    catch (EvaluationException e) {
                        stack.push(e.getErrorEval());
                        dist = attrPtg.getChooseFuncOffset() + 4;
                    }
                    i += WorkbookEvaluator.countTokensToBeSkipped(ptgs, i, dist -= nChoices * 2 + 2, ec.getWorkbook().getSpreadsheetVersion());
                    ec.leaveFunction();
                    continue;
                }
                if (attrPtg.isOptimizedIf()) {
                    if (evalCell == null || !evalCell.isPartOfArrayFormulaGroup()) {
                        boolean evaluatedPredicate;
                        ValueEval arg0 = (ValueEval)stack.pop();
                        try {
                            evaluatedPredicate = IfFunc.evaluateFirstArg(arg0, ec.getRowIndex(), ec.getColumnIndex());
                        }
                        catch (EvaluationException e) {
                            stack.push(e.getErrorEval());
                            int dist = attrPtg.getData();
                            i += WorkbookEvaluator.countTokensToBeSkipped(ptgs, i, dist, ec.getWorkbook().getSpreadsheetVersion());
                            attrPtg = (AttrPtg)ptgs[i];
                            dist = attrPtg.getData() + 1;
                            i += WorkbookEvaluator.countTokensToBeSkipped(ptgs, i, dist, ec.getWorkbook().getSpreadsheetVersion());
                            continue;
                        }
                        if (!evaluatedPredicate) {
                            short dist = attrPtg.getData();
                            i += WorkbookEvaluator.countTokensToBeSkipped(ptgs, i, dist, ec.getWorkbook().getSpreadsheetVersion());
                            Ptg nextPtg = ptgs[i + 1];
                            if (ptgs[i] instanceof AttrPtg && nextPtg instanceof FuncVarPtg && ((FuncVarPtg)nextPtg).getFunctionIndex() == 1) {
                                stack.push(arg0);
                                stack.push(BoolEval.FALSE);
                            }
                        }
                    }
                    ec.leaveFunction();
                    continue;
                }
                if (attrPtg.isSkip() && (evalCell == null || !evalCell.isPartOfArrayFormulaGroup())) {
                    int dist = attrPtg.getData() + 1;
                    i += WorkbookEvaluator.countTokensToBeSkipped(ptgs, i, dist, ec.getWorkbook().getSpreadsheetVersion());
                    if (stack.peek() != MissingArgEval.instance) continue;
                    stack.pop();
                    stack.push(BlankEval.instance);
                    continue;
                }
                if (attrPtg.isFunIn()) {
                    ec.enterFunction(attrPtg.getData());
                    continue;
                }
            }
            if (ptg instanceof ControlPtg || ptg instanceof MemFuncPtg || ptg instanceof MemAreaPtg || ptg instanceof MemErrPtg) continue;
            if (ptg instanceof UnionPtg) {
                ValueEval v2 = (ValueEval)stack.pop();
                ValueEval v1 = (ValueEval)stack.pop();
                stack.push(new RefListEval(v1, v2));
                continue;
            }
            if (ptg instanceof OperationPtg) {
                OperationPtg optg = (OperationPtg)ptg;
                int numops = optg.getNumberOfOperands();
                ValueEval[] ops = new ValueEval[numops];
                boolean areaArg = false;
                for (int j = numops - 1; j >= 0; --j) {
                    ValueEval p = (ValueEval)stack.pop();
                    p = optg instanceof FuncVarPtg && ((FuncVarPtg)optg).isExternal() ? this.postProcessValueEval(ec, p, j > 0) : this.postProcessValueEval(ec, p, true);
                    ops[j] = p;
                    if (!(p instanceof AreaEval)) continue;
                    areaArg = true;
                }
                boolean arrayMode = false;
                if (areaArg) {
                    for (int ii = i; ii < iSize; ++ii) {
                        if (!(ptgs[ii] instanceof FuncVarPtg)) continue;
                        FuncVarPtg f = (FuncVarPtg)ptgs[ii];
                        try {
                            Function func = FunctionEval.getBasicFunction(f.getFunctionIndex());
                            if (!(func instanceof ArrayMode) && (!(func instanceof OverridableFunction) || !((OverridableFunction)func).isArrayModeFunction())) break;
                            arrayMode = true;
                        }
                        catch (NotImplementedException notImplementedException) {}
                        break;
                    }
                }
                if (ptg instanceof AbstractFunctionPtg) {
                    ec.leaveFunction();
                }
                ec.setArrayMode(arrayMode);
                opResult = OperationEvaluatorFactory.evaluate(optg, ops, ec);
                opResult = this.postProcessValueEval(ec, opResult, true);
                ec.setArrayMode(false);
            } else {
                opResult = this.getEvalForPtg(ptg, ec);
                opResult = this.postProcessValueEval(ec, opResult, false);
            }
            if (opResult == null) {
                throw new IllegalStateException("Evaluation result must not be null");
            }
            stack.push(opResult);
            if (this.dbgEvaluationOutputIndent <= 0) continue;
            EVAL_LOG.atInfo().log("{}    = {}", (Object)dbgIndentStr, (Object)opResult);
        }
        ec.clearFunctionStack();
        ValueEval value = (ValueEval)stack.pop();
        if (!stack.isEmpty()) {
            throw new IllegalStateException("evaluation stack not empty");
        }
        value = this.postProcessValueEval(ec, value, true);
        if (ec.isSingleValue()) {
            result = WorkbookEvaluator.dereferenceResult(value, ec);
            if (result == ErrorEval.VALUE_INVALID && value instanceof CacheAreaEval) {
                result = ((CacheAreaEval)value).getRelativeValue(0, 0);
            }
        } else {
            result = value;
        }
        if (this.dbgEvaluationOutputIndent > 0) {
            EVAL_LOG.atInfo().log("{}finished eval of {}: {}", (Object)dbgIndentStr, (Object)new CellReference(ec.getRowIndex(), ec.getColumnIndex()).formatAsString(), (Object)result);
            --this.dbgEvaluationOutputIndent;
            if (this.dbgEvaluationOutputIndent == 1) {
                this.dbgEvaluationOutputIndent = -1;
            }
        }
        return result;
    }

    private static int countTokensToBeSkipped(Ptg[] ptgs, int startIndex, int distInBytes, SpreadsheetVersion version) {
        int remBytes = distInBytes;
        int index = startIndex;
        while (remBytes != 0) {
            if (++index >= ptgs.length) {
                throw new IllegalStateException("Skip distance too far (ran out of formula tokens).");
            }
            if ((remBytes -= ptgs[index].getSize(version)) >= 0) continue;
            throw new IllegalStateException("Bad skip distance (wrong token size calculation).");
        }
        return index - startIndex;
    }

    private static ValueEval dereferenceResult(ValueEval evaluationResult, OperationEvaluationContext ec) {
        if (ec == null) {
            throw new IllegalArgumentException("OperationEvaluationContext ec is null");
        }
        if (ec.getWorkbook() == null) {
            throw new IllegalArgumentException("OperationEvaluationContext ec.getWorkbook() is null");
        }
        EvaluationSheet evalSheet = ec.getWorkbook().getSheet(ec.getSheetIndex());
        EvaluationCell evalCell = evalSheet.getCell(ec.getRowIndex(), ec.getColumnIndex());
        ValueEval value = evalCell != null && evalCell.isPartOfArrayFormulaGroup() && evaluationResult instanceof AreaEval ? OperandResolver.getElementFromArray((AreaEval)evaluationResult, evalCell) : WorkbookEvaluator.dereferenceResult(evaluationResult, ec.getRowIndex(), ec.getColumnIndex());
        if (value == BlankEval.instance) {
            return NumberEval.ZERO;
        }
        return value;
    }

    public static ValueEval dereferenceResult(ValueEval evaluationResult, int srcRowNum, int srcColNum) {
        ValueEval value;
        try {
            value = OperandResolver.getSingleValue(evaluationResult, srcRowNum, srcColNum);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        if (value == BlankEval.instance) {
            return NumberEval.ZERO;
        }
        return value;
    }

    private ValueEval getEvalForPtg(Ptg ptg, OperationEvaluationContext ec) {
        if (ptg instanceof NamePtg) {
            NamePtg namePtg = (NamePtg)ptg;
            EvaluationName nameRecord = this._workbook.getName(namePtg);
            return this.getEvalForNameRecord(nameRecord, ec);
        }
        if (ptg instanceof NameXPtg) {
            return this.processNameEval(ec.getNameXEval((NameXPtg)ptg), ec);
        }
        if (ptg instanceof NameXPxg) {
            return this.processNameEval(ec.getNameXEval((NameXPxg)ptg), ec);
        }
        if (ptg instanceof IntPtg) {
            return new NumberEval(((IntPtg)ptg).getValue());
        }
        if (ptg instanceof NumberPtg) {
            return new NumberEval(((NumberPtg)ptg).getValue());
        }
        if (ptg instanceof StringPtg) {
            return new StringEval(((StringPtg)ptg).getValue());
        }
        if (ptg instanceof BoolPtg) {
            return BoolEval.valueOf(((BoolPtg)ptg).getValue());
        }
        if (ptg instanceof ErrPtg) {
            return ErrorEval.valueOf(((ErrPtg)ptg).getErrorCode());
        }
        if (ptg instanceof MissingArgPtg) {
            return MissingArgEval.instance;
        }
        if (ptg instanceof AreaErrPtg || ptg instanceof RefErrorPtg || ptg instanceof DeletedArea3DPtg || ptg instanceof DeletedRef3DPtg) {
            return ErrorEval.REF_INVALID;
        }
        if (ptg instanceof Ref3DPtg) {
            return ec.getRef3DEval((Ref3DPtg)ptg);
        }
        if (ptg instanceof Ref3DPxg) {
            return ec.getRef3DEval((Ref3DPxg)ptg);
        }
        if (ptg instanceof Area3DPtg) {
            return ec.getArea3DEval((Area3DPtg)ptg);
        }
        if (ptg instanceof Area3DPxg) {
            return ec.getArea3DEval((Area3DPxg)ptg);
        }
        if (ptg instanceof RefPtg) {
            RefPtg rptg = (RefPtg)ptg;
            return ec.getRefEval(rptg.getRow(), rptg.getColumn(), rptg.isRowRelative(), rptg.isColRelative());
        }
        if (ptg instanceof AreaPtg) {
            AreaPtg aptg = (AreaPtg)ptg;
            return ec.getAreaEval(aptg.getFirstRow(), aptg.getFirstColumn(), aptg.getLastRow(), aptg.getLastColumn(), aptg.isFirstRowRelative(), aptg.isFirstColRelative(), aptg.isLastRowRelative(), aptg.isLastColRelative());
        }
        if (ptg instanceof ArrayPtg) {
            ArrayPtg aptg = (ArrayPtg)ptg;
            return ec.getAreaValueEval(0, 0, aptg.getRowCount() - 1, aptg.getColumnCount() - 1, aptg.getTokenArrayValues());
        }
        if (ptg instanceof UnknownPtg) {
            throw new IllegalStateException("UnknownPtg not allowed");
        }
        if (ptg instanceof ExpPtg) {
            throw new IllegalStateException("ExpPtg currently not supported");
        }
        if (ptg instanceof DeferredNamePtg) {
            DeferredNamePtg pnp = (DeferredNamePtg)ptg;
            return new FunctionNameEval(pnp.toFormulaString());
        }
        throw new IllegalStateException("Unexpected ptg class (" + ptg.getClass().getName() + ")");
    }

    private ValueEval processNameEval(ValueEval eval, OperationEvaluationContext ec) {
        if (eval instanceof ExternalNameEval) {
            EvaluationName name = ((ExternalNameEval)eval).getName();
            return this.getEvalForNameRecord(name, ec);
        }
        return eval;
    }

    private ValueEval getEvalForNameRecord(EvaluationName nameRecord, OperationEvaluationContext ec) {
        if (nameRecord.isFunctionName()) {
            return new FunctionNameEval(nameRecord.getNameText());
        }
        if (nameRecord.hasFormula()) {
            return this.evaluateNameFormula(nameRecord.getNameDefinition(), ec);
        }
        return new FunctionNameEval(nameRecord.getNameText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValueEval evaluateNameFormula(Ptg[] ptgs, OperationEvaluationContext ec) {
        if (ptgs.length == 1 && !(ptgs[0] instanceof FuncVarPtg)) {
            return this.getEvalForPtg(ptgs[0], ec);
        }
        boolean old = ec.isEvalNameFormula();
        OperationEvaluationContext anyValueContext = new OperationEvaluationContext(this, ec.getWorkbook(), ec.getSheetIndex(), ec.getRowIndex(), ec.getColumnIndex(), new EvaluationTracker(this._cache), false, this._dependencyTracker, ec.getDependent(), ec._offset);
        anyValueContext.setEvalNameFormula(true);
        try {
            ptgs = this.shiftPtgs(ptgs, ec.getRowIndex(), ec.getColumnIndex());
            ValueEval valueEval = this.evaluateFormula(anyValueContext, ptgs, true);
            return valueEval;
        }
        catch (CloneNotSupportedException e) {
            LOG.log(Level.ERROR, (Object)e);
        }
        finally {
            anyValueContext.setEvalNameFormula(old);
        }
        return this.evaluateFormula(anyValueContext, ptgs, true);
    }

    private Ptg[] shiftPtgs(Ptg[] ptgs, int rowOffset, int columnOffset) throws CloneNotSupportedException {
        if (rowOffset != 0 || columnOffset != 0) {
            Ptg[] newPtgs = new Ptg[ptgs.length];
            for (int i = 0; i < ptgs.length; ++i) {
                Ptg ptg = ptgs[i];
                if (ptg instanceof RefPtgBase) {
                    RefPtgBase rptg = (RefPtgBase)ptg.copy();
                    int r = rptg.getRow() + (rptg.isRowRelative() ? rowOffset : 0);
                    int c = rptg.getColumn() + (rptg.isColRelative() ? columnOffset : 0);
                    rptg.setRow(r % 0x100000);
                    rptg.setColumn(c % 16384);
                    newPtgs[i] = rptg;
                    continue;
                }
                if (ptg instanceof AreaPtgBase) {
                    AreaPtgBase aptg = (AreaPtgBase)ptg.copy();
                    int r0 = aptg.getFirstRow() + (aptg.isFirstRowRelative() ? rowOffset : 0) % 0x100000;
                    int r1 = aptg.getLastRow() + (aptg.isLastRowRelative() ? rowOffset : 0) % 0x100000;
                    int c0 = aptg.getFirstColumn() + (aptg.isFirstColRelative() ? columnOffset : 0) % 16384;
                    int c1 = aptg.getLastColumn() + (aptg.isLastColRelative() ? columnOffset : 0) % 16384;
                    aptg.setFirstRow(Math.min(r0, r1));
                    aptg.setLastRow(Math.max(r0, r1));
                    aptg.setFirstColumn(Math.min(c0, c1));
                    aptg.setLastColumn(Math.max(c0, c1));
                    newPtgs[i] = aptg;
                    continue;
                }
                newPtgs[i] = ptg;
            }
            return newPtgs;
        }
        return ptgs;
    }

    ValueEval evaluateReference(EvaluationSheet sheet, int sheetIndex, int rowIndex, int columnIndex, EvaluationTracker tracker) {
        EvaluationCell cell = sheet.getCell(rowIndex, columnIndex);
        return this.evaluateAny(cell, sheetIndex, rowIndex, columnIndex, tracker, null, null);
    }

    SortedValues getSortedColumnValue(String sheetName, int columnIndex, int firstRowIndex, int lastRowIndex, EvaluationTracker tracker) {
        Map<Object, Object> columnCache;
        if ("#REF".equals(sheetName)) {
            return null;
        }
        int index = this.getSheetIndex(sheetName);
        if (this._columnCacheBySheetIndexes.containsKey(index)) {
            columnCache = this._columnCacheBySheetIndexes.get(index);
        } else {
            columnCache = new HashMap();
            this._columnCacheBySheetIndexes.put(index, columnCache);
        }
        SortedValues sortedValues = (SortedValues)columnCache.get(columnIndex);
        if (sortedValues == null) {
            sortedValues = new SortedValues();
            EvaluationSheet sheet = this.getSheet(index);
            Iterator<EvaluationCell> iter = sheet.nonEmptyCellsIterator(columnIndex);
            while (iter.hasNext()) {
                EvaluationCell cell = iter.next();
                int rowIndex = cell.getRowIndex();
                if (firstRowIndex > rowIndex || rowIndex > lastRowIndex) continue;
                ValueEval value = this.evaluateAny(cell, index, rowIndex, columnIndex, tracker, null, null);
                if (value instanceof NumberEval) {
                    sortedValues.addValue(((NumberEval)value).getNumberValue(), rowIndex);
                    continue;
                }
                if (value instanceof StringEval) {
                    sortedValues.addValue(((StringEval)value).getStringValue().toLowerCase(), rowIndex);
                    continue;
                }
                if (!(value instanceof BoolEval)) continue;
                sortedValues.addValue(((BoolEval)value).getBooleanValue(), rowIndex);
            }
            columnCache.put(columnIndex, sortedValues);
        }
        return sortedValues;
    }

    public FreeRefFunction findUserDefinedFunction(String functionName) {
        return this._udfFinder.findFunction(functionName);
    }

    public ValueEval evaluate(String formula, CellReference ref, int[] offset) {
        String sheetName = ref == null ? null : ref.getSheetName();
        int sheetIndex = sheetName == null ? -1 : this.getWorkbook().getSheetIndex(sheetName);
        int rowIndex = ref == null ? -1 : ref.getRow();
        int colIndex = ref == null ? -1 : (int)ref.getCol();
        OperationEvaluationContext ec = new OperationEvaluationContext(this, this.getWorkbook(), sheetIndex, rowIndex, colIndex, new EvaluationTracker(this._cache), true, this._dependencyTracker, ref, offset);
        Ptg[] ptgs = FormulaParser.parse(formula, (FormulaParsingWorkbook)((Object)this.getWorkbook()), FormulaType.CELL, sheetIndex, rowIndex);
        return this.evaluateNameFormula(ptgs, ec);
    }

    public ValueEval evaluate(String formula, CellReference target, CellRangeAddressBase region) {
        return this.evaluate(formula, target, region, FormulaType.CELL);
    }

    public ValueEval evaluateList(String formula, CellReference target, CellRangeAddressBase region) {
        return this.evaluate(formula, target, region, FormulaType.DATAVALIDATION_LIST);
    }

    private ValueEval evaluate(String formula, CellReference target, CellRangeAddressBase region, FormulaType formulaType) {
        String sheetName;
        String string = sheetName = target == null ? null : target.getSheetName();
        if (sheetName == null) {
            throw new IllegalArgumentException("Sheet name is required");
        }
        int sheetIndex = this.getWorkbook().getSheetIndex(sheetName);
        Ptg[] ptgs = FormulaParser.parse(formula, (FormulaParsingWorkbook)((Object)this.getWorkbook()), formulaType, sheetIndex, target.getRow());
        this.adjustRegionRelativeReference(ptgs, target, region);
        OperationEvaluationContext ec = new OperationEvaluationContext(this, this.getWorkbook(), sheetIndex, target.getRow(), target.getCol(), new EvaluationTracker(this._cache), formulaType.isSingleValue(), this._dependencyTracker, target, null);
        return this.evaluateNameFormula(ptgs, ec);
    }

    private boolean adjustRegionRelativeReference(Ptg[] ptgs, CellReference target, CellRangeAddressBase region) {
        int deltaRow = target.getRow() - region.getFirstRow();
        int deltaColumn = target.getCol() - region.getFirstColumn();
        boolean shifted = false;
        for (Ptg ptg : ptgs) {
            if (!(ptg instanceof RefPtgBase)) continue;
            RefPtgBase ref = (RefPtgBase)ptg;
            SpreadsheetVersion version = this._workbook.getSpreadsheetVersion();
            if (ref.isRowRelative() && deltaRow > 0) {
                int rowIndex = ref.getRow() + deltaRow;
                if (rowIndex > version.getMaxRows()) {
                    throw new IndexOutOfBoundsException(version.name() + " files can only have " + version.getMaxRows() + " rows, but row " + rowIndex + " was requested.");
                }
                ref.setRow(rowIndex);
                shifted = true;
            }
            if (!ref.isColRelative() || deltaColumn <= 0) continue;
            int colIndex = ref.getColumn() + deltaColumn;
            if (colIndex > version.getMaxColumns()) {
                throw new IndexOutOfBoundsException(version.name() + " files can only have " + version.getMaxColumns() + " columns, but column " + colIndex + " was requested.");
            }
            ref.setColumn(colIndex);
            shifted = true;
        }
        return shifted;
    }

    public void setIgnoreMissingWorkbooks(boolean ignore) {
        this._ignoreMissingWorkbooks = ignore;
    }

    public boolean isIgnoreMissingWorkbooks() {
        return this._ignoreMissingWorkbooks;
    }

    public static Collection<String> getSupportedFunctionNames() {
        TreeSet<String> lst = new TreeSet<String>();
        lst.addAll(FunctionEval.getSupportedFunctionNames());
        lst.addAll(AnalysisToolPak.getSupportedFunctionNames());
        return Collections.unmodifiableCollection(lst);
    }

    public static Collection<String> getNotSupportedFunctionNames() {
        TreeSet<String> lst = new TreeSet<String>();
        lst.addAll(FunctionEval.getNotSupportedFunctionNames());
        lst.addAll(AnalysisToolPak.getNotSupportedFunctionNames());
        return Collections.unmodifiableCollection(lst);
    }

    public static void registerFunction(String name, FreeRefFunction func) {
        AnalysisToolPak.registerFunction(name, func);
    }

    public static void registerFunction(String name, Function func) {
        FunctionEval.registerFunction(name, func);
    }

    public void setDebugEvaluationOutputForNextEval(boolean value) {
        this.dbgEvaluationOutputForNextEval = value;
    }

    public boolean isDebugEvaluationOutputForNextEval() {
        return this.dbgEvaluationOutputForNextEval;
    }

    private /* synthetic */ Message lambda$evaluateAny$0(int sheetIndex, int rowIndex, int columnIndex, ValueEval resultForLogging) {
        String sheetName = this.getSheetName(sheetIndex);
        CellReference cr = new CellReference(rowIndex, columnIndex);
        return new SimpleMessage("Evaluated " + sheetName + "!" + cr.formatAsString() + " to " + String.valueOf(resultForLogging));
    }

    public static interface CacheManager {
        public void onUpdateCacheResult(EvaluationCell var1, ValueEval var2);
    }
}

