/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.chart;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.hssf.record.HSSFRecordTypes;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public final class PieFormatRecord
extends StandardRecord {
    public static final short sid = 4107;
    private short field_1_pcExplode;

    public PieFormatRecord() {
    }

    public PieFormatRecord(RecordInputStream in) {
        this.field_1_pcExplode = in.readShort();
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.field_1_pcExplode);
    }

    @Override
    public PieFormatRecord copy() {
        return (PieFormatRecord)this.clone();
    }

    @Override
    protected int getDataSize() {
        return 2;
    }

    @Override
    public short getSid() {
        return 4107;
    }

    @Override
    public HSSFRecordTypes getGenericRecordType() {
        return HSSFRecordTypes.PIE_FORMAT;
    }

    public Object clone() {
        PieFormatRecord rec = new PieFormatRecord();
        rec.field_1_pcExplode = this.field_1_pcExplode;
        return rec;
    }

    public short getPcExplode() {
        return this.field_1_pcExplode;
    }

    public void setPcExplode(short field_1_pcExplode) {
        this.field_1_pcExplode = field_1_pcExplode;
    }

    @Override
    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties("pcExplode", () -> "0x" + HexDump.toHex(this.getPcExplode()));
    }
}

