/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.hssf.record.HSSFRecordTypes;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.hssf.record.common.FtrHeader;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.LittleEndianOutput;

public class CompressPicturesRecord
extends StandardRecord {
    private static final BitField fAutoCompressPictures = BitFieldFactory.getInstance(1);
    public static final short sid = 2203;
    private FtrHeader futureHeader;
    int bits;

    public CompressPicturesRecord() {
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2203);
    }

    public CompressPicturesRecord(RecordInputStream in) {
        this.futureHeader = new FtrHeader(in);
        this.bits = in.readInt();
    }

    @Override
    public short getSid() {
        return 2203;
    }

    @Override
    public HSSFRecordTypes getGenericRecordType() {
        return HSSFRecordTypes.COMPRESS_PICTURES;
    }

    public boolean isAutoCompressPictures() {
        return fAutoCompressPictures.isSet(this.bits);
    }

    public void setAutoCompressPictures(boolean flag) {
        this.bits = fAutoCompressPictures.setBoolean(this.bits, flag);
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        this.futureHeader.serialize(out);
        out.writeInt(this.bits);
    }

    @Override
    public CompressPicturesRecord copy() {
        return (CompressPicturesRecord)this.clone();
    }

    public Object clone() {
        return this.cloneViaReserialise();
    }

    @Override
    protected int getDataSize() {
        return 16;
    }

    @Override
    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties("bits", () -> Integer.toHexString(this.bits), "fAutoCompressPictures", this::isAutoCompressPictures);
    }
}

