/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.poi.ss.usermodel.ConditionalFormatting;
import org.apache.poi.ss.usermodel.SheetProtection;
import org.apache.poi.xssf.usermodel.XSSFConditionalFormatting;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFSheetProtection;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTAutoFilter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCfRule;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTExtension;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTExtensionList;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPrintOptions;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetProtection;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STUnsignedShortHex;
import org.w3c.dom.Element;

public class XSSFSheetHelper {
    public static void setSheetPasswordHash(XSSFSheet sheet, short hashpass) {
        CTSheetProtection sheetProtection = sheet.worksheet.getSheetProtection();
        if (sheetProtection != null && sheet.worksheet.getSheetProtection().getSheet()) {
            sheetProtection.xsetPassword(XSSFSheetHelper.stringToExcelPassword(hashpass));
        }
    }

    private static STUnsignedShortHex stringToExcelPassword(short hash) {
        STUnsignedShortHex hexPassword = (STUnsignedShortHex)STUnsignedShortHex.Factory.newInstance();
        hexPassword.setStringValue(String.format(Locale.ROOT, "%04X", hash).toUpperCase(Locale.ROOT));
        return hexPassword;
    }

    public static void setSheetPassword(XSSFSheet sheet, String saltValue, String hashValue, String spinCount, String algName) {
        if (!sheet.worksheet.isSetSheetProtection()) {
            XSSFSheetHelper.setPassword((XmlObject)sheet.worksheet.addNewSheetProtection(), saltValue, hashValue, spinCount, algName);
        } else {
            XSSFSheetHelper.setPassword((XmlObject)sheet.worksheet.getSheetProtection(), saltValue, hashValue, spinCount, algName);
        }
    }

    public static void unsetSheetProtection(XSSFSheet sheet) {
        CTSheetProtection sheetProtection = sheet.worksheet.getSheetProtection();
        if (sheetProtection != null) {
            if (sheetProtection.isSetScenarios()) {
                sheetProtection.unsetScenarios();
            }
            if (sheetProtection.isSetObjects()) {
                sheetProtection.unsetObjects();
            }
            if (XSSFSheetHelper.isEmptySheetProtection(sheet)) {
                sheet.worksheet.unsetSheetProtection();
            }
        }
    }

    private static boolean isEmptySheetProtection(XSSFSheet sheet) {
        CTSheetProtection ct = sheet.worksheet.getSheetProtection();
        return ct == null || !ct.isSetAutoFilter() && !ct.isSetDeleteColumns() && !ct.isSetDeleteRows() && !ct.isSetFormatCells() && !ct.isSetFormatColumns() && !ct.isSetFormatRows() && !ct.isSetInsertColumns() && !ct.isSetInsertHyperlinks() && !ct.isSetInsertRows() && !ct.isSetObjects() && !ct.isSetPassword() && !ct.isSetPivotTables() && !ct.isSetScenarios() && !ct.isSetSelectLockedCells() && !ct.isSetSelectUnlockedCells() && !ct.isSetSheet() && !ct.isSetSort();
    }

    private static void setPassword(XmlObject xobj, String saltValue, String hashValue, String spinCount, String algName) {
        Element xobjDomNode = (Element)xobj.getDomNode();
        if (saltValue == null) {
            xobjDomNode.removeAttribute("saltValue");
        } else {
            xobjDomNode.setAttribute("saltValue", saltValue);
        }
        if (hashValue == null) {
            xobjDomNode.removeAttribute("hashValue");
        } else {
            xobjDomNode.setAttribute("hashValue", hashValue);
        }
        if (spinCount == null) {
            xobjDomNode.removeAttribute("spinCount");
        } else {
            xobjDomNode.setAttribute("spinCount", spinCount);
        }
        if (algName == null) {
            xobjDomNode.removeAttribute("algorithmName");
        } else {
            xobjDomNode.setAttribute("algorithmName", algName);
        }
    }

    public static void setSparkline(XSSFSheet sheet, String valuesFormula, String anchor, String type, boolean isWinlose, boolean firstVisible, boolean lastVisible, boolean highVisible, boolean lowVisible, boolean negativeVisible, boolean markersVisible, String seriesColor, String firstColor, String lastColor, String highColor, String lowColor, String negativeColor, String markersColor) {
        XmlCursor cursor;
        CTExtensionList extLst;
        if (isWinlose) {
            type = "stacked";
        }
        if ((extLst = sheet.worksheet.getExtLst()) == null) {
            extLst = sheet.worksheet.addNewExtLst();
        }
        String sparklineExtUri = "{05C60535-1F16-4fd2-B633-F4F36F0B64E0}";
        List extList = extLst.getExtList();
        CTExtension sparklineExt = null;
        for (CTExtension ext : extList) {
            if (!"{05C60535-1F16-4fd2-B633-F4F36F0B64E0}".equals(ext.getUri())) continue;
            sparklineExt = ext;
            break;
        }
        String x14NS = "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main";
        String xmNS = "http://schemas.microsoft.com/office/excel/2006/main";
        if (sparklineExt == null) {
            sparklineExt = extLst.addNewExt();
            cursor = sparklineExt.newCursor();
            cursor.toNextToken();
            cursor.insertNamespace("x14", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
            cursor.insertAttributeWithValue("uri", "{05C60535-1F16-4fd2-B633-F4F36F0B64E0}");
        } else {
            cursor = sparklineExt.newCursor();
        }
        String sparklineGroupsTag = "sparklineGroups";
        if (!cursor.toChild("http://schemas.microsoft.com/office/spreadsheetml/2009/9/main", "sparklineGroups")) {
            cursor.toChild(0);
            cursor.beginElement("sparklineGroups", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
            cursor.insertNamespace("xm", "http://schemas.microsoft.com/office/excel/2006/main");
        }
        cursor.toChild(0);
        cursor.beginElement("sparklineGroup", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
        cursor.insertAttributeWithValue("displayEmptyCellsAs", "gap");
        if (!"line".equals(type.toLowerCase())) {
            cursor.insertAttributeWithValue("type", type.toLowerCase());
        }
        if (firstVisible) {
            cursor.insertAttributeWithValue("first", "1");
        }
        if (highVisible) {
            cursor.insertAttributeWithValue("high", "1");
        }
        if (lastVisible) {
            cursor.insertAttributeWithValue("last", "1");
        }
        if (lowVisible) {
            cursor.insertAttributeWithValue("low", "1");
        }
        if (markersVisible) {
            cursor.insertAttributeWithValue("markers", "1");
        }
        if (isWinlose || negativeVisible) {
            cursor.insertAttributeWithValue("negative", "1");
        }
        cursor.toChild(0);
        String attrRgb = "rgb";
        String color1 = "D00000";
        cursor.beginElement("colorSeries", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
        cursor.insertAttributeWithValue("rgb", XSSFSheetHelper.toRgb(seriesColor, "376092"));
        cursor.toNextToken();
        cursor.beginElement("colorNegative", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
        cursor.insertAttributeWithValue("rgb", XSSFSheetHelper.toRgb(negativeColor, "D00000"));
        cursor.toNextToken();
        cursor.beginElement("colorAxis", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
        cursor.insertAttributeWithValue("rgb", "FF000000");
        cursor.toNextToken();
        cursor.beginElement("colorMarkers", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
        cursor.insertAttributeWithValue("rgb", XSSFSheetHelper.toRgb(markersColor, "D00000"));
        cursor.toNextToken();
        cursor.beginElement("colorFirst", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
        cursor.insertAttributeWithValue("rgb", XSSFSheetHelper.toRgb(firstColor, "D00000"));
        cursor.toNextToken();
        cursor.beginElement("colorLast", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
        cursor.insertAttributeWithValue("rgb", XSSFSheetHelper.toRgb(lastColor, "D00000"));
        cursor.toNextToken();
        cursor.beginElement("colorHigh", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
        cursor.insertAttributeWithValue("rgb", XSSFSheetHelper.toRgb(highColor, "D00000"));
        cursor.toNextToken();
        cursor.beginElement("colorLow", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
        cursor.insertAttributeWithValue("rgb", XSSFSheetHelper.toRgb(lowColor, "D00000"));
        cursor.toNextToken();
        cursor.beginElement("sparklines", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
        cursor.toChild(0);
        cursor.beginElement("sparkline", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
        cursor.toChild(0);
        cursor.beginElement("f", "http://schemas.microsoft.com/office/excel/2006/main");
        cursor.insertChars(valuesFormula);
        cursor.toNextToken();
        cursor.beginElement("sqref", "http://schemas.microsoft.com/office/excel/2006/main");
        cursor.insertChars(anchor);
        cursor.dispose();
    }

    public static void addConditionalFormattingToExtensionList(XSSFSheet sheet, ConditionalFormatting cf, Map<CTCfRule, String> extRuleIdMap) {
        XmlCursor cursor;
        CTExtensionList extLst = sheet.worksheet.getExtLst();
        if (extLst == null) {
            extLst = sheet.worksheet.addNewExtLst();
        }
        String conditionalFormattingsExtUri = "{78C0D931-6437-407d-A8EE-F0AAD7539E65}";
        List extList = extLst.getExtList();
        CTExtension conditionalFormattingsExt = null;
        for (CTExtension ext : extList) {
            if (!"{78C0D931-6437-407d-A8EE-F0AAD7539E65}".equals(ext.getUri())) continue;
            conditionalFormattingsExt = ext;
            break;
        }
        String x14NS = "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main";
        String xmNS = "http://schemas.microsoft.com/office/excel/2006/main";
        if (conditionalFormattingsExt == null) {
            conditionalFormattingsExt = extLst.addNewExt();
            cursor = conditionalFormattingsExt.newCursor();
            cursor.toNextToken();
            cursor.insertNamespace("x14", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
            cursor.insertAttributeWithValue("uri", "{78C0D931-6437-407d-A8EE-F0AAD7539E65}");
        } else {
            cursor = conditionalFormattingsExt.newCursor();
        }
        String conditionalFormattingsTag = "conditionalFormattings";
        if (!cursor.toChild("http://schemas.microsoft.com/office/spreadsheetml/2009/9/main", "conditionalFormattings")) {
            cursor.toChild(0);
            cursor.beginElement("conditionalFormattings", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
        }
        cursor.toChild(0);
        cursor.beginElement("conditionalFormatting", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
        cursor.insertNamespace("xm", "http://schemas.microsoft.com/office/excel/2006/main");
        XSSFConditionalFormatting xssfConditionalFormatting = (XSSFConditionalFormatting)cf;
        List cfRuleList = xssfConditionalFormatting.getCTConditionalFormatting().getCfRuleList();
        for (CTCfRule cfRule : cfRuleList) {
            cursor.toChild(0);
            cursor.beginElement("cfRule", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
            cursor.insertAttributeWithValue("id", extRuleIdMap.remove(cfRule));
            cursor.insertAttributeWithValue("priority", String.valueOf(cfRule.getPriority()));
            cursor.insertAttributeWithValue("type", String.valueOf(cfRule.getType()));
            cursor.toChild(0);
            cursor.insertElementWithText("f", "http://schemas.microsoft.com/office/excel/2006/main", (String)cfRule.getFormulaList().get(0));
            if (cfRule.getDxfId() > 0L) {
                cursor.beginElement("dxf", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
                XmlCursor dxfXmlCursor = sheet.getWorkbook().getStylesSource().getDxfAt(Math.toIntExact(cfRule.getDxfId())).newCursor();
                dxfXmlCursor.copyXmlContents(cursor);
                cursor.toNextToken();
            }
            cursor.toNextToken();
        }
        cursor.beginElement("sqref", "http://schemas.microsoft.com/office/excel/2006/main");
        cursor.insertChars(String.valueOf(xssfConditionalFormatting.getCTConditionalFormatting().getSqref().get(0)));
        cursor.dispose();
    }

    public static SheetProtection getOrCreateSheetProtection(XSSFSheet sheet) {
        XSSFSheetHelper.createProtectionFieldIfNotPresent(sheet);
        return new XSSFSheetProtection(sheet.worksheet.getSheetProtection());
    }

    private static void createProtectionFieldIfNotPresent(XSSFSheet sheet) {
        if (sheet.worksheet.getSheetProtection() == null) {
            CTSheetProtection sheetProtection = (CTSheetProtection)CTSheetProtection.Factory.newInstance();
            sheetProtection.setObjects(true);
            sheetProtection.setScenarios(true);
            sheet.worksheet.setSheetProtection(sheetProtection);
        }
    }

    public static void setPrintHeadings(XSSFSheet sheet, boolean value) {
        CTPrintOptions opts = sheet.worksheet.isSetPrintOptions() ? sheet.worksheet.getPrintOptions() : sheet.worksheet.addNewPrintOptions();
        opts.setHeadings(value);
    }

    public static void protectSheet(XSSFSheet sheet, String password) {
        if (password != null) {
            XSSFSheetHelper.createProtectionFieldIfNotPresent(sheet);
            CTSheetProtection sheetProtection = sheet.worksheet.getSheetProtection();
            if (!password.isEmpty()) {
                sheet.setSheetPassword(password, null);
            }
            sheetProtection.setSheet(true);
            if (sheetProtection.isSetScenarios() && !sheetProtection.getScenarios()) {
                sheetProtection.unsetScenarios();
            }
            if (sheetProtection.isSetObjects() && !sheetProtection.getObjects()) {
                sheetProtection.unsetObjects();
            }
        } else {
            CTSheetProtection sheetProtection = sheet.worksheet.getSheetProtection();
            if (sheetProtection != null) {
                if (sheetProtection.isSetScenarios()) {
                    sheetProtection.unsetScenarios();
                }
                if (sheetProtection.isSetObjects()) {
                    sheetProtection.unsetObjects();
                }
                if (XSSFSheetHelper.isEmptySheetProtection(sheet)) {
                    sheet.worksheet.unsetSheetProtection();
                }
            }
        }
    }

    public static CTAutoFilter getCTAutoFilter(XSSFSheet sheet) {
        return sheet.worksheet.getAutoFilter();
    }

    private static String toRgb(String hex, String nullAs) {
        return "FF" + (hex != null ? hex.substring(1) : nullAs);
    }

    private static QName getAttrName(String name) {
        return new QName(name);
    }
}

