/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.NamedStyle;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.model.ThemesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFCellStyleHelper;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellStyles;

public class XSSFNamedStyle
implements NamedStyle {
    private String name;
    private int _cellStyleXfId;
    private int _builtinId;
    private XSSFCellStyle _inner;
    private CTCellStyle _cellStyle;
    private boolean _custom;

    public XSSFNamedStyle(String name, boolean custom, int builtinId, int xfId, StylesTable stylesSource, ThemesTable theme) {
        this.name = name;
        this._cellStyleXfId = xfId;
        this._builtinId = builtinId;
        CTCellStyles cellStyles = stylesSource.getCTStylesheet().getCellStyles();
        this._cellStyle = cellStyles != null ? (CTCellStyle)cellStyles.getCellStyleList().stream().filter(ct -> ct.getName().equals(name)).findFirst().orElse(null) : null;
        this._custom = custom;
        if (this._cellStyle == null) {
            this._cellStyle = (CTCellStyle)CTCellStyle.Factory.newInstance();
            this._cellStyle.setName(name);
            this._cellStyle.setXfId((long)xfId);
            if (custom) {
                this._cellStyle.setCustomBuiltin(true);
            }
            if (builtinId >= 0) {
                this._cellStyle.setBuiltinId((long)builtinId);
            }
        }
        this._inner = XSSFCellStyleHelper.create(-1, xfId, stylesSource, theme);
    }

    public CTCellStyle getCellStyle() {
        return this._cellStyle;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isCustomBuiltin() {
        return this._builtinId >= 0;
    }

    @Override
    public int getBuiltinId() {
        return this._builtinId;
    }

    @Override
    public short getIndex() {
        return (short)this._cellStyleXfId;
    }

    @Override
    public void setDataFormat(short fmt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getDataFormat() {
        return this._inner.getDataFormat();
    }

    @Override
    public String getDataFormatString() {
        return this._inner.getDataFormatString();
    }

    @Override
    public void setFont(Font font) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFontIndex() {
        return this._inner.getFontIndex();
    }

    @Override
    public int getFontIndexAsInt() {
        return 0;
    }

    @Override
    public void setHidden(boolean hidden) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getHidden() {
        return this._inner.getHidden();
    }

    @Override
    public void setLocked(boolean locked) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getLocked() {
        return this._inner.getLocked();
    }

    @Override
    public void setQuotePrefixed(boolean quotePrefix) {
    }

    @Override
    public boolean getQuotePrefixed() {
        return false;
    }

    @Override
    public void setAlignment(HorizontalAlignment align) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HorizontalAlignment getAlignment() {
        return this._inner.getAlignment();
    }

    @Override
    public void setWrapText(boolean wrapped) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getWrapText() {
        return this._inner.getWrapText();
    }

    @Override
    public void setVerticalAlignment(VerticalAlignment align) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VerticalAlignment getVerticalAlignment() {
        return this._inner.getVerticalAlignment();
    }

    @Override
    public void setRotation(short rotation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getRotation() {
        return this._inner.getRotation();
    }

    @Override
    public void setIndention(short indent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getIndention() {
        return this._inner.getIndention();
    }

    @Override
    public void setBorderLeft(BorderStyle border) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BorderStyle getBorderLeft() {
        return this._inner.getBorderLeft();
    }

    @Override
    public void setBorderRight(BorderStyle border) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BorderStyle getBorderRight() {
        return this._inner.getBorderRight();
    }

    @Override
    public void setBorderTop(BorderStyle border) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BorderStyle getBorderTop() {
        return this._inner.getBorderTop();
    }

    @Override
    public void setBorderBottom(BorderStyle border) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BorderStyle getBorderBottom() {
        return this._inner.getBorderBottom();
    }

    @Override
    public void setLeftBorderColor(short color) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getLeftBorderColor() {
        return this._inner.getLeftBorderColor();
    }

    @Override
    public void setRightBorderColor(short color) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getRightBorderColor() {
        return this._inner.getRightBorderColor();
    }

    @Override
    public void setTopBorderColor(short color) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getTopBorderColor() {
        return this._inner.getTopBorderColor();
    }

    @Override
    public void setBottomBorderColor(short color) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getBottomBorderColor() {
        return this._inner.getBottomBorderColor();
    }

    @Override
    public void setFillPattern(FillPatternType fp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FillPatternType getFillPattern() {
        return this._inner.getFillPattern();
    }

    @Override
    public void setFillBackgroundColor(short bg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFillBackgroundColor(Color color) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getFillBackgroundColor() {
        return this._inner.getFillBackgroundColor();
    }

    @Override
    public Color getFillBackgroundColorColor() {
        return this._inner.getFillBackgroundColorColor();
    }

    @Override
    public void setFillForegroundColor(short bg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFillForegroundColor(Color color) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getFillForegroundColor() {
        return this._inner.getFillForegroundColor();
    }

    @Override
    public Color getFillForegroundColorColor() {
        return this._inner.getFillForegroundColorColor();
    }

    @Override
    public void cloneStyleFrom(CellStyle source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setShrinkToFit(boolean shrinkToFit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getShrinkToFit() {
        return this._inner.getShrinkToFit();
    }
}

