/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.lang.reflect.Field;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.model.ThemesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;

public class XSSFCellStyleHelper {
    public static XSSFCellStyle create(int cellXfId, int cellStyleXfId, StylesTable stylesSource, ThemesTable theme) {
        if (cellXfId == -1) {
            XSSFCellStyle cellStyle = new XSSFCellStyle(stylesSource);
            Field cellStyleXfField = null;
            try {
                cellStyleXfField = cellStyle.getClass().getDeclaredField("_cellStyleXf");
                cellStyleXfField.setAccessible(true);
                cellStyleXfField.set(cellStyle, stylesSource.getCellStyleXfAt(cellStyleXfId));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (cellStyleXfField != null) {
                    cellStyleXfField.setAccessible(false);
                }
            }
            return cellStyle;
        }
        return new XSSFCellStyle(cellXfId, cellStyleXfId, stylesSource, theme);
    }
}

