/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.model;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.TableStyle;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFTableStyle;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTStylesheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableStyles;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXf;

public class StylesTableHelper {
    public static void addTableStyle(StylesTable stylesSource, XSSFTableStyle tbStyle) {
        StylesTableHelper.getTableStyles(stylesSource).put(tbStyle.getName(), (TableStyle)tbStyle);
    }

    public static TableStyle createTableStyle(StylesTable stylesSource, String name) {
        CTStylesheet ctStylesheet = stylesSource.getCTStylesheet();
        if (!ctStylesheet.isSetTableStyles()) {
            ctStylesheet.addNewTableStyles();
        }
        if (!ctStylesheet.isSetDxfs()) {
            ctStylesheet.addNewDxfs();
        }
        CTTableStyles ctTableStyles = ctStylesheet.getTableStyles();
        CTTableStyle ctTableStyle = ctTableStyles.addNewTableStyle();
        ctTableStyle.setName(name);
        XSSFTableStyle tbStyle = new XSSFTableStyle(ctTableStyles.sizeOfTableStyleArray() - 1, ctStylesheet.getDxfs(), ctTableStyle, null);
        StylesTableHelper.addTableStyle(stylesSource, tbStyle);
        return tbStyle;
    }

    public static List<XSSFFont> getFonts(StylesTable stylesSource) {
        Field fontsField = null;
        try {
            fontsField = stylesSource.getClass().getDeclaredField("fonts");
            fontsField.setAccessible(true);
            List list = (List)fontsField.get(stylesSource);
            return list;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fontsField != null) {
                fontsField.setAccessible(false);
            }
        }
    }

    public static Map<Short, String> getNumberFormats(StylesTable stylesSource) {
        Field numberformatsField = null;
        try {
            numberformatsField = stylesSource.getClass().getDeclaredField("numberFormats");
            numberformatsField.setAccessible(true);
            Map map = (Map)numberformatsField.get(stylesSource);
            return map;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (numberformatsField != null) {
                numberformatsField.setAccessible(false);
            }
        }
    }

    public static List<XSSFCellBorder> getBorders(StylesTable stylesSource) {
        Field bordersField = null;
        try {
            bordersField = stylesSource.getClass().getDeclaredField("borders");
            bordersField.setAccessible(true);
            List list = (List)bordersField.get(stylesSource);
            return list;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (bordersField != null) {
                bordersField.setAccessible(false);
            }
        }
    }

    public static List<XSSFCellFill> getFills(StylesTable stylesSource) {
        Field fillsField = null;
        try {
            fillsField = stylesSource.getClass().getDeclaredField("fills");
            fillsField.setAccessible(true);
            List list = (List)fillsField.get(stylesSource);
            return list;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fillsField != null) {
                fillsField.setAccessible(false);
            }
        }
    }

    public static List<CTXf> getCellStyleXfs(StylesTable stylesSource) {
        Field styleXfsField = null;
        try {
            styleXfsField = stylesSource.getClass().getDeclaredField("styleXfs");
            styleXfsField.setAccessible(true);
            List list = (List)styleXfsField.get(stylesSource);
            return list;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (styleXfsField != null) {
                styleXfsField.setAccessible(false);
            }
        }
    }

    public static List<CTXf> getCellStyleDxfs(StylesTable stylesSource) {
        Field styleDXfsField = null;
        try {
            styleDXfsField = stylesSource.getClass().getDeclaredField("dxfs");
            styleDXfsField.setAccessible(true);
            List list = (List)styleDXfsField.get(stylesSource);
            return list;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (styleDXfsField != null) {
                styleDXfsField.setAccessible(false);
            }
        }
    }

    public static List<CTXf> getCellXfs(StylesTable stylesSource) {
        Field xfsField = null;
        try {
            xfsField = stylesSource.getClass().getDeclaredField("xfs");
            xfsField.setAccessible(true);
            List list = (List)xfsField.get(stylesSource);
            return list;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (xfsField != null) {
                xfsField.setAccessible(false);
            }
        }
    }

    public static Map<String, TableStyle> getTableStyles(StylesTable stylesSource) {
        Field tableStylesField = null;
        try {
            tableStylesField = stylesSource.getClass().getDeclaredField("tableStyles");
            tableStylesField.setAccessible(true);
            Map map = (Map)tableStylesField.get(stylesSource);
            return map;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (tableStylesField != null) {
                tableStylesField.setAccessible(false);
            }
        }
    }

    public static void setDefaultPivotStyle(StylesTable stylesSource, String defaultPivotStyle) {
    }

    public static void setDefaultTableStyle(String defaultTableStyle) {
    }
}

