/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.token;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.formula.FormulaTokenParser;
import org.apache.poi.ss.formula.token.BracketNode;
import org.apache.poi.ss.formula.token.ExternalRefNode;
import org.apache.poi.ss.formula.token.FormulaTokenNode;
import org.apache.poi.ss.formula.token.NameNode;
import org.apache.poi.ss.formula.token.NodeId;
import org.apache.poi.ss.formula.token.TokenNodeVisitor;

public abstract class OpNode
implements FormulaTokenNode {
    protected FormulaTokenNode left;
    protected FormulaTokenNode right;

    public FormulaTokenNode getLeft() {
        return this.left;
    }

    public FormulaTokenNode getRight() {
        return this.right;
    }

    public boolean setLeftOp(FormulaTokenNode left) {
        this.left = left;
        return true;
    }

    public boolean setRightOp(FormulaTokenNode right) {
        this.right = right;
        return true;
    }

    public abstract int getFlag();

    public abstract String getOp();

    @Override
    public int getType() {
        return 64;
    }

    @Override
    public boolean hasOperands() {
        return this.left != null && this.right != null;
    }

    @Override
    public boolean isOp() {
        return true;
    }

    @Override
    public boolean add(FormulaTokenNode child) {
        this.right = child;
        return true;
    }

    @Override
    public FormulaTokenNode normalize(FormulaTokenParser parser) {
        if (this.left == null) {
            throw new FormulaParseException("Formula contains the operator '" + this.getOp() + "' not followed by an operand");
        }
        this.left = this.left.normalize(parser);
        this.right = this.right.normalize(parser);
        return this;
    }

    @Override
    public <R> List<R> visitChildren(TokenNodeVisitor<R> visitor) {
        ArrayList<R> list = new ArrayList<R>(2);
        list.add(this.left.accept(visitor));
        list.add(this.right.accept(visitor));
        return list;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.left != null) {
            sb.append(this.left);
        }
        sb.append(this.getOp());
        if (this.right != null) {
            sb.append(this.right);
        }
        return sb.toString();
    }

    public static ExternalRefNode toExternalRef(FormulaTokenNode node) {
        String tableName;
        StringBuilder sb = new StringBuilder();
        if (node == null) {
            return null;
        }
        switch (node.getNodeId()) {
            case BracketNode: {
                BracketNode bracketNode = (BracketNode)node;
                FormulaTokenNode itemNode = bracketNode.getLeft();
                if (itemNode != null) {
                    sb.append(itemNode);
                }
                sb.append('[');
                itemNode = bracketNode.getChild();
                if (itemNode != null) {
                    sb.append(itemNode);
                }
                sb.append(']');
                itemNode = bracketNode.getRight();
                if (itemNode == null) {
                    tableName = sb.toString();
                    break;
                }
                if (itemNode.getNodeId() == NodeId.ColonNode) {
                    sb.append(((OpNode)itemNode).getLeft());
                    sb.append(':');
                    sb.append(((OpNode)itemNode).getRight());
                    tableName = sb.toString();
                    break;
                }
                sb.append(itemNode);
                tableName = sb.toString();
                break;
            }
            case NameNode: {
                NameNode nameNode = (NameNode)node;
                String tableName2 = nameNode.getValue();
                return new ExternalRefNode(tableName2, nameNode.isSingleQuote());
            }
            case ColonNode: {
                sb.append(((OpNode)node).getLeft());
                sb.append(':');
                sb.append(((OpNode)node).getRight());
                tableName = sb.toString();
                break;
            }
            default: {
                tableName = node.toString();
            }
        }
        return new ExternalRefNode(tableName);
    }
}

