/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.ptg;

import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.ptg.RefPtgBase;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

abstract class Ref2DPtgBase
extends RefPtgBase {
    private static final int SIZE = 5;
    private static final int SIZE_2007 = 7;

    protected Ref2DPtgBase(int row, int column, boolean isRowRelative, boolean isColumnRelative) {
        this.setRow(row);
        this.setColumn(column);
        this.setRowRelative(isRowRelative);
        this.setColRelative(isColumnRelative);
    }

    protected Ref2DPtgBase(Ref2DPtgBase other) {
        super(other);
    }

    protected Ref2DPtgBase(LittleEndianInput in) {
        this.readCoordinates(in, SpreadsheetVersion.EXCEL97);
    }

    protected Ref2DPtgBase(LittleEndianInput in, SpreadsheetVersion version) {
        this.readCoordinates(in, version);
    }

    protected Ref2DPtgBase(CellReference cr) {
        super(cr);
    }

    @Override
    public void write(LittleEndianOutput out, SpreadsheetVersion version) {
        out.writeByte(this.getSid() + this.getPtgClass());
        this.writeCoordinates(out, version);
    }

    @Override
    public final String toFormulaString() {
        return this.formatReferenceAsString();
    }

    @Override
    public final int getSize(SpreadsheetVersion version) {
        return version == SpreadsheetVersion.EXCEL2007 ? 7 : 5;
    }
}

