/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.ptg;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.ptg.ControlPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public final class Parenthesis2Ptg
extends ControlPtg {
    private static final int SIZE = 3;
    public static final byte sid = 26;
    private final int _numOperands;

    public Parenthesis2Ptg(LittleEndianInput in) {
        this._numOperands = in.readUShort();
    }

    public Parenthesis2Ptg(int operands) {
        this._numOperands = operands;
    }

    @Override
    public void write(LittleEndianOutput out, SpreadsheetVersion version) {
        out.writeByte(26 + this.getPtgClass());
        out.writeShort(this._numOperands);
    }

    @Override
    public int getSize(SpreadsheetVersion version) {
        return 3;
    }

    @Override
    public String toFormulaString() {
        return "()";
    }

    @Override
    public Ptg copy() {
        return this;
    }

    @Override
    public byte getSid() {
        return 26;
    }

    public String toFormulaString(String[] operands) {
        StringBuffer sb = new StringBuffer().append("(").append(operands[0]);
        for (int j = 1; j < operands.length; ++j) {
            sb.append(",").append(operands[j]);
        }
        sb.append(")");
        return sb.toString();
    }

    public int getNumberOfOperands() {
        return this._numOperands;
    }

    @Override
    public Map<String, Supplier<?>> getGenericProperties() {
        return null;
    }
}

