/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.ptg;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import org.apache.poi.ss.formula.WorkbookDependentFormula;
import org.apache.poi.ss.formula.ptg.OperandPtg;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public final class NamePtg
extends OperandPtg
implements WorkbookDependentFormula {
    public static final short sid = 35;
    private static final int SIZE = 5;
    private int field_1_label_index;
    private short field_2_zero;
    private String namename;

    public NamePtg(int nameIndex) {
        this.field_1_label_index = 1 + nameIndex;
    }

    public NamePtg(NamePtg other) {
        super(other);
        this.field_1_label_index = other.field_1_label_index;
        this.field_2_zero = other.field_2_zero;
    }

    public NamePtg(LittleEndianInput in) {
        this.field_1_label_index = in.readUShort();
        this.field_2_zero = in.readShort();
    }

    public int getIndex() {
        return this.field_1_label_index - 1;
    }

    @Override
    public void write(LittleEndianOutput out, SpreadsheetVersion version) {
        out.writeByte(35 + this.getPtgClass());
        out.writeShort(this.field_1_label_index);
        out.writeShort(this.field_2_zero);
    }

    @Override
    public byte getSid() {
        return 35;
    }

    @Override
    public int getSize(SpreadsheetVersion version) {
        return 5;
    }

    @Override
    public String toFormulaString(FormulaRenderingWorkbook book) {
        String name;
        this.namename = name = book.getNameText(this);
        return name != null && name.startsWith("_xlfn.") ? name.substring(6) : name;
    }

    public String getNameName() {
        return this.namename;
    }

    @Override
    public String toFormulaString() {
        throw new IllegalStateException("3D references need a workbook to determine formula text");
    }

    @Override
    public byte getDefaultOperandClass() {
        return 0;
    }

    @Override
    public NamePtg copy() {
        return new NamePtg(this);
    }

    @Override
    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties("index", this::getIndex);
    }

    @Override
    public String toInternalFormulaString(FormulaRenderingWorkbook book) {
        return this.toFormulaString(book);
    }
}

