/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.ptg;

import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.ptg.ValueOperatorPtg;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public final class MultiplyPtg
extends ValueOperatorPtg {
    public static final byte sid = 5;
    public static final MultiplyPtg instance = new MultiplyPtg();
    private boolean _operator = false;

    private MultiplyPtg() {
    }

    public MultiplyPtg(LittleEndianInput in, SpreadsheetVersion version) {
        if (version == SpreadsheetVersion.EXCEL2007) {
            this._operator = in.readByte() == 1;
        }
    }

    @Override
    public byte getSid() {
        return 5;
    }

    @Override
    public int getSize(SpreadsheetVersion version) {
        int size = super.getSize(version);
        if (version == SpreadsheetVersion.EXCEL2007) {
            ++size;
        }
        return size;
    }

    @Override
    public int getNumberOfOperands() {
        return 2;
    }

    @Override
    public String toFormulaString(String[] operands) {
        return operands[0] + "*" + operands[1];
    }

    @Override
    public MultiplyPtg copy() {
        return instance;
    }

    @Override
    public void write(LittleEndianOutput out, SpreadsheetVersion version) {
        out.writeByte(this.getSid());
        if (version == SpreadsheetVersion.EXCEL2007) {
            out.writeByte(this._operator ? 1 : 0);
        }
    }

    public void setOperator(boolean b) {
        this._operator = b;
    }

    public boolean isOperator() {
        return this._operator;
    }
}

