/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import org.apache.poi.ss.formula.eval.BlankEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.MissingArgEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.ArrayFunction;
import org.apache.poi.ss.formula.functions.Function;

public final class Choose
implements Function,
ArrayFunction {
    @Override
    public ValueEval evaluate(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
        if (args.length < 2) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            int ix = Choose.evaluateFirstArg(args[0], srcRowIndex, srcColumnIndex);
            if (ix < 1 || ix >= args.length) {
                return ErrorEval.VALUE_INVALID;
            }
            ValueEval result = OperandResolver.getSingleValue(args[ix], srcRowIndex, srcColumnIndex);
            if (result == MissingArgEval.instance) {
                return BlankEval.instance;
            }
            return result;
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }

    public static int evaluateFirstArg(ValueEval arg0, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
        ValueEval ev = OperandResolver.getSingleValue(arg0, srcRowIndex, srcColumnIndex);
        return OperandResolver.coerceValueToInt(ev);
    }

    @Override
    public ValueEval evaluateArray(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
        if (args.length < 2) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            int ix = Choose.evaluateFirstArg(args[0], srcRowIndex, srcColumnIndex);
            if (ix < 1 || ix >= args.length) {
                return ErrorEval.VALUE_INVALID;
            }
            ValueEval result = this.evaluateOneArrayArg(args[ix], srcRowIndex, srcColumnIndex, valA -> valA);
            if (result == MissingArgEval.instance) {
                return BlankEval.instance;
            }
            return result;
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }
}

