/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.eval;

import org.apache.poi.ss.formula.eval.NumericValueEval;
import org.apache.poi.ss.formula.eval.StringValueEval;
import org.apache.poi.ss.usermodel.Hyperlink;

public final class BoolEval
implements NumericValueEval,
StringValueEval {
    private final boolean _value;
    public static final BoolEval FALSE = new BoolEval(false);
    public static final BoolEval TRUE = new BoolEval(true);
    private Hyperlink _hyperlink;

    public static BoolEval valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    private BoolEval(boolean value) {
        this._value = value;
    }

    public boolean getBooleanValue() {
        return this._value;
    }

    @Override
    public double getNumberValue() {
        return this._value ? 1.0 : 0.0;
    }

    @Override
    public String getStringValue() {
        return this._value ? "TRUE" : "FALSE";
    }

    public void setHyperlink(Hyperlink hyperlink) {
        this._hyperlink = hyperlink;
    }

    public Hyperlink getHyperlink() {
        return this._hyperlink;
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.getStringValue() + "]";
    }
}

