/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.util.List;
import java.util.ListIterator;
import org.apache.poi.ss.formula.FormulaType;
import org.apache.poi.ss.formula.ptg.AbstractFunctionPtg;
import org.apache.poi.ss.formula.ptg.AttrPtg;
import org.apache.poi.ss.formula.ptg.ControlPtg;
import org.apache.poi.ss.formula.ptg.FuncVarPtg;
import org.apache.poi.ss.formula.ptg.IntersectionPtg;
import org.apache.poi.ss.formula.ptg.MemAreaPtg;
import org.apache.poi.ss.formula.ptg.MemFuncPtg;
import org.apache.poi.ss.formula.ptg.OperationPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.formula.ptg.RangePtg;
import org.apache.poi.ss.formula.ptg.UnionPtg;
import org.apache.poi.ss.formula.ptg.ValueOperatorPtg;

public class TokenOperandClassTransformer {
    private final FormulaType _formulaType;
    private final ListIterator<Ptg> _cursor;

    public TokenOperandClassTransformer(FormulaType formulaType, List<Ptg> ptgs) {
        this._formulaType = formulaType;
        this._cursor = ptgs.listIterator(ptgs.size());
    }

    public void transformFormula() {
        byte rootNodeOperandClass;
        switch (this._formulaType) {
            case CELL: {
                rootNodeOperandClass = 32;
                break;
            }
            case ARRAY: {
                rootNodeOperandClass = 64;
                break;
            }
            case NAMEDRANGE: 
            case DATAVALIDATION_LIST: {
                rootNodeOperandClass = 0;
                break;
            }
            default: {
                throw new RuntimeException("Incomplete code - formula type (" + this._formulaType + ") not supported yet");
            }
        }
        this.transformNode(this._cursor, rootNodeOperandClass, false);
    }

    private void transformNode(ListIterator<Ptg> cursor, byte desiredOperandClass, boolean callerForceArrayFlag) {
        Ptg token = cursor.previous();
        boolean isSimpleValueFunc = TokenOperandClassTransformer.isSimpleValueFunction(token);
        int childrenCount = 0;
        if (isSimpleValueFunc) {
            boolean localForceArray;
            boolean bl = localForceArray = desiredOperandClass == 64;
            while (cursor.hasPrevious() && this.hasChildren(cursor, token, childrenCount)) {
                this.transformNode(cursor, desiredOperandClass, localForceArray);
                ++childrenCount;
            }
            this.setSimpleValueFuncClass((AbstractFunctionPtg)token, desiredOperandClass, callerForceArrayFlag);
            return;
        }
        if (TokenOperandClassTransformer.isSingleArgSum(token)) {
            token = FuncVarPtg.SUM;
        }
        if (token instanceof ValueOperatorPtg || token instanceof ControlPtg || token instanceof MemFuncPtg || token instanceof MemAreaPtg || token instanceof UnionPtg || token instanceof IntersectionPtg) {
            byte localDesiredOperandClass;
            byte by = localDesiredOperandClass = desiredOperandClass == 0 ? (byte)32 : (byte)desiredOperandClass;
            while (cursor.hasPrevious() && this.hasChildren(cursor, token, childrenCount)) {
                this.transformNode(cursor, localDesiredOperandClass, callerForceArrayFlag);
                ++childrenCount;
            }
            return;
        }
        if (token instanceof AbstractFunctionPtg) {
            this.transformFunctionNode((AbstractFunctionPtg)token, cursor, desiredOperandClass, callerForceArrayFlag);
            return;
        }
        if (childrenCount > 0) {
            if (token == RangePtg.instance) {
                return;
            }
            throw new IllegalStateException("Node should not have any children");
        }
        if (token.isBaseToken()) {
            return;
        }
        token.setClass(this.transformClass(token.getPtgClass(), desiredOperandClass, callerForceArrayFlag));
    }

    private static boolean isSingleArgSum(Ptg token) {
        if (token instanceof AttrPtg) {
            AttrPtg attrPtg = (AttrPtg)token;
            return attrPtg.isSum();
        }
        return false;
    }

    private static boolean isSimpleValueFunction(Ptg token) {
        if (token instanceof AbstractFunctionPtg) {
            AbstractFunctionPtg aptg = (AbstractFunctionPtg)token;
            if (aptg.getDefaultOperandClass() != 32) {
                return false;
            }
            int numberOfOperands = aptg.getNumberOfOperands();
            for (int i = numberOfOperands - 1; i >= 0; --i) {
                if (aptg.getParameterClass(i) == 32) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private byte transformClass(byte currentOperandClass, byte desiredOperandClass, boolean callerForceArrayFlag) {
        switch (desiredOperandClass) {
            case 32: {
                if (!callerForceArrayFlag) {
                    return 32;
                }
            }
            case 64: {
                return 64;
            }
            case 0: {
                if (!callerForceArrayFlag) {
                    return currentOperandClass;
                }
                return 0;
            }
        }
        throw new IllegalStateException("Unexpected operand class (" + desiredOperandClass + ")");
    }

    private void transformFunctionNode(AbstractFunctionPtg afp, ListIterator<Ptg> childCursor, byte desiredOperandClass, boolean callerForceArrayFlag) {
        boolean localForceArrayFlag;
        block24: {
            byte defaultReturnOperandClass;
            block23: {
                defaultReturnOperandClass = afp.getDefaultOperandClass();
                if (!callerForceArrayFlag) break block23;
                switch (defaultReturnOperandClass) {
                    case 0: {
                        if (desiredOperandClass == 0) {
                            afp.setClass((byte)0);
                        } else {
                            afp.setClass((byte)64);
                        }
                        localForceArrayFlag = false;
                        break block24;
                    }
                    case 64: {
                        afp.setClass((byte)64);
                        localForceArrayFlag = false;
                        break block24;
                    }
                    case 32: {
                        afp.setClass((byte)64);
                        localForceArrayFlag = true;
                        break block24;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected operand class (" + defaultReturnOperandClass + ")");
                    }
                }
            }
            if (defaultReturnOperandClass == desiredOperandClass) {
                localForceArrayFlag = false;
                afp.setClass(defaultReturnOperandClass);
            } else {
                switch (desiredOperandClass) {
                    case 32: {
                        afp.setClass((byte)32);
                        localForceArrayFlag = false;
                        break;
                    }
                    case 64: {
                        switch (defaultReturnOperandClass) {
                            case 0: {
                                afp.setClass((byte)0);
                                break;
                            }
                            case 32: {
                                afp.setClass((byte)64);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected operand class (" + defaultReturnOperandClass + ")");
                            }
                        }
                        localForceArrayFlag = defaultReturnOperandClass == 32;
                        break;
                    }
                    case 0: {
                        switch (defaultReturnOperandClass) {
                            case 64: {
                                afp.setClass((byte)64);
                                break;
                            }
                            case 32: {
                                afp.setClass((byte)32);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected operand class (" + defaultReturnOperandClass + ")");
                            }
                        }
                        localForceArrayFlag = false;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected operand class (" + desiredOperandClass + ")");
                    }
                }
            }
        }
        int childrenCount = 0;
        while (childCursor.hasPrevious() && this.hasChildren(childCursor, afp, childrenCount)) {
            byte paramOperandClass = afp.getParameterClass(childrenCount++);
            this.transformNode(childCursor, paramOperandClass, localForceArrayFlag);
        }
    }

    private boolean hasChildren(ListIterator<Ptg> cursor, Ptg current, int childrenCount) {
        if (current instanceof AttrPtg) {
            return childrenCount < ((AttrPtg)current).getNumberOfOperands();
        }
        if (current instanceof MemFuncPtg) {
            return childrenCount < ((MemFuncPtg)current).getNumberOfOperands();
        }
        if (current instanceof UnionPtg) {
            return childrenCount < ((UnionPtg)current).getNumberOfOperands();
        }
        if (current instanceof OperationPtg) {
            return childrenCount < ((OperationPtg)current).getNumberOfOperands();
        }
        return false;
    }

    private void setSimpleValueFuncClass(AbstractFunctionPtg afp, byte desiredOperandClass, boolean callerForceArrayFlag) {
        if (callerForceArrayFlag || desiredOperandClass == 64) {
            afp.setClass((byte)64);
        } else {
            afp.setClass((byte)32);
        }
    }
}

