/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class SortedValues {
    private TreeMap<Boolean, SortedNumberValue> _booleanMap;
    private TreeMap<Double, SortedNumberValue> _numberMap;
    private TreeMap<String, SortedNumberValue> _stringMap;

    void addValue(double number, int rowIndex) {
        if (this._numberMap == null) {
            this._numberMap = new TreeMap();
        }
        if (this._numberMap.containsKey(number)) {
            SortedNumberValue value = this._numberMap.get(number);
            value.add(rowIndex);
        } else {
            SortedNumberValue value = new SortedNumberValue(rowIndex);
            this._numberMap.put(number, value);
        }
    }

    void addValue(String string, int rowIndex) {
        if (this._stringMap == null) {
            this._stringMap = new TreeMap();
        }
        if (this._stringMap.containsKey(string)) {
            SortedNumberValue value = this._stringMap.get(string);
            value.add(rowIndex);
        } else {
            SortedNumberValue value = new SortedNumberValue(rowIndex);
            this._stringMap.put(string, value);
        }
    }

    void addValue(boolean key, int rowIndex) {
        if (this._booleanMap == null) {
            this._booleanMap = new TreeMap();
        }
        if (this._booleanMap.containsKey(key)) {
            SortedNumberValue value = this._booleanMap.get(key);
            value.add(rowIndex);
        } else {
            SortedNumberValue value = new SortedNumberValue(rowIndex);
            this._booleanMap.put(key, value);
        }
    }

    public int search(double key, int minValue, int maxValue) {
        return this._numberMap != null && this._numberMap.containsKey(key) ? this._numberMap.get(key).search(minValue, maxValue, true) : -1;
    }

    public int search(String key, int minValue, int maxValue) {
        return this._stringMap != null && this._stringMap.containsKey(key) ? this._stringMap.get(key).search(minValue, maxValue, true) : -1;
    }

    public int search(boolean key, int minValue, int maxValue) {
        return this._booleanMap != null && this._booleanMap.containsKey(key) ? this._booleanMap.get(key).search(minValue, maxValue, true) : -1;
    }

    private static class SortedNumberValue {
        private final int _firstValue;
        private TreeSet<Integer> _set;

        SortedNumberValue(int value) {
            this._firstValue = value;
        }

        public void add(int value) {
            if (this._set == null) {
                this._set = new TreeSet();
                this._set.add(this._firstValue);
            }
            this._set.add(value);
        }

        public int search(int min, int max, boolean ascending) {
            if (this._set == null) {
                return this._firstValue >= min && this._firstValue <= max ? this._firstValue : -1;
            }
            try {
                NavigableSet<Integer> subSet = this._set.subSet(min, true, max, true);
                if (subSet.isEmpty()) {
                    return -1;
                }
                return ascending ? (Integer)subSet.first() : (Integer)subSet.last();
            }
            catch (NullPointerException nullPointerException) {
                return -1;
            }
        }
    }
}

