/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.FormulaShifter;
import org.apache.poi.ss.formula.ptg.Area2DPtgBase;
import org.apache.poi.ss.formula.ptg.Area3DPtg;
import org.apache.poi.ss.formula.ptg.AreaPtgBase;
import org.apache.poi.ss.formula.ptg.DeletedArea3DPtg;
import org.apache.poi.ss.formula.ptg.DeletedRef3DPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.formula.ptg.Ref3DPtg;
import org.apache.poi.ss.formula.ptg.RefPtg;
import org.apache.poi.ss.formula.ptg.RefPtgBase;
import org.apache.poi.ss.formula.ptg.TablePtg;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellReference;

public class PtgShifter {
    private final int _externSheetIndex;
    private final int _firstRow;
    private final int _lastRow;
    private final int _rowAmount;
    private final int _firstCol;
    private final int _lastCol;
    private final int _colAmount;
    private final SpreadsheetVersion _ver;

    public PtgShifter(int externSheetIndex, int firstRow, int lastRow, int rowAmount, int firstCol, int lastCol, int colAmount, SpreadsheetVersion ver) {
        if (firstRow > lastRow) {
            throw new IllegalArgumentException("firstRow(" + firstRow + ") and lastRow(" + lastRow + ") out of order");
        }
        if (firstCol > lastCol) {
            throw new IllegalArgumentException("firstCol(" + firstCol + ") and lastCol(" + lastCol + ") out of order");
        }
        this._externSheetIndex = externSheetIndex;
        this._firstRow = firstRow;
        this._lastRow = lastRow;
        this._rowAmount = rowAmount;
        this._firstCol = firstCol;
        this._lastCol = lastCol;
        this._colAmount = colAmount;
        this._ver = ver;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" [");
        sb.append(this._firstRow);
        sb.append(",").append(this._lastRow);
        sb.append(",").append(this._rowAmount);
        sb.append(",").append(this._firstCol);
        sb.append(",").append(this._lastCol);
        sb.append(",").append(this._colAmount);
        return sb.toString();
    }

    public boolean adjustFormula(Ptg[] ptgs, int currentExternSheetIx) {
        if (this._rowAmount == 0 && this._colAmount == 0) {
            return false;
        }
        boolean refsWereChanged = false;
        for (int i = 0; i < ptgs.length; ++i) {
            Ptg newPtg = this.adjustPtg(ptgs[i], currentExternSheetIx);
            if (newPtg == null) continue;
            refsWereChanged = true;
            ptgs[i] = newPtg;
        }
        return refsWereChanged;
    }

    private Ptg adjustPtg(Ptg ptg, int currentExternSheetIx) {
        if (this._rowAmount == 0 && this._colAmount == 0) {
            return null;
        }
        if (ptg instanceof RefPtg) {
            if (currentExternSheetIx != this._externSheetIndex) {
                return null;
            }
            RefPtg rptg = (RefPtg)ptg;
            if (this._rowAmount != 0 && this._colAmount != 0) {
                return this.bothMoveRefPtg(rptg);
            }
            if (this._rowAmount != 0) {
                return this.rowMoveRefPtg(rptg);
            }
            return this.colMoveRefPtg(rptg);
        }
        if (ptg instanceof Ref3DPtg) {
            Ref3DPtg rptg = (Ref3DPtg)ptg;
            if (this._externSheetIndex != rptg.getExternSheetIndex()) {
                return null;
            }
            if (this._rowAmount != 0 && this._colAmount != 0) {
                return this.bothMoveRefPtg(rptg);
            }
            if (this._rowAmount != 0) {
                return this.rowMoveRefPtg(rptg);
            }
            return this.colMoveRefPtg(rptg);
        }
        if (ptg instanceof Area2DPtgBase) {
            if (currentExternSheetIx != this._externSheetIndex) {
                return null;
            }
            Area2DPtgBase aptg = (Area2DPtgBase)ptg;
            if (this._rowAmount != 0 && this._colAmount != 0) {
                return this.bothMoveAreaPtg(aptg);
            }
            if (this._rowAmount != 0) {
                return this.rowMoveAreaPtg(aptg);
            }
            return this.colMoveAreaPtg(aptg);
        }
        if (ptg instanceof Area3DPtg) {
            Area3DPtg aptg = (Area3DPtg)ptg;
            if (this._externSheetIndex != aptg.getExternSheetIndex()) {
                return null;
            }
            if (this._rowAmount != 0 && this._colAmount != 0) {
                return this.bothMoveAreaPtg(aptg);
            }
            if (this._rowAmount != 0) {
                return this.rowMoveAreaPtg(aptg);
            }
            return this.colMoveAreaPtg(aptg);
        }
        if (ptg instanceof TablePtg) {
            if (currentExternSheetIx != this._externSheetIndex) {
                return null;
            }
            TablePtg aptg = (TablePtg)ptg;
            if (this._rowAmount != 0 && this._colAmount != 0) {
                return this.bothMoveAreaPtg(aptg);
            }
            if (this._rowAmount != 0) {
                return this.rowMoveAreaPtg(aptg);
            }
            return this.colMoveAreaPtg(aptg);
        }
        return null;
    }

    private Ptg rowMoveRefPtg(RefPtgBase rptg) {
        int refCol = rptg.getColumn();
        if (this._firstCol > refCol || refCol > this._lastCol) {
            return null;
        }
        int refRow = rptg.getRow();
        if (this._firstRow <= refRow && refRow <= this._lastRow) {
            return this.rptgSetRow(rptg, refRow + this._rowAmount);
        }
        int destFirstRowIndex = this._firstRow + this._rowAmount;
        int destLastRowIndex = this._lastRow + this._rowAmount;
        if (destLastRowIndex < refRow || refRow < destFirstRowIndex) {
            return null;
        }
        if (destFirstRowIndex <= refRow && refRow <= destLastRowIndex) {
            return PtgShifter.createDeletedRef(rptg);
        }
        throw new IllegalStateException("Situation not covered: (" + this._firstRow + ", " + this._lastRow + ", " + this._rowAmount + ", " + refRow + ")");
    }

    private Ptg rowMoveAreaPtg(AreaPtgBase aptg) {
        int aFirstCol = aptg.getFirstColumn();
        int aLastCol = aptg.getLastColumn();
        if (AreaReference.isWholeColumnReference(this._ver, new CellReference(aptg.getFirstRow(), aptg.getFirstColumn(), true, true), new CellReference(aptg.getLastRow(), aptg.getLastColumn(), true, true))) {
            return null;
        }
        if (aFirstCol < this._firstCol || aLastCol > this._lastCol) {
            return null;
        }
        int aFirstRow = aptg.getFirstRow();
        int aLastRow = aptg.getLastRow();
        if (this._firstRow <= aFirstRow && aLastRow <= this._lastRow) {
            return this.aptgSetFirstLastRow(aptg, aFirstRow + this._rowAmount, aLastRow + this._rowAmount);
        }
        int destFirstRowIndex = this._firstRow + this._rowAmount;
        int destLastRowIndex = this._lastRow + this._rowAmount;
        if (aFirstRow < this._firstRow && this._lastRow < aLastRow) {
            if (destFirstRowIndex < aFirstRow && aFirstRow <= destLastRowIndex) {
                return this.aptgSetFirstRow(aptg, destLastRowIndex + 1);
            }
            if (destFirstRowIndex <= aLastRow && aLastRow < destLastRowIndex) {
                return this.aptgSetLastRow(aptg, destFirstRowIndex - 1);
            }
            return null;
        }
        if (this._firstRow <= aFirstRow && aFirstRow <= this._lastRow) {
            if (this._rowAmount < 0) {
                return this.aptgSetFirstRow(aptg, aFirstRow + this._rowAmount);
            }
            if (destFirstRowIndex > aLastRow) {
                return null;
            }
            int newFirstRowIx = aFirstRow + this._rowAmount;
            if (destLastRowIndex < aLastRow) {
                return this.aptgSetFirstRow(aptg, newFirstRowIx);
            }
            int areaRemainingTopRowIx = this._lastRow + 1;
            if (destFirstRowIndex > areaRemainingTopRowIx) {
                newFirstRowIx = areaRemainingTopRowIx;
            }
            return this.aptgSetFirstLastRow(aptg, newFirstRowIx, Math.max(aLastRow, destLastRowIndex));
        }
        if (this._firstRow <= aLastRow && aLastRow <= this._lastRow) {
            if (this._rowAmount > 0) {
                return this.aptgSetLastRow(aptg, aLastRow + this._rowAmount);
            }
            if (destLastRowIndex < aFirstRow) {
                return null;
            }
            int newLastRowIx = aLastRow + this._rowAmount;
            if (destFirstRowIndex > aFirstRow) {
                return this.aptgSetLastRow(aptg, newLastRowIx);
            }
            int areaRemainingBottomRowIx = this._firstRow - 1;
            if (destLastRowIndex < areaRemainingBottomRowIx) {
                newLastRowIx = areaRemainingBottomRowIx;
            }
            return this.aptgSetFirstLastRow(aptg, Math.min(aFirstRow, destFirstRowIndex), newLastRowIx);
        }
        if (destLastRowIndex < aFirstRow || aLastRow < destFirstRowIndex) {
            return null;
        }
        if (destFirstRowIndex <= aFirstRow && aLastRow <= destLastRowIndex) {
            return PtgShifter.createDeletedRef(aptg);
        }
        if (aFirstRow <= destFirstRowIndex && destLastRowIndex <= aLastRow) {
            return null;
        }
        if (destFirstRowIndex < aFirstRow && aFirstRow <= destLastRowIndex) {
            return this.aptgSetFirstRow(aptg, destLastRowIndex + 1);
        }
        if (destFirstRowIndex <= aLastRow && aLastRow < destLastRowIndex) {
            return this.aptgSetLastRow(aptg, destFirstRowIndex - 1);
        }
        throw new IllegalStateException("Situation not covered: (" + this._firstRow + ", " + this._lastRow + ", " + this._rowAmount + ", " + aFirstRow + ", " + aLastRow + ", " + destFirstRowIndex + ", " + destLastRowIndex + ")");
    }

    private Ptg bothMoveRefPtg(RefPtgBase rptg) {
        int refCol = rptg.getColumn();
        int refRow = rptg.getRow();
        if (this._firstRow <= refRow && refRow <= this._lastRow && this._firstCol <= refCol && refCol <= this._lastCol) {
            this.rptgSetRowCol(rptg, refRow + this._rowAmount, refCol + this._colAmount);
            return rptg;
        }
        int destFirstRowIndex = this._firstRow + this._rowAmount;
        int destLastRowIndex = this._lastRow + this._rowAmount;
        int destFirstColIndex = this._firstCol + this._colAmount;
        int destLastColIndex = this._lastCol + this._colAmount;
        if (destLastRowIndex < refRow || refRow < destFirstRowIndex || destLastColIndex < refCol || refCol < destFirstColIndex) {
            return null;
        }
        if (destFirstRowIndex <= refRow && refRow <= destLastRowIndex && destFirstColIndex <= refCol && refCol <= destLastColIndex) {
            return PtgShifter.createDeletedRef(rptg);
        }
        throw new IllegalStateException("Situation not covered: row(" + this._firstRow + ", " + this._lastRow + ", " + this._rowAmount + ", " + refRow + "), column(" + this._firstCol + ", " + this._lastCol + ", " + this._colAmount + ", " + refCol + ")");
    }

    private Ptg bothMoveAreaPtg(AreaPtgBase aptg) {
        int aFirstCol = aptg.getFirstColumn();
        int aLastCol = aptg.getLastColumn();
        int aFirstRow = aptg.getFirstRow();
        int aLastRow = aptg.getLastRow();
        if (this._firstRow <= aFirstRow && aLastRow <= this._lastRow && this._firstCol <= aFirstCol && aLastCol <= this._lastCol) {
            return this.aptgSetRowCol(aptg, aFirstRow + this._rowAmount, aFirstCol + this._colAmount, aLastRow + this._rowAmount, aLastCol + this._colAmount);
        }
        int destFirstRowIndex = this._firstRow + this._rowAmount;
        int destLastRowIndex = this._lastRow + this._rowAmount;
        int destFirstColIndex = this._firstCol + this._colAmount;
        int destLastColIndex = this._lastCol + this._colAmount;
        if (destLastRowIndex < aFirstRow || aLastRow < destFirstRowIndex || destLastColIndex < aFirstCol || aLastCol < destFirstColIndex) {
            return null;
        }
        if (destFirstRowIndex <= aFirstRow && aLastRow <= destLastRowIndex && destFirstColIndex <= aFirstCol && aLastCol <= destLastColIndex) {
            return PtgShifter.createDeletedRef(aptg);
        }
        if (aFirstRow <= destFirstRowIndex && destLastRowIndex <= aLastRow || aFirstCol <= destFirstColIndex && destLastColIndex <= aLastCol) {
            return null;
        }
        if (destFirstColIndex <= aFirstCol && aLastCol <= destLastColIndex) {
            if (destFirstRowIndex < aFirstRow && aFirstRow <= destLastRowIndex) {
                return this.aptgSetFirstRow(aptg, destLastRowIndex + 1);
            }
            if (destFirstRowIndex < aLastRow && aLastRow <= destLastRowIndex) {
                return this.aptgSetLastRow(aptg, destFirstRowIndex - 1);
            }
        }
        if (destFirstRowIndex <= aFirstRow && aLastRow <= destLastRowIndex) {
            if (destFirstColIndex < aFirstCol && aFirstCol <= destLastColIndex) {
                return this.aptgSetFirstCol(aptg, destLastColIndex + 1);
            }
            if (destFirstColIndex < aLastCol && aLastCol <= destLastColIndex) {
                return this.aptgSetLastCol(aptg, destFirstColIndex - 1);
            }
        }
        return null;
    }

    public static Ptg createDeletedRef(Ptg ptg) {
        return FormulaShifter.createDeletedRef(ptg);
    }

    private Ptg colMoveRefPtg(RefPtgBase rptg) {
        int refRow = rptg.getRow();
        if (this._firstRow > refRow || refRow > this._lastRow) {
            return null;
        }
        int refCol = rptg.getColumn();
        if (this._firstCol <= refCol && refCol <= this._lastCol) {
            return this.rptgSetCol(rptg, refCol + this._colAmount);
        }
        int destFirstColIndex = this._firstCol + this._colAmount;
        int destLastColIndex = this._lastCol + this._colAmount;
        if (destLastColIndex < refCol || refCol < destFirstColIndex) {
            return null;
        }
        if (destFirstColIndex <= refCol && refCol <= destLastColIndex) {
            return PtgShifter.createDeletedRef(rptg);
        }
        throw new IllegalStateException("Situation not covered: (" + this._firstCol + ", " + this._lastCol + ", " + this._colAmount + ", " + refCol + ")");
    }

    private Ptg colMoveAreaPtg(AreaPtgBase aptg) {
        int aFirstRow = aptg.getFirstRow();
        int aLastRow = aptg.getLastRow();
        if (AreaReference.isWholeRowReference(this._ver, new CellReference(aptg.getFirstRow(), aptg.getFirstColumn(), true, true), new CellReference(aptg.getLastRow(), aptg.getLastColumn(), true, true))) {
            return null;
        }
        if (aFirstRow < this._firstRow || aLastRow > this._lastRow) {
            return null;
        }
        int aFirstCol = aptg.getFirstColumn();
        int aLastCol = aptg.getLastColumn();
        if (this._firstCol <= aFirstCol && aLastCol <= this._lastCol) {
            return this.aptgSetFirstLastCol(aptg, aFirstCol + this._colAmount, aLastCol + this._colAmount);
        }
        int destFirstColIndex = this._firstCol + this._colAmount;
        int destLastColIndex = this._lastCol + this._colAmount;
        if (aFirstCol < this._firstCol && this._lastCol < aLastCol) {
            if (destFirstColIndex < aFirstCol && aFirstCol <= destLastColIndex) {
                return this.aptgSetFirstCol(aptg, destLastColIndex + 1);
            }
            if (destFirstColIndex <= aLastCol && aLastCol < destLastColIndex) {
                return this.aptgSetLastCol(aptg, destFirstColIndex - 1);
            }
            return null;
        }
        if (this._firstCol <= aFirstCol && aFirstCol <= this._lastCol) {
            if (this._colAmount < 0) {
                return this.aptgSetFirstCol(aptg, aFirstCol + this._colAmount);
            }
            if (destFirstColIndex > aLastCol) {
                return null;
            }
            int newFirstColIx = aFirstCol + this._colAmount;
            if (destLastColIndex < aLastCol) {
                return this.aptgSetFirstCol(aptg, newFirstColIx);
            }
            int areaRemainingTopColIx = this._lastCol + 1;
            if (destFirstColIndex > areaRemainingTopColIx) {
                newFirstColIx = areaRemainingTopColIx;
            }
            return this.aptgSetFirstLastCol(aptg, newFirstColIx, Math.max(aLastCol, destLastColIndex));
        }
        if (this._firstCol <= aLastCol && aLastCol <= this._lastCol) {
            if (this._colAmount > 0) {
                return this.aptgSetLastCol(aptg, aLastCol + this._colAmount);
            }
            if (destLastColIndex < aFirstCol) {
                return null;
            }
            int newLastColIx = aLastCol + this._colAmount;
            if (destFirstColIndex > aFirstCol) {
                return this.aptgSetLastCol(aptg, newLastColIx);
            }
            int areaRemainingBottomColIx = this._firstCol - 1;
            if (destLastColIndex < areaRemainingBottomColIx) {
                newLastColIx = areaRemainingBottomColIx;
            }
            return this.aptgSetFirstLastCol(aptg, Math.min(aFirstCol, destFirstColIndex), newLastColIx);
        }
        if (destLastColIndex < aFirstCol || aLastCol < destFirstColIndex) {
            return null;
        }
        if (destFirstColIndex <= aFirstCol && aLastCol <= destLastColIndex) {
            return PtgShifter.createDeletedRef(aptg);
        }
        if (aFirstCol <= destFirstColIndex && destLastColIndex <= aLastCol) {
            return null;
        }
        if (destFirstColIndex < aFirstCol && aFirstCol <= destLastColIndex) {
            return this.aptgSetFirstCol(aptg, destLastColIndex + 1);
        }
        if (destFirstColIndex <= aLastCol && aLastCol < destLastColIndex) {
            return this.aptgSetLastCol(aptg, destFirstColIndex - 1);
        }
        throw new IllegalStateException("Situation not covered: (" + this._firstCol + ", " + this._lastRow + ", " + this._colAmount + ", " + aFirstCol + ", " + aLastCol + ", " + destFirstColIndex + ", " + destLastColIndex + ")");
    }

    private Ptg rptgSetRow(RefPtgBase rptg, int rowNum) {
        if (rowNum > this._ver.getLastRowIndex() || rowNum < 0) {
            return PtgShifter.createDeletedRef(rptg);
        }
        rptg.setRow(rowNum);
        return rptg;
    }

    private Ptg rptgSetCol(RefPtgBase rptg, int colNum) {
        if (colNum > this._ver.getLastColumnIndex() || colNum < 0) {
            return PtgShifter.createDeletedRef(rptg);
        }
        rptg.setColumn(colNum);
        return rptg;
    }

    private Ptg rptgSetRowCol(RefPtgBase rptg, int rowNum, int colNum) {
        if (rowNum > this._ver.getLastRowIndex() || rowNum < 0) {
            return PtgShifter.createDeletedRef(rptg);
        }
        rptg.setRow(rowNum);
        if (colNum > this._ver.getLastColumnIndex() || colNum < 0) {
            return PtgShifter.createDeletedRef(rptg);
        }
        rptg.setColumn(colNum);
        return rptg;
    }

    private Ptg aptgSetFirstRow(AreaPtgBase aptg, int rowNum) {
        if (rowNum > this._ver.getLastRowIndex()) {
            return PtgShifter.createDeletedRef(aptg);
        }
        if (rowNum < 0) {
            aptg.setFirstRow(0);
        } else {
            aptg.setFirstRow(rowNum);
        }
        return aptg;
    }

    private Ptg aptgSetFirstCol(AreaPtgBase aptg, int colNum) {
        if (colNum > this._ver.getLastColumnIndex()) {
            return PtgShifter.createDeletedRef(aptg);
        }
        if (colNum < 0) {
            aptg.setFirstColumn(0);
        } else {
            aptg.setFirstColumn(colNum);
        }
        return aptg;
    }

    private Ptg aptgSetLastRow(AreaPtgBase aptg, int rowNum) {
        if (rowNum < 0) {
            return PtgShifter.createDeletedRef(aptg);
        }
        if (rowNum > this._ver.getLastRowIndex()) {
            aptg.setLastRow(this._ver.getLastRowIndex());
        } else {
            aptg.setLastRow(rowNum);
        }
        return aptg;
    }

    private Ptg aptgSetLastCol(AreaPtgBase aptg, int colNum) {
        if (colNum < 0) {
            return PtgShifter.createDeletedRef(aptg);
        }
        if (colNum > this._ver.getLastColumnIndex()) {
            aptg.setLastColumn(this._ver.getLastColumnIndex());
        } else {
            aptg.setLastColumn(colNum);
        }
        return aptg;
    }

    private Ptg aptgSetFirstLastRow(AreaPtgBase aptg, int firstRow, int lastRow) {
        if (firstRow > this._ver.getLastRowIndex()) {
            return PtgShifter.createDeletedRef(aptg);
        }
        if (firstRow < 0) {
            aptg.setFirstRow(0);
        } else {
            aptg.setFirstRow(firstRow);
        }
        if (lastRow < 0) {
            return PtgShifter.createDeletedRef(aptg);
        }
        if (lastRow > this._ver.getLastRowIndex()) {
            aptg.setLastRow(this._ver.getLastRowIndex());
        } else {
            aptg.setLastRow(lastRow);
        }
        return aptg;
    }

    private Ptg aptgSetFirstLastCol(AreaPtgBase aptg, int firstCol, int lastCol) {
        if (firstCol > this._ver.getLastColumnIndex()) {
            return PtgShifter.createDeletedRef(aptg);
        }
        if (firstCol < 0) {
            aptg.setFirstColumn(0);
        } else {
            aptg.setFirstColumn(firstCol);
        }
        if (lastCol < 0) {
            return PtgShifter.createDeletedRef(aptg);
        }
        if (lastCol > this._ver.getLastColumnIndex()) {
            aptg.setLastColumn(this._ver.getLastColumnIndex());
        } else {
            aptg.setLastColumn(lastCol);
        }
        return aptg;
    }

    private Ptg aptgSetRowCol(AreaPtgBase aptg, int firstRow, int firstCol, int lastRow, int lastCol) {
        if (firstCol > this._ver.getLastColumnIndex()) {
            return PtgShifter.createDeletedRef(aptg);
        }
        if (firstCol < 0) {
            aptg.setFirstColumn(0);
        } else {
            aptg.setFirstColumn(firstCol);
        }
        if (lastCol < 0) {
            return PtgShifter.createDeletedRef(aptg);
        }
        if (lastCol > this._ver.getLastColumnIndex()) {
            aptg.setLastColumn(this._ver.getLastColumnIndex());
        } else {
            aptg.setLastColumn(lastCol);
        }
        if (firstRow > this._ver.getLastRowIndex()) {
            return PtgShifter.createDeletedRef(aptg);
        }
        if (firstRow < 0) {
            aptg.setFirstRow(0);
        } else {
            aptg.setFirstRow(firstRow);
        }
        if (lastRow < 0) {
            return PtgShifter.createDeletedRef(aptg);
        }
        if (lastRow > this._ver.getLastRowIndex()) {
            aptg.setLastRow(this._ver.getLastRowIndex());
        } else {
            aptg.setLastRow(lastRow);
        }
        return aptg;
    }

    public static Ptg createDeletedRef3d(String bookName, Ptg ptg) {
        if (ptg instanceof Ref3DPtg) {
            Ref3DPtg rptg = (Ref3DPtg)ptg;
            return new DeletedRef3DPtg(rptg.getExternSheetIndex(), rptg, bookName);
        }
        if (ptg instanceof Area3DPtg) {
            Area3DPtg area3DPtg = (Area3DPtg)ptg;
            return new DeletedArea3DPtg(area3DPtg.getExternSheetIndex(), area3DPtg, bookName);
        }
        throw new IllegalArgumentException("Unexpected ref ptg class (" + ptg.getClass().getName() + ")");
    }
}

