/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.FormulaType;
import org.apache.poi.ss.formula.TokenOperandClassTransformer;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.formula.token.AddNode;
import org.apache.poi.ss.formula.token.AndNode;
import org.apache.poi.ss.formula.token.ArrayColumnsNode;
import org.apache.poi.ss.formula.token.BracketNode;
import org.apache.poi.ss.formula.token.ColonOpNode;
import org.apache.poi.ss.formula.token.CommaNode;
import org.apache.poi.ss.formula.token.DivNode;
import org.apache.poi.ss.formula.token.DoubleNode;
import org.apache.poi.ss.formula.token.EmptyNode;
import org.apache.poi.ss.formula.token.EqualNode;
import org.apache.poi.ss.formula.token.ErrorNode;
import org.apache.poi.ss.formula.token.ExclamationNode;
import org.apache.poi.ss.formula.token.ExpNode;
import org.apache.poi.ss.formula.token.FormulaTokenNode;
import org.apache.poi.ss.formula.token.FunctionNode;
import org.apache.poi.ss.formula.token.GreatNode;
import org.apache.poi.ss.formula.token.GreaterThanEqualNode;
import org.apache.poi.ss.formula.token.IntegerNode;
import org.apache.poi.ss.formula.token.LessNode;
import org.apache.poi.ss.formula.token.LessThanEqualNode;
import org.apache.poi.ss.formula.token.MinusNode;
import org.apache.poi.ss.formula.token.MultiNode;
import org.apache.poi.ss.formula.token.NameNode;
import org.apache.poi.ss.formula.token.NodeId;
import org.apache.poi.ss.formula.token.NotEqualNode;
import org.apache.poi.ss.formula.token.NumberNode;
import org.apache.poi.ss.formula.token.OpNode;
import org.apache.poi.ss.formula.token.PercentNode;
import org.apache.poi.ss.formula.token.PlusNode;
import org.apache.poi.ss.formula.token.SingleChildNode;
import org.apache.poi.ss.formula.token.SpaceNode;
import org.apache.poi.ss.formula.token.StringNode;
import org.apache.poi.ss.formula.token.SubtractNode;
import org.apache.poi.ss.formula.token.TokenToPtgVisitor;
import org.apache.poi.ss.formula.token.UnionNode;

public class FormulaTokenParser {
    public static final int MAX_ROWS = 0x100000;
    public static final int MAX_COLS = 16384;
    private int _anIntFlag = 0;
    private int _readIndex = 0;
    private int _startIndex = 0;
    private boolean _a1Notation = true;
    private boolean _inStringContent = false;
    private boolean _isNumber = false;
    private boolean _negative;
    private double _aNumber = -1.0;
    private int _exponentDigit = -1;
    private double _doubleDigit = -1.0;
    private StringBuilder _stringBuilder;
    private final LinkedList<FormulaTokenNode> _stack = new LinkedList();
    private final char commaSeparator;
    private final char rowSeparator;
    private final char columnSeparator;
    private final char decimalSeparator;
    private int _colIndex = 0;
    private int _rowIndex = 0;
    private int _fractionalPos;
    private char[] chars;
    private Map<String, Integer> structureRefKeywords;

    public FormulaTokenParser() {
        this('.');
    }

    public FormulaTokenParser(char decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
        this.commaSeparator = (char)(decimalSeparator == ',' ? 59 : 44);
        this.columnSeparator = (char)(decimalSeparator == ',' ? 92 : 44);
        this.rowSeparator = (char)(decimalSeparator == ';' ? 92 : 59);
    }

    public FormulaTokenParser(Locale locale) {
        this(FormulaTokenParser.getDecimalSeparatorFromLocale(locale));
    }

    private static char getDecimalSeparatorFromLocale(Locale locale) {
        NumberFormat format;
        char decimalSeparator = '.';
        if (locale != null && (format = NumberFormat.getInstance(locale)) instanceof DecimalFormat) {
            decimalSeparator = ((DecimalFormat)format).getDecimalFormatSymbols().getDecimalSeparator();
        }
        return decimalSeparator;
    }

    public boolean isA1Notation() {
        return this._a1Notation;
    }

    public char[] getChars() {
        return (char[])this.chars.clone();
    }

    public int getColIndex() {
        return this._colIndex;
    }

    public int getRowIndex() {
        return this._rowIndex;
    }

    public int isValidStructureRef(String key) {
        Integer value;
        if (this.structureRefKeywords == null) {
            this.structureRefKeywords = new HashMap<String, Integer>();
            this.structureRefKeywords.put("#All", 1);
            this.structureRefKeywords.put("#Headers", 2);
            this.structureRefKeywords.put("#Data", 4);
            this.structureRefKeywords.put("#Totals", 8);
            this.structureRefKeywords.put("#This Row", 16);
        }
        if ((value = this.structureRefKeywords.get(key)) == null) {
            throw new FormulaParseException("Invalid table item specifier: " + key);
        }
        return value;
    }

    public static Ptg[] parse(String formula, FormulaParsingWorkbook book, int sheetIndex, FormulaType formulaType) {
        return FormulaTokenParser.parse(formula, book, sheetIndex, null, -1, -1, formulaType);
    }

    public static Ptg[] parse(String formula, FormulaParsingWorkbook book, int sheetIndex, Locale locale, int rowIndex, int colIndex, FormulaType formulaType) {
        FormulaTokenParser formulaTokenParser = new FormulaTokenParser(locale);
        FormulaTokenNode parsed = formulaTokenParser.parse(formula);
        TokenToPtgVisitor visitor = new TokenToPtgVisitor(book, sheetIndex, rowIndex, colIndex);
        List<Ptg> list = parsed.accept(visitor);
        new TokenOperandClassTransformer(formulaType, list).transformFormula();
        Ptg[] ptgs = new Ptg[list.size()];
        int i = 0;
        for (Ptg ptg : list) {
            ptgs[i++] = ptg;
        }
        return ptgs;
    }

    public FormulaTokenNode parse(String input) {
        FormulaTokenNode tokenNode;
        if (input != null && input.length() != 0 && (tokenNode = this._parseToken(input)) != null) {
            return tokenNode.normalize(this);
        }
        return EmptyNode.getInstance();
    }

    /*
     * Unable to fully structure code
     */
    private FormulaTokenNode _parseToken(String input) {
        this._inStringContent = false;
        this._stack.clear();
        this.resetNumeral();
        leftDoubleQuote = false;
        singleQuote = false;
        leftBracket = false;
        leftCurlyBrace = false;
        leftParenCount = 0;
        this.chars = input.toCharArray();
        this._startIndex = 0;
        this._readIndex = 0;
        while (this._readIndex < this.chars.length) {
            switch (this.chars[this._readIndex]) {
                case '\n': 
                case '\r': {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftDoubleQuote || leftBracket) break;
                    this.toTokenInfo();
                    break;
                }
                case ' ': {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftDoubleQuote || leftBracket) break;
                    this.toTokenInfo();
                    if (this._stack.size() <= 0 || this._stack.peekFirst().getNodeId() == NodeId.SpaceNode) break;
                    this._stack.addFirst(new SpaceNode());
                    break;
                }
                case '!': {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftDoubleQuote || leftBracket) break;
                    this.toTokenInfo();
                    if (this._stack.isEmpty()) {
                        if (this._anIntFlag != 2) {
                            throw new FormulaParseException("Invalid '!'");
                        }
                        this._stack.addFirst(EmptyNode.getInstance());
                    }
                    this._stack.addFirst(new ExclamationNode());
                    break;
                }
                case '\"': {
                    if (leftDoubleQuote) {
                        ++this._readIndex;
                        if (this._readIndex < this.chars.length && this.chars[this._readIndex] == '\"') {
                            this._appendString();
                            break;
                        }
                        leftDoubleQuote = false;
                        if (this._inStringContent) {
                            if (this._stringBuilder.length() > 255) {
                                throw new FormulaParseException("String can't exceed 255 characters");
                            }
                            secondNode = new StringNode(this._stringBuilder.toString());
                            this._inStringContent = false;
                        } else {
                            if (this._readIndex - this._startIndex > 256) {
                                throw new FormulaParseException("String can't exceed 255 characters");
                            }
                            secondNode = new StringNode(String.valueOf(this.chars, this._startIndex, this._readIndex - this._startIndex - 1));
                        }
                        this._stack.addFirst(secondNode);
                        --this._readIndex;
                        this._startIndex = this._startIndex;
                        break;
                    }
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftBracket) break;
                    if (this._startIndex != this._readIndex) {
                        throw new FormulaParseException("Invalid '\"'");
                    }
                    ++this._startIndex;
                    leftDoubleQuote = true;
                    break;
                }
                case '#': {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftDoubleQuote || leftBracket) break;
                    if (this._startIndex != this._readIndex) {
                        throw new FormulaParseException("Invalid '#'");
                    }
                    if (this._readIndex + 4 > this.chars.length) {
                        throw new FormulaParseException("Invalid '#'");
                    }
                    if (!this._isErrorType()) {
                        return null;
                    }
                    --this._readIndex;
                    this._startIndex = this._startIndex;
                    break;
                }
                case '%': {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftDoubleQuote || leftBracket) break;
                    this.toTokenInfo();
                    tempNode = this.parseFormula(3);
                    if (tempNode == null) {
                        throw new FormulaParseException("Missing operand for '%'");
                    }
                    node = new PercentNode();
                    node.add(tempNode);
                    this._stack.addFirst(node);
                    break;
                }
                case '&': {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftDoubleQuote || leftBracket) break;
                    this.toTokenInfo();
                    this._stack.addFirst(new AndNode());
                    break;
                }
                case '\'': {
                    if (singleQuote) {
                        ++this._readIndex;
                        if (this._readIndex != this.chars.length) {
                            if (this.chars[this._readIndex] == '\'') {
                                this._appendString();
                                break;
                            }
                            if (this.chars[this._readIndex] == '!') {
                                --this._readIndex;
                                this.toTokenInfo(true);
                                singleQuote = false;
                                this._inStringContent = false;
                                ++this._readIndex;
                                ++this._startIndex;
                                this._stack.addFirst(new ExclamationNode());
                                break;
                            }
                            if (this._stack.size() == 0 || this._stack.peekFirst().getNodeId() != NodeId.ExclamationNode) {
                                throw new FormulaParseException("Invalid \"'\"");
                            }
                            --this._readIndex;
                            this.toTokenInfo(true);
                            singleQuote = false;
                            break;
                        }
                        if (this._stack.size() == 0 || this._stack.peekFirst().getNodeId() != NodeId.ExclamationNode) {
                            throw new FormulaParseException("Missing operand after \"'\"");
                        }
                        --this._readIndex;
                        this.toTokenInfo(true);
                        singleQuote = false;
                        break;
                    }
                    if (leftBracket) {
                        ++this._readIndex;
                        if (this._readIndex == this.chars.length) {
                            throw new FormulaParseException("Invalid '['");
                        }
                        switch (this.chars[this._readIndex]) {
                            case '#': 
                            case '\'': 
                            case '@': 
                            case '[': 
                            case ']': {
                                this._appendString();
                            }
                        }
                        break;
                    }
                    if (this._inStringContent) {
                        this._stringBuilder.append('\'');
                        break;
                    }
                    if (leftDoubleQuote) break;
                    singleQuote = true;
                    if (this._startIndex != this._readIndex) {
                        if (this.chars[this._readIndex - 1] != '|') {
                            throw new FormulaParseException("Invalid \"'\"");
                        }
                        this._appendString();
                        len = this._stringBuilder.length();
                        this._stringBuilder.replace(len - 1, len, "|");
                        break;
                    }
                    ++this._startIndex;
                    break;
                }
                case '(': {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftDoubleQuote || leftBracket) break;
                    ++leftParenCount;
                    if (this._startIndex < this._readIndex) {
                        this.toTokenInfo();
                    } else {
                        ++this._startIndex;
                    }
                    if (this._stack.size() != 0 && (tempNode = this._stack.peekFirst()).hasOperands()) {
                        this._stack.removeFirst();
                        if (this._stack.size() == 0) {
                            this._stack.addFirst(new FunctionNode(tempNode));
                            break;
                        }
                        if (tempNode.getNodeId() == NodeId.NameNode) {
                            nameNode = (NameNode)tempNode;
                            if (nameNode.toRefHash() == -9223372036854775808L) {
                                if ((tempNode = this.parseFormulaNow(tempNode)) == null) {
                                    return null;
                                }
                                this._stack.addFirst(new FunctionNode(tempNode));
                                break;
                            }
                        } else if (!this._a1Notation && tempNode.getNodeId() == NodeId.BracketNode && ((BracketNode)tempNode).toRefHash(this) == -9223372036854775808L) {
                            this._stack.addFirst(new FunctionNode(tempNode));
                            break;
                        }
                        if (!(node = this._stack.peekFirst()).isOp()) {
                            this._stack.addFirst(new FunctionNode(tempNode));
                            break;
                        }
                        opNode = (OpNode)node;
                        if (opNode.getFlag() > 1) {
                            this._stack.addFirst(new FunctionNode(tempNode));
                            break;
                        }
                        this._stack.removeFirst();
                        if (!opNode.setRightOp(tempNode)) {
                            return null;
                        }
                        if (this._stack.size() == 0) {
                            sb = new StringBuilder();
                            sb.append("Invalid '");
                            sb.append(opNode.getOp());
                            sb.append('\'');
                            throw new FormulaParseException(sb.toString());
                        }
                        node = this._stack.removeFirst();
                        if (!node.hasOperands()) {
                            sb = new StringBuilder();
                            sb.append("Invalid '");
                            sb.append(opNode.getOp());
                            sb.append('\'');
                            throw new FormulaParseException(sb.toString());
                        }
                        if (opNode.getFlag() > 0 && (node = this.parseFormulaNow(node)) == null) {
                            return null;
                        }
                        if (!opNode.setLeftOp(node)) {
                            return null;
                        }
                        this._stack.addFirst(new FunctionNode(opNode));
                        break;
                    }
                    this._stack.addFirst(new UnionNode());
                    break;
                }
                case ')': {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftDoubleQuote || leftBracket) break;
                    --leftParenCount;
                    this.toTokenInfo();
                    tempNode = this.parseFormula(100);
                    if (tempNode == null) {
                        return null;
                    }
                    tempNodeId = tempNode.getNodeId();
                    if (tempNodeId != NodeId.UnionNode && tempNodeId != NodeId.FunctionNode) {
                        throw new FormulaParseException("Invalid ')'");
                    }
                    this._stack.addFirst(tempNode);
                    break;
                }
                case '*': {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftDoubleQuote || leftBracket) break;
                    this.toTokenInfo();
                    this._stack.addFirst(new MultiNode());
                    break;
                }
                case '+': {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftDoubleQuote || leftBracket) break;
                    this.toTokenInfo();
                    this._stack.addFirst(new AddNode());
                    break;
                }
                case ',': {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftDoubleQuote || leftBracket) break;
                    if (this.commaSeparator != ',' && this.columnSeparator != ',') {
                        if (this.decimalSeparator == ',') {
                            this._setNumberInfo();
                            break;
                        }
                        if (this.rowSeparator == ',' && !this._lookAhead()) {
                            return null;
                        }
                        if (!this._isNumber) break;
                        this.resetNumeral();
                        break;
                    }
                    this.toTokenInfo();
                    this._stack.addFirst(new CommaNode());
                    break;
                }
                case '-': {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftDoubleQuote || leftBracket) break;
                    this.toTokenInfo();
                    this._stack.addFirst(new SubtractNode());
                    break;
                }
                case '.': {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftDoubleQuote || leftBracket) break;
                    if (this.decimalSeparator != '.') {
                        if (this.commaSeparator != '.' && this.columnSeparator != '.') {
                            if (this.rowSeparator != '.' || this._lookAhead()) break;
                            return null;
                        }
                        this.toTokenInfo();
                        this._stack.addFirst(new CommaNode());
                        break;
                    }
                    this._setNumberInfo();
                    break;
                }
                case '/': {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftDoubleQuote || leftBracket) break;
                    this.toTokenInfo();
                    this._stack.addFirst(new DivNode());
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftDoubleQuote || leftBracket) break;
                    if (!this._isNumber) {
                        if (this._startIndex < this._readIndex) break;
                        this._isNumber = true;
                    }
                    digit = this.chars[this._readIndex] - 48;
                    if (this._exponentDigit > -1) {
                        this._exponentDigit = this._exponentDigit * 10 + digit;
                        break;
                    }
                    if (this._doubleDigit > -1.0) {
                        this._doubleDigit = this._doubleDigit * 10.0 + (double)digit;
                        ++this._fractionalPos;
                        break;
                    }
                    if (this._aNumber > -1.0) {
                        this._aNumber = this._aNumber * 10.0 + (double)digit;
                        break;
                    }
                    this._aNumber = digit;
                    break;
                }
                case ':': {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftDoubleQuote || leftBracket) break;
                    this.toTokenInfo();
                    this._stack.addFirst(new ColonOpNode());
                    break;
                }
                case ';': {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftDoubleQuote || leftBracket) break;
                    if (leftCurlyBrace && this.rowSeparator == ';') {
                        if (this._lookAhead()) break;
                        return null;
                    }
                    if (this.commaSeparator != ';' && this.columnSeparator != ';') {
                        if (this.decimalSeparator == ';') {
                            this._setNumberInfo();
                            break;
                        }
                    } else {
                        this.toTokenInfo();
                        this._stack.addFirst(new CommaNode());
                    }
                    if (!this._isNumber) break;
                    this.resetNumeral();
                    break;
                }
                case '<': {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftDoubleQuote || leftBracket) break;
                    this.toTokenInfo();
                    if (this._startIndex >= this.chars.length) {
                        throw new FormulaParseException("Missing operand for '<'");
                    }
                    if (this.chars[this._startIndex] == '=') {
                        this._stack.addFirst(new LessThanEqualNode());
                        ++this._startIndex;
                        ++this._readIndex;
                        break;
                    }
                    if (this.chars[this._startIndex] == '>') {
                        this._stack.addFirst(new NotEqualNode());
                        ++this._startIndex;
                        ++this._readIndex;
                        break;
                    }
                    this._stack.addFirst(new LessNode());
                    break;
                }
                case '=': {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftDoubleQuote || leftBracket) break;
                    this.toTokenInfo();
                    this._stack.addFirst(new EqualNode());
                    break;
                }
                case '>': {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftDoubleQuote || leftBracket) break;
                    this.toTokenInfo();
                    if (this._startIndex >= this.chars.length) {
                        throw new FormulaParseException("Missing operand for '>'");
                    }
                    if (this.chars[this._startIndex] == '=') {
                        this._stack.addFirst(new GreaterThanEqualNode());
                        ++this._startIndex;
                        ++this._readIndex;
                        break;
                    }
                    this._stack.addFirst(new GreatNode());
                    break;
                }
                case 'E': 
                case 'e': {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftDoubleQuote || leftBracket || !this._isNumber) break;
                    if (this._exponentDigit > -1) {
                        this.resetNumeral();
                        break;
                    }
                    this._exponentDigit = 0;
                    ++this._readIndex;
                    if (this._readIndex == this.chars.length) {
                        this.resetNumeral();
                        break;
                    }
                    if (this.chars[this._readIndex] == '-') {
                        this._negative = true;
                        break;
                    }
                    this._negative = false;
                    if (this.chars[this._readIndex] == '+') break;
                    --this._readIndex;
                    break;
                }
                case '[': {
                    if (!singleQuote && !leftDoubleQuote) {
                        this.toTokenInfo();
                        if (this._stack.size() != 0) {
                            tempNode = this._stack.peekFirst();
                            if (tempNode.getNodeId() == NodeId.NameNode) {
                                this._stack.removeFirst();
                                if (this._stack.size() != 0 && this._stack.peekFirst().getNodeId() == NodeId.BracketNode && (bracketNode = (BracketNode)this._stack.peekFirst()).hasOperands() && bracketNode.getRight() == null) {
                                    bracketNode.setRight(tempNode);
                                    this._stack.addFirst(new BracketNode(this._stack.removeFirst()));
                                    leftBracket = true;
                                    break;
                                }
                                this._stack.addFirst(new BracketNode(tempNode));
                                leftBracket = true;
                                break;
                            }
                            if (tempNode.hasOperands() && tempNode.getNodeId() == NodeId.BracketNode) {
                                this._stack.addFirst(new BracketNode(this._stack.removeFirst()));
                                leftBracket = true;
                                break;
                            }
                        }
                        this._stack.addFirst(new BracketNode(null));
                        leftBracket = true;
                        break;
                    }
                    if (!this._inStringContent) break;
                    this._stringBuilder.append(this.chars[this._readIndex]);
                    break;
                }
                case ']': {
                    if (!singleQuote && !leftDoubleQuote) {
                        this.toTokenInfo();
                        tempNode = this.parseFormula(100);
                        if (tempNode == null) {
                            return null;
                        }
                        if (tempNode.getNodeId() != NodeId.BracketNode) {
                            throw new FormulaParseException("Invalid ']'");
                        }
                        if (!tempNode.hasOperands()) {
                            tempNode.add(EmptyNode.getInstance());
                        }
                        leftBracket = false;
                        this._stack.addFirst(tempNode);
                        break;
                    }
                    if (!this._inStringContent) break;
                    this._stringBuilder.append(this.chars[this._readIndex]);
                    break;
                }
                case '^': {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftDoubleQuote || leftBracket) break;
                    this.toTokenInfo();
                    this._stack.addFirst(new ExpNode());
                    break;
                }
                case '{': {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftDoubleQuote || leftBracket) break;
                    this.toTokenInfo();
                    this._stack.addFirst(new ArrayColumnsNode());
                    leftCurlyBrace = true;
                    break;
                }
                case '}': {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                        break;
                    }
                    if (singleQuote || leftDoubleQuote || leftBracket) break;
                    this.toTokenInfo();
                    node = this.parseFormula(100);
                    if (node == null) {
                        return null;
                    }
                    if (node.getNodeId() != NodeId.ArrayColumnsNode) {
                        throw new FormulaParseException("Invalid '}'");
                    }
                    leftCurlyBrace = false;
                    if (this._stack.size() == 0) ** GOTO lbl538
                    nodeId = this._stack.peekFirst().getNodeId();
                    if (nodeId == NodeId.SpaceNode) {
                        this._stack.removeFirst();
                    }
                    if (nodeId != NodeId.ArrayColumnsNode) ** GOTO lbl538
                    rows = new LinkedList<FormulaTokenNode>();
                    rows.push(node);
                    opNode = ((ArrayColumnsNode)node).getChildren()[0].length;
                    tempNode = this._stack.removeFirst();
                    do {
                        if (((ArrayColumnsNode)tempNode).getChildren()[0].length != opNode) {
                            throw new FormulaParseException("Invalid array data for a formula: inconsistent column size");
                        }
                        rows.push(tempNode);
                        if (this._stack.size() == 0) ** GOTO lbl532
                        tempNode = this._stack.removeFirst();
                        if (tempNode.getNodeId() != NodeId.SpaceNode) continue;
                        if (this._stack.size() == 0) ** GOTO lbl532
                        tempNode = this._stack.removeFirst();
                    } while (tempNode.getNodeId() == NodeId.ArrayColumnsNode);
                    this._stack.addFirst(tempNode);
lbl532:
                    // 3 sources

                    len = rows.size();
                    children = new FormulaTokenNode[len][];
                    for (i = 0; i < len; ++i) {
                        children[i] = ((ArrayColumnsNode)rows.pop()).getChildren()[0];
                    }
                    node = new ArrayColumnsNode(children);
lbl538:
                    // 3 sources

                    this._stack.addFirst(node);
                    break;
                }
                default: {
                    if (this._inStringContent) {
                        this._stringBuilder.append(this.chars[this._readIndex]);
                    }
                    if (!this._isNumber) break;
                    this.resetNumeral();
                }
            }
            ++this._readIndex;
        }
        if (leftParenCount != 0) {
            throw new FormulaParseException("Unclosed parenthesis");
        }
        if (!leftDoubleQuote && !singleQuote) {
            if (leftBracket) {
                throw new FormulaParseException("Invalid '['");
            }
            this.toTokenInfo();
            tempNode = this.parseFormula(111);
            if (this._stack.size() > 1) {
                throw new FormulaParseException("More than one root");
            }
            return tempNode;
        }
        throw new FormulaParseException("Unclosed quote");
    }

    private FormulaTokenNode _toggleNumber(FormulaTokenNode node, boolean minus) {
        SingleChildNode child;
        NodeId nodeId = node.getNodeId();
        if (minus) {
            if (nodeId == NodeId.DoubleNode && ((DoubleNode)node).toggleNegative()) {
                return node;
            }
            if (nodeId == NodeId.IntegerNode && ((IntegerNode)node).toggleNegative()) {
                return node;
            }
            child = new MinusNode();
        } else {
            child = new PlusNode();
        }
        child.add(node);
        return child;
    }

    Branch _mergeBranch(OpNode node, Branch branch) {
        while (node.getFlag() >= branch.leaf.getFlag()) {
            if (node.getFlag() == branch.leaf.getFlag()) {
                if (node.getNodeId() == branch.leaf.getNodeId() && node.getNodeId() == NodeId.CommaNode) {
                    if (!node.setRightOp(branch.leaf)) {
                        return null;
                    }
                    Branch nested = new Branch(branch.branch, node);
                    if (branch.branch != null && !branch.branch.leaf.setLeftOp(node)) {
                        return null;
                    }
                    branch.branch = nested;
                    return nested;
                }
                if (!node.setRightOp(branch.leaf.getLeft())) {
                    return null;
                }
                if (!branch.leaf.setLeftOp(node)) {
                    return null;
                }
                return new Branch(branch, node);
            }
            if (branch.branch == null) {
                Branch nested;
                if (!node.setRightOp(branch.leaf)) {
                    return null;
                }
                branch.branch = nested = new Branch(null, node);
                return nested;
            }
            branch = branch.branch;
        }
        if (!node.setRightOp(branch.leaf.getLeft())) {
            return null;
        }
        if (!branch.leaf.setLeftOp(node)) {
            return null;
        }
        return new Branch(branch, node);
    }

    private void _setNumberInfo() {
        if (!this._isNumber) {
            if (this._startIndex < this._readIndex) {
                return;
            }
            this._isNumber = true;
            this._aNumber = 0.0;
        }
        if (this._doubleDigit > -1.0) {
            this.resetNumeral();
        } else {
            this._doubleDigit = 0.0;
            this._fractionalPos = 0;
        }
    }

    private boolean _lookAhead() {
        this.toTokenInfo();
        FormulaTokenNode node = this.parseFormula(100);
        if (node == null) {
            return false;
        }
        if (node.getNodeId() != NodeId.ArrayColumnsNode) {
            String msg = "Invalid '#'" + this.rowSeparator + "' which has been taken as separator of array row";
            throw new FormulaParseException(msg);
        }
        this._stack.addFirst(node);
        this._stack.addFirst(new ArrayColumnsNode());
        return true;
    }

    void resetNumeral() {
        this._isNumber = false;
        this._aNumber = -1.0;
        this._doubleDigit = -1.0;
        this._fractionalPos = 0;
        this._exponentDigit = -1;
        this._negative = false;
    }

    FormulaTokenNode parseFormulaNow(FormulaTokenNode node) {
        if (this._stack.size() < 2) {
            return node;
        }
        FormulaTokenNode firstNode = this._stack.peekFirst();
        if (firstNode.getNodeId() != NodeId.ExclamationNode) {
            return node;
        }
        this._stack.removeFirst();
        OpNode opNode = (OpNode)firstNode;
        if (opNode.setRightOp(node)) {
            return null;
        }
        firstNode = this._stack.removeFirst();
        if (!firstNode.hasOperands()) {
            throw new FormulaParseException("Invalid '!'");
        }
        return !opNode.setLeftOp(firstNode) ? null : opNode;
    }

    void toTokenInfo() {
        this.toTokenInfo(false);
    }

    void toTokenInfo(boolean singleQuote) {
        if (this._isNumber) {
            NumberNode tokenNode = this._doubleDigit > 0.0 ? (this._exponentDigit > 0 ? (this._negative ? (this._exponentDigit + this._fractionalPos > 308 ? new DoubleNode(this._aNumber / Math.pow(10.0, this._exponentDigit) + this._doubleDigit / Math.pow(10.0, this._fractionalPos) / Math.pow(10.0, this._exponentDigit)) : new DoubleNode(this._aNumber / Math.pow(10.0, this._exponentDigit) + this._doubleDigit / Math.pow(10.0, this._exponentDigit + this._fractionalPos))) : (this._exponentDigit > this._fractionalPos ? (this._aNumber > 0.0 ? new DoubleNode((this._aNumber * Math.pow(10.0, this._fractionalPos) + this._doubleDigit) * Math.pow(10.0, this._exponentDigit - this._fractionalPos)) : new DoubleNode(this._aNumber * Math.pow(10.0, this._exponentDigit) + this._doubleDigit * Math.pow(10.0, this._exponentDigit - this._fractionalPos))) : (this._exponentDigit < this._fractionalPos ? new DoubleNode(this._aNumber * Math.pow(10.0, this._exponentDigit) + this._doubleDigit / Math.pow(10.0, this._fractionalPos - this._exponentDigit)) : new DoubleNode(this._aNumber * Math.pow(10.0, this._exponentDigit) + this._doubleDigit)))) : new DoubleNode(this._aNumber + this._doubleDigit / Math.pow(10.0, this._fractionalPos))) : (this._exponentDigit > 0 ? (this._negative ? new DoubleNode(this._aNumber / Math.pow(10.0, this._exponentDigit)) : new DoubleNode(this._aNumber * Math.pow(10.0, this._exponentDigit))) : (this._aNumber <= 1048577.0 ? new IntegerNode((int)this._aNumber) : new DoubleNode(this._aNumber)));
            this._stack.addFirst(tokenNode);
            this.resetNumeral();
        } else if (this._inStringContent) {
            this._stack.addFirst(new NameNode(this._startIndex, this._stringBuilder.toString(), true, singleQuote));
            this._inStringContent = false;
        } else if (this._startIndex < this._readIndex) {
            this._stack.addFirst(new NameNode(this._startIndex, String.valueOf(this.chars, this._startIndex, this._readIndex - this._startIndex), false, singleQuote));
        }
        this._startIndex = this._readIndex + 1;
    }

    private void _appendString() {
        if (this._inStringContent) {
            this._stringBuilder.append(this.chars[this._readIndex]);
        } else {
            if (this._stringBuilder == null) {
                this._stringBuilder = new StringBuilder();
            } else {
                this._stringBuilder.setLength(0);
            }
            this._inStringContent = true;
            this._stringBuilder.append(this.chars, this._startIndex, this._readIndex - this._startIndex);
        }
    }

    private boolean _isErrorType() {
        block0 : switch (this.chars[this._readIndex + 1]) {
            case 'D': 
            case 'd': {
                if (this._readIndex + 6 >= this.chars.length || (this.chars[this._readIndex + 2] | 0x20) != 105 || (this.chars[this._readIndex + 3] | 0x20) != 118 || this.chars[this._readIndex + 4] != '/' || this.chars[this._readIndex + 5] != '0' || this.chars[this._readIndex + 6] != '!') break;
                this._readIndex += 7;
                this._stack.addFirst(ErrorNode.DIV_ERROR);
                return true;
            }
            case 'N': 
            case 'n': {
                switch (this.chars[this._readIndex + 2]) {
                    case '/': {
                        if ((this.chars[this._readIndex + 3] | 0x20) != 97) break block0;
                        this._readIndex += 4;
                        this._stack.addFirst(ErrorNode.NA_ERROR);
                        return true;
                    }
                    case 'A': 
                    case 'a': {
                        if (this._readIndex + 5 >= this.chars.length || (this.chars[this._readIndex + 3] | 0x20) != 109 || (this.chars[this._readIndex + 4] | 0x20) != 101 || this.chars[this._readIndex + 5] != '?') break block0;
                        this._readIndex += 6;
                        this._stack.addFirst(ErrorNode.NAME_ERROR);
                        return true;
                    }
                    case 'U': 
                    case 'u': {
                        if (this._readIndex + 5 < this.chars.length && (this.chars[this._readIndex + 3] | 0x20) == 108 && (this.chars[this._readIndex + 4] | 0x20) == 108 && this.chars[this._readIndex + 5] == '!') {
                            this._readIndex += 6;
                            this._stack.addFirst(ErrorNode.NULL_ERROR);
                            return true;
                        }
                        if (this._readIndex + 4 >= this.chars.length || (this.chars[this._readIndex + 3] | 0x20) != 109 || this.chars[this._readIndex + 4] != '!') break block0;
                        this._readIndex += 5;
                        this._stack.addFirst(ErrorNode.NUM_ERROR);
                        return true;
                    }
                }
                break;
            }
            case 'R': 
            case 'r': {
                if (this._readIndex + 4 >= this.chars.length || (this.chars[this._readIndex + 2] | 0x20) != 101 || (this.chars[this._readIndex + 3] | 0x20) != 102 || this.chars[this._readIndex + 4] != '!') break;
                this._readIndex += 5;
                this._stack.addFirst(ErrorNode.REF_ERROR);
                return true;
            }
            case 'V': 
            case 'v': {
                if (this._readIndex + 6 >= this.chars.length || (this.chars[this._readIndex + 2] | 0x20) != 97 || (this.chars[this._readIndex + 3] | 0x20) != 108 || (this.chars[this._readIndex + 4] | 0x20) != 117 || (this.chars[this._readIndex + 5] | 0x20) != 101 || this.chars[this._readIndex + 6] != '!') break;
                this._readIndex += 7;
                this._stack.addFirst(ErrorNode.VALUE_ERROR);
                return true;
            }
        }
        throw new FormulaParseException("Invalid #");
    }

    FormulaTokenNode parseFormula(int flag) {
        if (this._stack.size() == 0) {
            StringBuilder sb = new StringBuilder();
            if (flag <= 100) {
                sb.append("Invalid '");
                sb.append(this.chars[this._readIndex]);
                sb.append("'");
            } else {
                sb.append("Formula is empty");
            }
            throw new FormulaParseException(sb.toString());
        }
        FormulaTokenNode firstNode = this._stack.removeFirst();
        if (firstNode.getNodeId() == NodeId.SpaceNode) {
            if (this._stack.size() == 0) {
                throw new FormulaParseException("Missing operand");
            }
            firstNode = this._stack.removeFirst();
        }
        if (!firstNode.hasOperands()) {
            if (firstNode.getNodeId() != NodeId.CommaNode) {
                if (flag >= 100 && firstNode.add(null)) {
                    return firstNode;
                }
                return null;
            }
            this._stack.addFirst(firstNode);
            if (((OpNode)firstNode).getFlag() > flag) {
                return null;
            }
            firstNode = EmptyNode.getInstance();
        }
        if (this._stack.size() == 0) {
            if (flag == 100) {
                String msg = "Invalid '" + this.chars[this._readIndex] + "'";
                throw new FormulaParseException(msg);
            }
            return firstNode;
        }
        FormulaTokenNode secondNode = this._stack.removeFirst();
        Branch branch = null;
        block6: while (true) {
            OpNode opNode;
            if (secondNode.isOp()) {
                opNode = (OpNode)secondNode;
                if (opNode.getFlag() > flag) {
                    this._stack.addFirst(secondNode);
                    if (branch != null) {
                        return branch.getLeaf();
                    }
                    return firstNode;
                }
                if (this._stack.size() == 0) {
                    secondNode = null;
                } else {
                    secondNode = this._stack.removeFirst();
                    if (secondNode.hasOperands()) {
                        if (!opNode.setLeftOp(secondNode)) {
                            return null;
                        }
                        if (branch == null) {
                            if (!opNode.setRightOp(firstNode)) {
                                return null;
                            }
                            branch = new Branch(null, opNode);
                        } else if ((branch = this._mergeBranch(opNode, branch)) == null) {
                            return null;
                        }
                        if (this._stack.size() == 0) {
                            return branch.getLeaf();
                        }
                        secondNode = this._stack.removeFirst();
                        continue;
                    }
                    if (secondNode.getNodeId() == NodeId.SpaceNode) {
                        secondNode = opNode;
                        continue;
                    }
                }
                switch (opNode.getNodeId()) {
                    case ExclamationNode: {
                        if (this._anIntFlag != 2) {
                            throw new FormulaParseException("Invalid reference: " + opNode);
                        }
                        if (!opNode.setLeftOp(EmptyNode.getInstance())) {
                            return null;
                        }
                        if (branch == null) {
                            if (!opNode.setRightOp(firstNode)) {
                                return null;
                            }
                            if (secondNode == null) {
                                return opNode;
                            }
                            branch = new Branch(null, opNode);
                            continue block6;
                        }
                        if ((branch = this._mergeBranch(opNode, branch)) == null) {
                            return null;
                        }
                        if (secondNode != null) continue block6;
                        return branch.getLeaf();
                    }
                    case AddNode: 
                    case SubtractNode: {
                        if (branch != null) {
                            if (branch.leaf.getFlag() < 3) {
                                do {
                                    if (branch.branch == null) {
                                        SingleChildNode singleChild = SingleChildNode.newInstance(opNode.getNodeId());
                                        singleChild.setChild(branch.leaf);
                                        if (secondNode == null) {
                                            return singleChild;
                                        }
                                        branch = null;
                                        firstNode = singleChild;
                                        continue block6;
                                    }
                                    branch = branch.branch;
                                } while (branch.leaf.getFlag() <= 2);
                                if (!branch.leaf.setLeftOp(this._toggleNumber(branch.leaf.getLeft(), opNode.getNodeId() == NodeId.SubtractNode))) {
                                    return null;
                                }
                                if (secondNode != null) continue block6;
                                return branch.getLeaf();
                            }
                            if (!branch.leaf.setLeftOp(this._toggleNumber(branch.leaf.getLeft(), opNode.getNodeId() == NodeId.SubtractNode))) {
                                return null;
                            }
                            if (secondNode != null) continue block6;
                            return branch.getLeaf();
                        }
                        firstNode = this._toggleNumber(firstNode, opNode.getNodeId() == NodeId.SubtractNode);
                        if (secondNode != null) continue block6;
                        return firstNode;
                    }
                    case SpaceNode: {
                        if (secondNode != null) continue block6;
                        if (branch != null) {
                            return branch.getLeaf();
                        }
                        return firstNode;
                    }
                    case CommaNode: {
                        if (!opNode.setLeftOp(EmptyNode.getInstance())) {
                            return null;
                        }
                        if (branch == null) {
                            if (!opNode.setRightOp(firstNode)) {
                                return null;
                            }
                            if (secondNode == null) {
                                return opNode;
                            }
                            branch = new Branch(null, opNode);
                            continue block6;
                        }
                        if ((branch = this._mergeBranch(opNode, branch)) == null) {
                            return null;
                        }
                        if (secondNode != null) continue block6;
                        return branch.getLeaf();
                    }
                }
                throw new FormulaParseException("Missing operand for '" + opNode.getOp() + "'");
            }
            if (!secondNode.hasOperands()) {
                if (flag < 100) {
                    this._stack.addFirst(secondNode);
                    if (branch != null) {
                        return branch.getLeaf();
                    }
                    return firstNode;
                }
                if (flag == 100) {
                    if (secondNode.add(branch == null ? firstNode : branch.getLeaf())) {
                        return secondNode;
                    }
                    return null;
                }
                throw new FormulaParseException("Unclosed: " + secondNode);
            }
            if (secondNode.getNodeId() == NodeId.BracketNode) {
                BracketNode bracketNode = (BracketNode)secondNode;
                if (bracketNode.getRight() != null) break;
                if (branch != null) {
                    bracketNode.setRight(branch.leaf.getLeft());
                    if (!branch.leaf.setLeftOp(bracketNode)) {
                        return null;
                    }
                    if (this._stack.size() == 0) {
                        return branch.getLeaf();
                    }
                } else {
                    bracketNode.setRight(firstNode);
                    if (this._stack.size() == 0) {
                        return bracketNode;
                    }
                    secondNode = bracketNode;
                }
                secondNode = this._stack.removeFirst();
                continue;
            }
            if (secondNode != ErrorNode.REF_ERROR) break;
            opNode = new ExclamationNode();
            if (!opNode.setLeftOp(secondNode)) {
                return null;
            }
            if (branch != null) {
                if (!opNode.setRightOp(branch.leaf.getLeft())) {
                    return null;
                }
                if (!branch.leaf.setLeftOp(opNode)) {
                    return null;
                }
                if (this._stack.size() == 0) {
                    return branch.getLeaf();
                }
            } else {
                if (!opNode.setRightOp(firstNode)) {
                    return null;
                }
                if (this._stack.size() == 0) {
                    return opNode;
                }
                secondNode = opNode;
            }
            secondNode = this._stack.removeFirst();
        }
        throw new FormulaParseException("Unrecognized: " + firstNode);
    }

    private class Branch {
        Branch branch;
        OpNode leaf;

        public Branch(Branch branch, OpNode leaf) {
            this.branch = branch;
            this.leaf = leaf;
        }

        OpNode getLeaf() {
            if (this.branch == null) {
                return this.leaf;
            }
            Branch b = this.branch;
            while (b.branch != null) {
                b = b.branch;
            }
            return b.leaf;
        }
    }
}

