/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.poi.ss.formula.CellCacheEntry;
import org.apache.poi.ss.formula.FormulaUsedBlankCellSet;
import org.apache.poi.ss.formula.IEvaluationListener;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.NumericValueEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.usermodel.ZssContext;

final class FormulaCellCacheEntry
extends CellCacheEntry {
    private CellCacheEntry[] _sensitiveInputCells;
    private FormulaUsedBlankCellSet _usedBlankCellGroup;
    private IterationInfo _iterationInfo;

    public FormulaCellCacheEntry() {
    }

    public FormulaCellCacheEntry(Object initValue) {
        this(initValue, -1.0, -1);
    }

    public FormulaCellCacheEntry(Object initValue, double maxChange, int maxCount) {
        ZssContext zssCtx = ZssContext.getCurrent();
        if (maxChange < 0.0) {
            maxChange = zssCtx.getMaxChange();
        }
        if (maxCount <= 0) {
            maxCount = zssCtx.getMaxCount();
        }
        this._iterationInfo = new IterationInfo(initValue, maxChange, maxCount);
    }

    public boolean isInputSensitive() {
        if (this._sensitiveInputCells != null && this._sensitiveInputCells.length > 0) {
            return true;
        }
        return this._usedBlankCellGroup == null ? false : !this._usedBlankCellGroup.isEmpty();
    }

    public void setSensitiveInputCells(CellCacheEntry[] sensitiveInputCells) {
        if (sensitiveInputCells == null) {
            this._sensitiveInputCells = null;
            this.changeConsumingCells(CellCacheEntry.EMPTY_ARRAY);
        } else {
            this._sensitiveInputCells = (CellCacheEntry[])sensitiveInputCells.clone();
            this.changeConsumingCells(this._sensitiveInputCells);
        }
    }

    public void clearFormulaEntry() {
        CellCacheEntry[] usedCells = this._sensitiveInputCells;
        if (usedCells != null) {
            for (int i = usedCells.length - 1; i >= 0; --i) {
                usedCells[i].clearConsumingCell(this);
            }
        }
        this._sensitiveInputCells = null;
        this.clearValue();
    }

    private void changeConsumingCells(CellCacheEntry[] usedCells) {
        Set usedSet;
        CellCacheEntry[] prevUsedCells = this._sensitiveInputCells;
        int nUsed = usedCells.length;
        for (CellCacheEntry usedCell : usedCells) {
            usedCell.addConsumingCell(this);
        }
        if (prevUsedCells == null) {
            return;
        }
        int nPrevUsed = prevUsedCells.length;
        if (nPrevUsed < 1) {
            return;
        }
        if (nUsed < 1) {
            usedSet = Collections.emptySet();
        } else {
            usedSet = new HashSet(nUsed * 3 / 2);
            usedSet.addAll(Arrays.asList(usedCells).subList(0, nUsed));
        }
        for (CellCacheEntry prevUsed : prevUsedCells) {
            if (usedSet.contains(prevUsed)) continue;
            prevUsed.clearConsumingCell(this);
        }
    }

    public void updateFormulaResult(ValueEval result, CellCacheEntry[] sensitiveInputCells, FormulaUsedBlankCellSet usedBlankAreas) {
        this.updateValue(result);
        this.setSensitiveInputCells(sensitiveInputCells);
        this._usedBlankCellGroup = usedBlankAreas;
    }

    public void notifyUpdatedBlankCell(FormulaUsedBlankCellSet.BookSheetKey bsk, int rowIndex, int columnIndex, IEvaluationListener evaluationListener) {
        if (this._usedBlankCellGroup != null && this._usedBlankCellGroup.containsCell(bsk, rowIndex, columnIndex)) {
            this.clearFormulaEntry();
            this.recurseClearCachedFormulaResults(evaluationListener);
        }
    }

    public boolean hasNext() {
        return this._iterationInfo.hasNext();
    }

    public ValueEval getIterValueEval() {
        ValueEval cceValue = this.getValue();
        return cceValue != null ? cceValue : this._iterationInfo._value;
    }

    public void clearIterationValue() {
        this._iterationInfo.clearValue();
    }

    public boolean updateAndCheckCircularIteration(ValueEval result) {
        return this._iterationInfo.updateAndCheckCircularIteration(result);
    }

    public void startIter() {
        this._iterationInfo.startIter();
    }

    public void resetIter() {
        this._iterationInfo.reset();
    }

    private static final class IterationInfo {
        private final double _maxChange;
        private final int _maxCount;
        private ValueEval _value = new NumberEval(0.0);
        private int _count = 0;
        private boolean _hasNext;

        public IterationInfo(Object initValue, double maxChange, int maxCount) {
            this._maxChange = Math.abs(maxChange);
            this._maxCount = maxCount;
            this._hasNext = false;
        }

        public boolean updateAndCheckCircularIteration(ValueEval result) {
            double prevValue;
            double thisValue;
            double diff;
            if (!this._hasNext || ++this._count >= this._maxCount || result instanceof ErrorEval) {
                this._value = result;
                return false;
            }
            if (this._count > 1 && result instanceof NumericValueEval && this._value instanceof NumericValueEval && (diff = Math.abs((thisValue = ((NumericValueEval)result).getNumberValue()) - (prevValue = ((NumericValueEval)this._value).getNumberValue()))) <= this._maxChange) {
                this._value = result;
                return false;
            }
            this._value = result;
            return true;
        }

        void startIter() {
            if (this._maxCount > 0) {
                this._hasNext = true;
            }
        }

        public boolean hasNext() {
            return this._hasNext;
        }

        void reset() {
            this._count = 0;
            this._hasNext = false;
        }

        void clearValue() {
            this._value = new NumberEval(0.0);
        }
    }
}

