/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.format;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.format.CellDateFormatter;
import org.apache.poi.ss.format.CellFormatCondition;
import org.apache.poi.ss.format.CellFormatResult;
import org.apache.poi.ss.format.CellFormatType;
import org.apache.poi.ss.format.CellFormatter;
import org.apache.poi.ss.usermodel.ZssContext;
import org.apache.poi.util.CodepointsUtil;
import org.apache.poi.util.LocaleUtil;

public class CellFormatPart {
    private static final Logger LOG;
    static final Map<String, Color> NAMED_COLORS;
    private final Color color;
    private final CellFormatCondition condition;
    private final CellFormatter format;
    private final CellFormatType type;
    private final String prefix;
    public static final Pattern COLOR_PAT;
    public static final Pattern CONDITION_PAT;
    public static final Pattern SPECIFICATION_PAT;
    public static final Pattern CURRENCY_PAT;
    public static final Pattern FORMAT_PAT;
    public static final Pattern LOCALE_PAT;
    public static final int LOCALE_GROUP;
    public static final int COLOR_GROUP;
    public static final int CONDITION_OPERATOR_GROUP;
    public static final int CONDITION_VALUE_GROUP;
    public static final int SPECIFICATION_GROUP;
    private static final Map<Integer, Locale> LOCALES;

    public CellFormatPart(String desc) {
        this(LocaleUtil.getUserLocale(), desc);
    }

    public CellFormatPart(Locale locale, String desc) {
        int j = desc.indexOf("][$");
        if (j >= 0 && desc.startsWith("[")) {
            this.prefix = desc.substring(1, j);
            desc = desc.substring(j + 1);
        } else {
            this.prefix = null;
        }
        Matcher m = FORMAT_PAT.matcher(desc);
        if (!m.matches()) {
            throw new IllegalArgumentException("Unrecognized format: " + CellFormatter.quote(desc));
        }
        Locale locale0 = CellFormatPart.getLocale(m);
        this.color = CellFormatPart.getColor(m);
        this.condition = this.getCondition(m);
        this.type = this.getCellFormatType(m);
        this.format = this.getFormatter(desc, locale0, m);
    }

    public boolean applies(Object valueObject) {
        if (this.condition == null || !(valueObject instanceof Number)) {
            if (valueObject == null) {
                throw new NullPointerException("valueObject");
            }
            return true;
        }
        Number num = (Number)valueObject;
        return this.condition.pass(num.doubleValue());
    }

    private static int findGroup(Pattern pat, String str, String marker) {
        Matcher m = pat.matcher(str);
        if (!m.find()) {
            throw new IllegalArgumentException("Pattern \"" + pat.pattern() + "\" doesn't match \"" + str + "\"");
        }
        for (int i = 1; i <= m.groupCount(); ++i) {
            String grp = m.group(i);
            if (grp == null || !grp.equals(marker)) continue;
            return i;
        }
        throw new IllegalArgumentException("\"" + marker + "\" not found in \"" + pat.pattern() + "\"");
    }

    private static Locale getLocale(Matcher m) {
        String ldesc = m.group(LOCALE_GROUP);
        return CellFormatPart.getLocale(ldesc);
    }

    private static Locale getLocale(String ldesc) {
        Locale locale = null;
        if (ldesc != null && !ldesc.isEmpty()) {
            try {
                Integer code = Integer.parseInt(ldesc, 16);
                locale = LOCALES.get(code);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return locale == null ? ZssContext.getCurrent().getLocale() : locale;
    }

    private static Color getColor(Matcher m) {
        String cdesc = m.group(COLOR_GROUP);
        if (cdesc == null || cdesc.length() == 0) {
            return null;
        }
        Color c = NAMED_COLORS.get(cdesc);
        if (c == null) {
            LOG.warn("Unknown color: {}" + CellFormatter.quote(cdesc));
        }
        return c;
    }

    private CellFormatCondition getCondition(Matcher m) {
        String mdesc = m.group(CONDITION_OPERATOR_GROUP);
        if (mdesc == null || mdesc.length() == 0) {
            return null;
        }
        return CellFormatCondition.getInstance(m.group(CONDITION_OPERATOR_GROUP), m.group(CONDITION_VALUE_GROUP));
    }

    private CellFormatType getCellFormatType(Matcher matcher) {
        String fdesc = matcher.group(SPECIFICATION_GROUP);
        return this.formatType(fdesc);
    }

    private CellFormatter getFormatter(String desc, Locale locale, Matcher matcher) {
        if (this.type == CellFormatType.NUMBER) {
            Matcher colorM;
            Matcher currencyM = CURRENCY_PAT.matcher(desc);
            if (currencyM.find()) {
                String currencyPart = currencyM.group(1);
                String currencyRepl = currencyPart.startsWith("[$-") ? "$" : (!currencyPart.contains("-") ? currencyPart.substring(2, currencyPart.indexOf("]")) : currencyPart.substring(2, currencyPart.lastIndexOf(45)));
                desc = desc.replace(currencyPart, currencyRepl);
            }
            if ((colorM = COLOR_PAT.matcher(desc)).find()) {
                String colorPart = colorM.group(0);
                desc = desc.replace(colorPart, "");
            }
        } else if (this.type == CellFormatType.DATE) {
            desc = matcher.group(SPECIFICATION_GROUP);
        }
        Matcher conditionalM = CONDITION_PAT.matcher(desc);
        if (conditionalM.find()) {
            String conditionalPart = conditionalM.group(0);
            desc = desc.replace("[" + conditionalPart + "]", "");
        }
        return this.type.formatter(locale, desc);
    }

    private CellFormatType formatType(String fdesc) {
        if ((fdesc = fdesc.trim()).isEmpty() || fdesc.equalsIgnoreCase("General")) {
            return CellFormatType.GENERAL;
        }
        Matcher m = SPECIFICATION_PAT.matcher(fdesc);
        boolean couldBeDate = false;
        boolean seenZero = false;
        while (m.find()) {
            String c1;
            String repl = m.group(0);
            Iterator<String> codePoints = CodepointsUtil.iteratorFor(repl);
            if (!codePoints.hasNext()) continue;
            switch (c1 = codePoints.next()) {
                case "@": {
                    return CellFormatType.TEXT;
                }
                case "d": 
                case "D": 
                case "y": 
                case "Y": {
                    return CellFormatType.DATE;
                }
                case "h": 
                case "H": 
                case "m": 
                case "M": 
                case "s": 
                case "S": {
                    couldBeDate = true;
                    break;
                }
                case "0": {
                    seenZero = true;
                    break;
                }
                case "[": {
                    String c2 = null;
                    if (codePoints.hasNext()) {
                        c2 = codePoints.next().toLowerCase(Locale.ROOT);
                    }
                    if ("h".equals(c2) || "m".equals(c2) || "s".equals(c2)) {
                        return CellFormatType.ELAPSED;
                    }
                    if ("$".equals(c2)) {
                        return CellFormatType.NUMBER;
                    }
                    throw new IllegalArgumentException("Unsupported [] format block '" + repl + "' in '" + fdesc + "' with c2: " + c2);
                }
                case "#": 
                case "?": {
                    return CellFormatType.NUMBER;
                }
            }
        }
        if (couldBeDate) {
            return CellFormatType.DATE;
        }
        if (seenZero) {
            return CellFormatType.NUMBER;
        }
        return CellFormatType.TEXT;
    }

    static String quoteSpecial(String repl, CellFormatType type) {
        StringBuilder sb = new StringBuilder();
        PrimitiveIterator.OfInt codePoints = CodepointsUtil.primitiveIterator(repl);
        while (codePoints.hasNext()) {
            int codepoint = codePoints.nextInt();
            if (codepoint == 39 && type.isSpecial('\'')) {
                sb.append('\u0000');
                continue;
            }
            char[] chars = Character.toChars(codepoint);
            boolean special = type.isSpecial(chars[0]);
            if (special) {
                sb.append('\'');
            }
            sb.append(chars);
            if (!special) continue;
            sb.append('\'');
        }
        return sb.toString();
    }

    public CellFormatResult apply(Object value) {
        Color textColor;
        String text;
        boolean applies = this.applies(value);
        if (applies) {
            text = this.format.format(value);
            textColor = this.color;
        } else {
            text = this.format.simpleFormat(value);
            textColor = null;
        }
        return new CellFormatResult(applies, text, textColor);
    }

    public CellFormatResult apply(JLabel label, Object value) {
        CellFormatResult result = this.apply(value);
        label.setText(result.text);
        if (result.textColor != null) {
            label.setForeground(result.textColor);
        }
        return result;
    }

    CellFormatType getCellFormatType() {
        return this.type;
    }

    boolean hasCondition() {
        return this.condition != null;
    }

    public static StringBuffer parseFormat(String fdesc, CellFormatType type, PartHandler partHandler) {
        Matcher m = SPECIFICATION_PAT.matcher(fdesc);
        StringBuffer fmt = new StringBuffer();
        while (m.find()) {
            String part = CellFormatPart.group(m, 0);
            if (part.length() <= 0) continue;
            String repl = partHandler.handlePart(m, part, type, fmt);
            if (repl == null) {
                switch (part.charAt(0)) {
                    case '\"': {
                        repl = CellFormatPart.quoteSpecial(part.substring(1, part.length() - 1), type);
                        break;
                    }
                    case '\\': {
                        repl = CellFormatPart.quoteSpecial(part.substring(1), type);
                        break;
                    }
                    case '_': {
                        repl = " ";
                        break;
                    }
                    case '*': {
                        repl = "";
                        break;
                    }
                    default: {
                        repl = CellFormatType.DATE.equals((Object)type) ? CellFormatPart.quoteSpecial(part, type) : part;
                    }
                }
            }
            m.appendReplacement(fmt, Matcher.quoteReplacement(repl));
        }
        m.appendTail(fmt);
        if (type.isSpecial('\'')) {
            CellDateFormatter.DatePartHandler datePartHandler;
            int pos = 0;
            while ((pos = fmt.indexOf("''", pos)) >= 0) {
                fmt.delete(pos, pos + 2);
                if (!(partHandler instanceof CellDateFormatter.DatePartHandler)) continue;
                datePartHandler = (CellDateFormatter.DatePartHandler)partHandler;
                datePartHandler.updatePositions(pos, -2);
            }
            pos = 0;
            while ((pos = fmt.indexOf("\u0000", pos)) >= 0) {
                fmt.replace(pos, pos + 1, "''");
                if (!(partHandler instanceof CellDateFormatter.DatePartHandler)) continue;
                datePartHandler = (CellDateFormatter.DatePartHandler)partHandler;
                datePartHandler.updatePositions(pos, 1);
            }
        }
        return fmt;
    }

    static String expandChar(String part) {
        Integer c1;
        PrimitiveIterator.OfInt iterator = CodepointsUtil.primitiveIterator(part);
        Integer c0 = iterator.hasNext() ? iterator.next() : null;
        Integer n = c1 = iterator.hasNext() ? iterator.next() : null;
        if (c0 == null || c1 == null) {
            throw new IllegalArgumentException("Expected part string to have at least 2 chars");
        }
        char[] ch = Character.toChars(c1);
        StringBuilder sb = new StringBuilder(ch.length * 3);
        sb.append(ch);
        sb.append(ch);
        sb.append(ch);
        return sb.toString();
    }

    public static String group(Matcher m, int g) {
        String str = m.group(g);
        return str == null ? "" : str;
    }

    public String toString() {
        return this.format.format;
    }

    protected void setSectionFourTextFormat(boolean sectionFour) {
        this.format.setSectionFourTextFormat(sectionFour);
    }

    static {
        Object color2;
        LOG = LogManager.getLogger(CellFormatPart.class);
        NAMED_COLORS = new TreeMap<String, Color>(String.CASE_INSENSITIVE_ORDER);
        for (Object color2 : HSSFColor.HSSFColorPredefined.values()) {
            String name = color2.name();
            short[] rgb = color2.getTriplet();
            Color c = new Color(rgb[0], rgb[1], rgb[2]);
            NAMED_COLORS.put(name, c);
            if (name.indexOf(95) > 0) {
                NAMED_COLORS.put(name.replace('_', ' '), c);
            }
            if (name.indexOf("_PERCENT") <= 0) continue;
            NAMED_COLORS.put(name.replace("_PERCENT", "%").replace('_', ' '), c);
        }
        String locale = "(_.)*\\[\\$([^-]*)(\\-[0-9a-z]{1,8})?\\-([0-9A-Z]{1,8})\\]";
        String condition = "([<>=]=?|!=|<>)    # The operator\n  \\s*(-?([0-9]+(?:\\.[0-9]*)?)|(\\.[0-9]*))\\s*  # The constant to test against\n";
        String currency = "(\\[\\$.{0,3}(-[0-9a-f]{3,4})?])";
        color2 = "\\s*\\[(black|blue|cyan|green|magenta|red|white|yellow|color [0-9]+)\\]";
        String part = "\\\\.                     # Quoted single character\n|\"([^\\\\\"]|\\\\.)*\"         # Quoted string of characters (handles escaped quotes like \\\") \n|" + currency + "                   # Currency symbol in a given locale\n|_.                             # Space as wide as a given character\n|\\*.                           # Repeating fill character\n|@                              # Text: cell text\n|([0?\\#][0?\\#,]*)             # Number: digit + other digits and commas\n|e[-+]                          # Number: Scientific: Exponent\n|m{1,5}                         # Date: month or minute spec\n|d{1,4}                         # Date: day/date spec\n|y{2,4}                         # Date: year spec\n|h{1,2}                         # Date: hour spec\n|s{1,2}                         # Date: second spec\n|am?/pm?                        # Date: am/pm spec\n|\\[h{1,2}]                     # Elapsed time: hour spec\n|\\[m{1,2}]                     # Elapsed time: minute spec\n|\\[s{1,2}]                     # Elapsed time: second spec\n|[^;]                           # A character\n";
        String format = "(?:" + locale + ")?     # locale code\n(?:" + (String)color2 + ")?                 # Text color\n(?:\\[" + condition + "])?               # Condition\n(?:\\[\\$-[0-9a-fA-F]+])?                # Optional locale id, ignored currently\n((?:" + part + ")+)                        # Format spec\n";
        int flags = 6;
        LOCALE_PAT = Pattern.compile(locale, flags);
        COLOR_PAT = Pattern.compile((String)color2, flags);
        CONDITION_PAT = Pattern.compile(condition, flags);
        SPECIFICATION_PAT = Pattern.compile(part, flags);
        CURRENCY_PAT = Pattern.compile(currency, flags);
        FORMAT_PAT = Pattern.compile(format, flags);
        LOCALE_GROUP = CellFormatPart.findGroup(FORMAT_PAT, "[$-409]@", "409");
        COLOR_GROUP = CellFormatPart.findGroup(FORMAT_PAT, "[Blue]@", "Blue");
        CONDITION_OPERATOR_GROUP = CellFormatPart.findGroup(FORMAT_PAT, "[>=1]@", ">=");
        CONDITION_VALUE_GROUP = CellFormatPart.findGroup(FORMAT_PAT, "[>=1]@", "1");
        SPECIFICATION_GROUP = CellFormatPart.findGroup(FORMAT_PAT, "[Blue][>1]\\a ?", "\\a ?");
        LOCALES = new HashMap<Integer, Locale>();
        LOCALES.put(1078, new Locale("af"));
        LOCALES.put(1102, new Locale("am"));
        LOCALES.put(14337, new Locale("ar", "AE"));
        LOCALES.put(15361, new Locale("ar", "BH"));
        LOCALES.put(5121, new Locale("ar", "DZ"));
        LOCALES.put(3073, new Locale("ar", "EG"));
        LOCALES.put(2049, new Locale("ar", "IQ"));
        LOCALES.put(11265, new Locale("ar", "JO"));
        LOCALES.put(13313, new Locale("ar", "KW"));
        LOCALES.put(12289, new Locale("ar", "LB"));
        LOCALES.put(4097, new Locale("ar", "LY"));
        LOCALES.put(6145, new Locale("ar", "MA"));
        LOCALES.put(8193, new Locale("ar", "OM"));
        LOCALES.put(16385, new Locale("ar", "QA"));
        LOCALES.put(1025, new Locale("ar", "SA"));
        LOCALES.put(10241, new Locale("ar", "SY"));
        LOCALES.put(7169, new Locale("ar", "TN"));
        LOCALES.put(9217, new Locale("ar", "YE"));
        LOCALES.put(1101, new Locale("as"));
        LOCALES.put(2092, new Locale("az", "AZ", "Cyrl"));
        LOCALES.put(1068, new Locale("az", "AX", "Latn"));
        LOCALES.put(1059, new Locale("be"));
        LOCALES.put(1026, new Locale("bg"));
        LOCALES.put(2117, new Locale("bn", "BD"));
        LOCALES.put(1093, new Locale("bn", "IN"));
        LOCALES.put(1105, new Locale("bo"));
        LOCALES.put(5146, new Locale("bs"));
        LOCALES.put(1027, new Locale("ca"));
        LOCALES.put(1029, new Locale("cs"));
        LOCALES.put(1106, new Locale("cy"));
        LOCALES.put(1030, new Locale("da"));
        LOCALES.put(3079, new Locale("de", "AT"));
        LOCALES.put(2055, new Locale("de", "CH"));
        LOCALES.put(1031, new Locale("de", "DE"));
        LOCALES.put(5127, new Locale("de", "LI"));
        LOCALES.put(4103, new Locale("de", "LU"));
        LOCALES.put(1125, new Locale("dv"));
        LOCALES.put(1032, new Locale("el"));
        LOCALES.put(3081, new Locale("en", "AU"));
        LOCALES.put(10249, new Locale("en", "BZ"));
        LOCALES.put(4105, new Locale("en", "CA"));
        LOCALES.put(9225, new Locale("en", "CB"));
        LOCALES.put(2057, new Locale("en", "GB"));
        LOCALES.put(6153, new Locale("en", "IE"));
        LOCALES.put(16393, new Locale("en", "IN"));
        LOCALES.put(8201, new Locale("en", "JM"));
        LOCALES.put(5129, new Locale("en", "NZ"));
        LOCALES.put(13321, new Locale("en", "PH"));
        LOCALES.put(11273, new Locale("en", "TT"));
        LOCALES.put(1033, new Locale("en", "US"));
        LOCALES.put(7177, new Locale("en", "ZA"));
        LOCALES.put(11274, new Locale("es", "AR"));
        LOCALES.put(16394, new Locale("es", "BO"));
        LOCALES.put(13322, new Locale("es", "CL"));
        LOCALES.put(9226, new Locale("es", "CO"));
        LOCALES.put(5130, new Locale("es", "CR"));
        LOCALES.put(7178, new Locale("es", "DO"));
        LOCALES.put(12298, new Locale("es", "EC"));
        LOCALES.put(1034, new Locale("es", "ES"));
        LOCALES.put(4106, new Locale("es", "GT"));
        LOCALES.put(18442, new Locale("es", "HN"));
        LOCALES.put(2058, new Locale("es", "MX"));
        LOCALES.put(19466, new Locale("es", "NI"));
        LOCALES.put(6154, new Locale("es", "PA"));
        LOCALES.put(10250, new Locale("es", "PE"));
        LOCALES.put(20490, new Locale("es", "PR"));
        LOCALES.put(15370, new Locale("es", "PY"));
        LOCALES.put(17418, new Locale("es", "SV"));
        LOCALES.put(14346, new Locale("es", "UY"));
        LOCALES.put(8202, new Locale("es", "VE"));
        LOCALES.put(1061, new Locale("et"));
        LOCALES.put(1069, new Locale("eu"));
        LOCALES.put(1065, new Locale("fa"));
        LOCALES.put(1035, new Locale("fi"));
        LOCALES.put(1080, new Locale("fo"));
        LOCALES.put(2060, new Locale("fr", "BE"));
        LOCALES.put(3084, new Locale("fr", "CA"));
        LOCALES.put(4108, new Locale("fr", "CH"));
        LOCALES.put(1036, new Locale("fr", "FR"));
        LOCALES.put(5132, new Locale("fr", "LU"));
        LOCALES.put(1084, new Locale("gd"));
        LOCALES.put(2108, new Locale("gd", "IE"));
        LOCALES.put(1140, new Locale("gn"));
        LOCALES.put(1095, new Locale("gu"));
        LOCALES.put(1037, new Locale("he"));
        LOCALES.put(1081, new Locale("hi"));
        LOCALES.put(1050, new Locale("hr"));
        LOCALES.put(1038, new Locale("hu"));
        LOCALES.put(1067, new Locale("hy"));
        LOCALES.put(1057, new Locale("id"));
        LOCALES.put(1039, new Locale("is"));
        LOCALES.put(2064, new Locale("it", "CH"));
        LOCALES.put(1040, new Locale("it", "IT"));
        LOCALES.put(1041, new Locale("ja"));
        LOCALES.put(1087, new Locale("kk"));
        LOCALES.put(1107, new Locale("km"));
        LOCALES.put(1099, new Locale("kn"));
        LOCALES.put(1042, new Locale("ko"));
        LOCALES.put(1120, new Locale("ks"));
        LOCALES.put(1142, new Locale("la"));
        LOCALES.put(1108, new Locale("lo"));
        LOCALES.put(1063, new Locale("lt"));
        LOCALES.put(1062, new Locale("lv"));
        LOCALES.put(1153, new Locale("mi"));
        LOCALES.put(1071, new Locale("mk"));
        LOCALES.put(1100, new Locale("ml"));
        LOCALES.put(2128, new Locale("mn"));
        LOCALES.put(1104, new Locale("mn"));
        LOCALES.put(1102, new Locale("mr"));
        LOCALES.put(2110, new Locale("ms", "BN"));
        LOCALES.put(1086, new Locale("ms", "MY"));
        LOCALES.put(1082, new Locale("mt"));
        LOCALES.put(1109, new Locale("my"));
        LOCALES.put(1121, new Locale("ne"));
        LOCALES.put(2067, new Locale("nl", "BE"));
        LOCALES.put(1043, new Locale("nl", "NL"));
        LOCALES.put(2068, new Locale("no", "NO"));
        LOCALES.put(1044, new Locale("no"));
        LOCALES.put(1096, new Locale("or"));
        LOCALES.put(1094, new Locale("pa"));
        LOCALES.put(1045, new Locale("pl"));
        LOCALES.put(1046, new Locale("pt", "BR"));
        LOCALES.put(2070, new Locale("pt", "PT"));
        LOCALES.put(1047, new Locale("rm"));
        LOCALES.put(1048, new Locale("ro"));
        LOCALES.put(2072, new Locale("ro", "MO"));
        LOCALES.put(1049, new Locale("ru"));
        LOCALES.put(2073, new Locale("ru", "MO"));
        LOCALES.put(1103, new Locale("sa"));
        LOCALES.put(1070, new Locale("sb"));
        LOCALES.put(1113, new Locale("sd"));
        LOCALES.put(1115, new Locale("si"));
        LOCALES.put(1051, new Locale("sk"));
        LOCALES.put(1060, new Locale("sl"));
        LOCALES.put(1143, new Locale("so"));
        LOCALES.put(1052, new Locale("sq"));
        LOCALES.put(3098, new Locale("sr", "SP", "Cyrl"));
        LOCALES.put(2074, new Locale("sr", "SP", "Latn"));
        LOCALES.put(2077, new Locale("sv", "FI"));
        LOCALES.put(1053, new Locale("sv", "SE"));
        LOCALES.put(1089, new Locale("sw"));
        LOCALES.put(1097, new Locale("ta"));
        LOCALES.put(1098, new Locale("te"));
        LOCALES.put(1064, new Locale("tg"));
        LOCALES.put(1054, new Locale("th"));
        LOCALES.put(1090, new Locale("tk"));
        LOCALES.put(1074, new Locale("tn"));
        LOCALES.put(1055, new Locale("tr"));
        LOCALES.put(1073, new Locale("ts"));
        LOCALES.put(1092, new Locale("tt"));
        LOCALES.put(1058, new Locale("uk"));
        LOCALES.put(1056, new Locale("ur"));
        LOCALES.put(0, new Locale("UTF_8"));
        LOCALES.put(2115, new Locale("uz", "UZ", "Cyrl"));
        LOCALES.put(1091, new Locale("uz", "UZ", "Latn"));
        LOCALES.put(1066, new Locale("vi"));
        LOCALES.put(1076, new Locale("xh"));
        LOCALES.put(1085, new Locale("yi"));
        LOCALES.put(2052, new Locale("zh", "CN"));
        LOCALES.put(3076, new Locale("zh", "HK"));
        LOCALES.put(5124, new Locale("zh", "MO"));
        LOCALES.put(4100, new Locale("zh", "SG"));
        LOCALES.put(1028, new Locale("zh", "TW"));
        LOCALES.put(1077, new Locale("zu"));
    }

    static interface PartHandler {
        public String handlePart(Matcher var1, String var2, CellFormatType var3, StringBuffer var4);
    }
}

