/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.util;

import org.apache.poi.hssf.record.FullColorExt;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.util.HexDump;

public final class HSSFColorExt
extends HSSFColor {
    private final FullColorExt _colorExt;

    public HSSFColorExt(FullColorExt colorExt) {
        this._colorExt = colorExt;
    }

    public FullColorExt getFullColorExt() {
        return this._colorExt;
    }

    @Override
    public short getIndex() {
        return this._colorExt.isIndex() ? (short)this._colorExt.getXclrValue() : HSSFColor.HSSFColorPredefined.AUTOMATIC.getIndex();
    }

    public HSSFColor getSimilarColor(HSSFPalette palette) {
        short[] rgb = this.getTriplet();
        short red = rgb[0];
        short green = rgb[1];
        short blue = rgb[2];
        return palette.findSimilarColor(red, green, blue);
    }

    public boolean isIndex() {
        return this._colorExt.isIndex();
    }

    public boolean isTheme() {
        return this._colorExt.isTheme();
    }

    public boolean isRgb() {
        return this._colorExt.isRGB();
    }

    public boolean isTint() {
        return this._colorExt.isTint();
    }

    public double getTint() {
        return this._colorExt.getTint();
    }

    @Override
    public short[] getTriplet() {
        if (this._colorExt.isRGB() || this._colorExt.isTheme()) {
            int color = this._colorExt.getRGB();
            short[] rgb = new short[]{(short)(color >> 16 & 0xFF), (short)(color >> 8 & 0xFF), (short)(color & 0xFF)};
            return rgb;
        }
        return HSSFColor.HSSFColorPredefined.AUTOMATIC.getTriplet();
    }

    @Override
    public String getHexString() {
        short[] rgb = this.getTriplet();
        if (rgb != null) {
            String r = new String(HexDump.byteToHex(rgb[0]));
            String g = new String(HexDump.byteToHex(rgb[1]));
            String b = new String(HexDump.byteToHex(rgb[2]));
            return (String)(rgb[0] == 0 ? "0" : r + r) + ":" + (String)(rgb[1] == 0 ? "0" : g + g) + ":" + (String)(rgb[2] == 0 ? "0" : b + b);
        }
        return HSSFColor.HSSFColorPredefined.AUTOMATIC.getHexString();
    }
}

