/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFEvaluationCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.formula.EvaluationCell;
import org.apache.poi.ss.formula.EvaluationSheet;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.util.Internal;

@Internal
final class HSSFEvaluationSheet
implements EvaluationSheet {
    private final HSSFSheet _hs;

    public HSSFEvaluationSheet(HSSFSheet hs) {
        this._hs = hs;
    }

    public HSSFSheet getHSSFSheet() {
        return this._hs;
    }

    @Override
    public int getLastRowNum() {
        return this._hs.getLastRowNum();
    }

    @Override
    public boolean isRowHidden(int rowIndex) {
        HSSFRow row = this._hs.getRow(rowIndex);
        if (row == null) {
            return false;
        }
        return row.getZeroHeight();
    }

    @Override
    public EvaluationCell getCell(int rowIndex, int columnIndex) {
        HSSFRow row = this._hs.getRow(rowIndex);
        if (row == null) {
            return null;
        }
        HSSFCell cell = row.getCell(columnIndex);
        if (cell == null) {
            return null;
        }
        return new HSSFEvaluationCell(cell, this);
    }

    @Override
    public void clearAllCachedResultValues() {
    }

    @Override
    public Iterator<EvaluationCell> nonEmptyCellsIterator(int rowStart, int rowEnd, int columnStart, int columnEnd) {
        ArrayList<EvaluationCell> cells = new ArrayList<EvaluationCell>(rowEnd - rowStart);
        for (int i = rowStart; i < rowEnd; ++i) {
            for (int j = columnStart; j <= columnEnd; ++j) {
                EvaluationCell evaluationCell = this.getCell(i, j);
                if (evaluationCell == null || evaluationCell.getCellType() == CellType.BLANK) continue;
                cells.add(evaluationCell);
            }
        }
        return cells.iterator();
    }

    @Override
    public Iterator<EvaluationCell> nonEmptyCellsIterator(int columnIndex) {
        int rowStart = this._hs.getFirstRowNum();
        int rowEnd = this._hs.getLastRowNum();
        ArrayList<EvaluationCell> cells = new ArrayList<EvaluationCell>(rowEnd - rowStart);
        for (int i = rowStart; i < rowEnd; ++i) {
            EvaluationCell evaluationCell = this.getCell(i, columnIndex);
            if (evaluationCell == null || evaluationCell.getCellType() == CellType.BLANK) continue;
            cells.add(evaluationCell);
        }
        return cells.iterator();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._hs == null ? 0 : this._hs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HSSFEvaluationSheet other = (HSSFEvaluationSheet)obj;
        return this._hs == other._hs;
    }

    @Override
    public boolean isHidden(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public boolean isFiltered() {
        return false;
    }
}

